/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import org.biojava.nbio.ontology.Term;
import org.biojava.nbio.ontology.Triple;
import umich.ms.datatypes.lcmsrun.Hash;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.datatypes.lcmsrun.MsSoftware;
import umich.ms.datatypes.lcmsrun.OriginalFile;
import umich.ms.datatypes.scan.props.Instrument;
import umich.ms.fileio.exceptions.RunHeaderBoundsNotFound;
import umich.ms.fileio.exceptions.RunHeaderParsingException;
import umich.ms.fileio.filetypes.mzml.MZMLFile;
import umich.ms.fileio.filetypes.mzml.jaxb.CVParamType;
import umich.ms.fileio.filetypes.mzml.jaxb.ComponentListType;
import umich.ms.fileio.filetypes.mzml.jaxb.ComponentType;
import umich.ms.fileio.filetypes.mzml.jaxb.DataProcessingType;
import umich.ms.fileio.filetypes.mzml.jaxb.FileDescriptionType;
import umich.ms.fileio.filetypes.mzml.jaxb.InstrumentConfigurationType;
import umich.ms.fileio.filetypes.mzml.jaxb.MzMLType;
import umich.ms.fileio.filetypes.mzml.jaxb.ProcessingMethodType;
import umich.ms.fileio.filetypes.mzml.jaxb.ReferenceableParamGroupRefType;
import umich.ms.fileio.filetypes.mzml.jaxb.ReferenceableParamGroupType;
import umich.ms.fileio.filetypes.mzml.jaxb.RunType;
import umich.ms.fileio.filetypes.mzml.jaxb.SoftwareType;
import umich.ms.fileio.filetypes.mzml.jaxb.SourceFileType;
import umich.ms.fileio.filetypes.mzml.util.InstrumentModelCVTerm;
import umich.ms.fileio.filetypes.mzml.util.PSIMSCV;
import umich.ms.fileio.filetypes.mzxml.XmlBasedRunHeaderParser;
import umich.ms.fileio.filetypes.util.AbstractFile;
import umich.ms.fileio.filetypes.xmlbased.OffsetLength;
import umich.ms.logging.LogHelper;
import umich.ms.util.StringUtils;

public class MZMLRunHeaderParser
extends XmlBasedRunHeaderParser {
    protected MZMLFile source;
    public static final String TAG_MZML = "mzML";
    public static final String TAG_SPECTRUMLIST = "spectrumList";
    public static final String TAG_RUN = "run";

    public MZMLRunHeaderParser(MZMLFile source) {
        this.source = source;
        LogHelper.setJavolutionLogLevelFatal();
    }

    @Override
    public LCMSRunInfo parse() throws RunHeaderParsingException {
        OffsetLength headerLocation;
        try {
            headerLocation = this.locateRunHeader(TAG_MZML, true, true, TAG_RUN, true, false);
        }
        catch (RunHeaderParsingException e) {
            if (e instanceof RunHeaderBoundsNotFound) {
                return LCMSRunInfo.getDummyRunInfo();
            }
            throw e;
        }
        MzMLType parsedInfo = this.parseHeaderWithJAXB(MzMLType.class, headerLocation);
        LCMSRunInfo runInfo = new LCMSRunInfo();
        FileDescriptionType fileDescription = parsedInfo.getFileDescription();
        if (fileDescription != null) {
            List<SourceFileType> sourceFile = fileDescription.getSourceFileList().getSourceFile();
            for (SourceFileType source : sourceFile) {
                String location = source.getLocation();
                String name = source.getName();
                Hash hash = null;
                for (CVParamType cvParam : source.getCvParam()) {
                    if (PSIMSCV.MS_HASH_SHA1.accession.equals(cvParam.getAccession())) {
                        hash = new Hash(cvParam.getValue(), Hash.TYPE.SHA1);
                        continue;
                    }
                    if (!PSIMSCV.MS_HASH_MD5.accession.equals(cvParam.getAccession())) continue;
                    hash = new Hash(cvParam.getValue(), Hash.TYPE.MD5);
                }
                runInfo.getOriginalFiles().add(new OriginalFile(location, name, hash));
            }
        }
        List<SoftwareType> software = parsedInfo.getSoftwareList().getSoftware();
        for (SoftwareType soft : software) {
            String name = soft.getId();
            String id = soft.getId();
            String version = soft.getVersion();
            for (CVParamType cv : soft.getCvParam()) {
                if (cv.getName() == null || cv.getName().isEmpty()) continue;
                name = cv.getName();
            }
            runInfo.getSoftware().add(new MsSoftware(name, version));
        }
        List<InstrumentConfigurationType> instruments = parsedInfo.getInstrumentConfigurationList().getInstrumentConfiguration();
        if (instruments.size() > 0) {
            for (InstrumentConfigurationType i : instruments) {
                if (i.getId() == null) {
                    throw new RunHeaderParsingException("Could not find instrument ID attribute. Should be <instrumentConfiguration id=\"xxx\">");
                }
                String msInstrumentID = i.getId();
                Instrument instrument = new Instrument();
                boolean isInstrumentCvParamFound = false;
                boolean isVendorCvParamFound = false;
                if (!i.getCvParam().isEmpty()) {
                    for (CVParamType cvParam : i.getCvParam()) {
                        if (this.lookupInstrumentCV(cvParam, instrument)) {
                            isInstrumentCvParamFound = true;
                        }
                        if (this.lookupInstrumentVendor(cvParam, instrument)) {
                            isVendorCvParamFound = true;
                        }
                        if (!PSIMSCV.MS_INSTRUMENT_SERIAL_NUMBER.accession.equals(cvParam.getAccession())) continue;
                        instrument.setSerialNumber(cvParam.getValue());
                    }
                }
                if (!isInstrumentCvParamFound && !i.getReferenceableParamGroupRef().isEmpty()) {
                    List<ReferenceableParamGroupRefType> refGrps = i.getReferenceableParamGroupRef();
                    for (ReferenceableParamGroupRefType refGrpRef : refGrps) {
                        ReferenceableParamGroupType refGrp = (ReferenceableParamGroupType)refGrpRef.getRef();
                        for (CVParamType cvParam : refGrp.getCvParam()) {
                            if (this.lookupInstrumentCV(cvParam, instrument)) {
                                isInstrumentCvParamFound = true;
                            }
                            if (this.lookupInstrumentVendor(cvParam, instrument)) {
                                isVendorCvParamFound = true;
                            }
                            if (!PSIMSCV.MS_INSTRUMENT_SERIAL_NUMBER.accession.equals(cvParam.getAccession())) continue;
                            instrument.setSerialNumber(cvParam.getValue());
                        }
                    }
                }
                if (!isInstrumentCvParamFound && !isVendorCvParamFound) {
                    instrument.setManufacturer("Vendor N/A");
                    instrument.setModel("Model N/A");
                } else if (!isInstrumentCvParamFound && isVendorCvParamFound) {
                    instrument.setModel("Model N/A");
                }
                ComponentListType componentList = i.getComponentList();
                if (componentList != null) {
                    String msAnalyzer = this.componentTypeListToString(componentList.getAnalyzer(), PSIMSCV.MAP_ANALYZER_TYPE);
                    instrument.setAnalyzer(msAnalyzer);
                    instrument.setDetector("");
                    String ionization = this.componentTypeListToString(componentList.getSource(), PSIMSCV.MAP_IONIZATION_TYPE);
                    instrument.setIonisation(ionization);
                }
                runInfo.addInstrument(instrument, msInstrumentID);
            }
        } else {
            runInfo.addInstrument(Instrument.getDummy(), "ID_UNKNOWN");
        }
        RunType run = parsedInfo.getRun();
        if (run == null) {
            throw new RunHeaderParsingException("Could not find <run> tag, which is needed to get default instrument ID");
        }
        Object defaultInstrumentConfigurationRef = run.getDefaultInstrumentConfigurationRef();
        if (!(defaultInstrumentConfigurationRef instanceof InstrumentConfigurationType)) {
            throw new RunHeaderParsingException("Could not find \"defaultInstrumentConfigurationRef\" attribute of <run> tag, it is required by mzML standard");
        }
        InstrumentConfigurationType instrument = (InstrumentConfigurationType)defaultInstrumentConfigurationRef;
        runInfo.setDefaultInstrumentID(instrument.getId());
        XMLGregorianCalendar startTimeStamp = run.getStartTimeStamp();
        if (startTimeStamp != null) {
            GregorianCalendar cal = startTimeStamp.toGregorianCalendar();
            Date date = cal.getTime();
            runInfo.setRunStartTime(date);
        }
        List<DataProcessingType> dataProcessings = parsedInfo.getDataProcessingList().getDataProcessing();
        block10: for (DataProcessingType dataProcessing : dataProcessings) {
            for (ProcessingMethodType processingMethodType : dataProcessing.getProcessingMethod()) {
                for (CVParamType cvParam : processingMethodType.getCvParam()) {
                    if (!PSIMSCV.isPeakPickingTerm(cvParam.getAccession())) continue;
                    runInfo.setCentroided(true);
                    break block10;
                }
            }
        }
        return runInfo;
    }

    private boolean lookupInstrumentCV(CVParamType cvParam, Instrument instrument) {
        InstrumentModelCVTerm instrumentModelCVTerm = PSIMSCV.instrumentFromAccession(cvParam.getAccession());
        if (instrumentModelCVTerm != null) {
            instrument.setManufacturer(instrumentModelCVTerm.vendor);
            instrument.setModel(instrumentModelCVTerm.model);
            return true;
        }
        return false;
    }

    private boolean lookupInstrumentVendor(CVParamType cvParam, Instrument instrument) {
        String accession = cvParam.getAccession();
        try {
            Triple triple;
            Term object;
            Term term = PSIMSCV.ONTOLOGY.getTerm(accession);
            Set<Triple> term_is_a = PSIMSCV.ONTOLOGY.getTriples(term, null, null);
            if (term_is_a.size() == 1 && (object = (triple = term_is_a.iterator().next()).getObject()).getName().equalsIgnoreCase(PSIMSCV.MS_INSTRUMENT_MODEL.accession)) {
                String vendor = term.getDescription();
                vendor = vendor.replaceAll(PSIMSCV.MS_INSTRUMENT_MODEL.description, "");
                instrument.setManufacturer(vendor);
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return false;
    }

    private String componentTypeListToString(List<? extends ComponentType> comps, Map<String, Term> whitelist) {
        ArrayList<String> strings = new ArrayList<String>();
        for (ComponentType componentType : comps) {
            List<CVParamType> cvParams = componentType.getCvParam();
            for (CVParamType cvParam : cvParams) {
                String accession = cvParam.getAccession();
                if (accession.equals(PSIMSCV.MS_INSTRUMENT_COMPONENT_SOURCE.accession) || accession.equals(PSIMSCV.MS_INSTRUMENT_COMPONENT_ANALYZER.accession) || accession.equals(PSIMSCV.MS_INSTRUMENT_COMPONENT_DETECTOR.accession) || whitelist != null && !whitelist.containsKey(accession)) continue;
                strings.add(cvParam.getName());
            }
        }
        return StringUtils.join(strings, ", ");
    }

    @Override
    protected <T> T convertJAXBObjectToDomain(Class<T> clazz, Object unmarshalled) throws RunHeaderParsingException {
        if (unmarshalled == null) {
            throw new RunHeaderParsingException("Unmarshalled run header object (mzML) was null");
        }
        if (!(unmarshalled instanceof JAXBElement)) {
            throw new RunHeaderParsingException("When parsing mzML run header, JAXB unmarshalling produced an unknown object");
        }
        JAXBElement jaxbElement = (JAXBElement)unmarshalled;
        if (jaxbElement.getValue() == null) {
            throw new RunHeaderParsingException("When parsing mzML run header, JAXB unmarshalled value was null");
        }
        Class<?> parsedClass = jaxbElement.getValue().getClass();
        if (!clazz.isAssignableFrom(parsedClass)) {
            throw new RunHeaderParsingException(String.format("When parsing mzML run header, JAXB object's declared type was wrong. Expected: %s; Found: %s", clazz.getSimpleName(), parsedClass.getSimpleName()));
        }
        return (T)jaxbElement.getValue();
    }

    @Override
    protected InputStream getRunHeaderInputStream(OffsetLength msRunLocation) throws RunHeaderParsingException {
        try {
            RandomAccessFile raf = this.source.getRandomAccessFile();
            raf.seek(msRunLocation.offset);
            String closingTags = "</run></mzML>";
            byte[] msRunCloseBytes = closingTags.getBytes(StandardCharsets.UTF_8);
            byte[] bytes = new byte[msRunLocation.length + msRunCloseBytes.length];
            raf.readFully(bytes, 0, bytes.length);
            System.arraycopy(msRunCloseBytes, 0, bytes, msRunLocation.length, msRunCloseBytes.length);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(bytes));
            return bufferedInputStream;
        }
        catch (IOException e) {
            throw new RunHeaderParsingException(e);
        }
        finally {
            this.source.close();
        }
    }

    @Override
    public AbstractFile getAbstractFile() {
        return this.source;
    }
}

