/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzxml;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;
import javolution.xml.internal.stream.XMLStreamReaderImpl;
import org.apache.commons.pool2.ObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.scan.StorageStrategy;
import umich.ms.datatypes.scancollection.impl.ScanCollectionDefault;
import umich.ms.datatypes.spectrum.ISpectrum;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzxml.MZXMLIndex;
import umich.ms.fileio.filetypes.mzxml.MZXMLIndexElement;
import umich.ms.fileio.filetypes.mzxml.MZXMLIndexParser;
import umich.ms.fileio.filetypes.mzxml.MZXMLMultiSpectraParser;
import umich.ms.fileio.filetypes.mzxml.MZXMLRunHeaderParser;
import umich.ms.fileio.filetypes.util.MultiSpectraParser;
import umich.ms.fileio.filetypes.xmlbased.AbstractXMLBasedDataSource;
import umich.ms.fileio.filetypes.xmlbased.IndexBuilder;
import umich.ms.fileio.util.FileListing;
import umich.ms.logging.LogHelper;
import umich.ms.util.DoubleRange;
import umich.ms.util.Interval1D;
import umich.ms.util.IntervalST;

public class MZXMLFile
extends AbstractXMLBasedDataSource<MZXMLIndexElement, MZXMLIndex> {
    private MZXMLIndex index;

    public MZXMLFile(String path) {
        super(path);
    }

    public MZXMLFile(String path, boolean excludeEmptyScans) {
        super(path);
        this.excludeEmptyScans = excludeEmptyScans;
    }

    public ObjectPool<XMLStreamReaderImpl> getReaderPool() {
        return this.readerPool;
    }

    @Override
    public MZXMLIndex getIndex() {
        return this.index;
    }

    @Override
    public MZXMLIndex parseIndex() throws FileParsingException {
        MZXMLIndexParser parser = new MZXMLIndexParser(this);
        MZXMLIndex parsed = parser.parse();
        return parsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MZXMLIndex fetchIndex() throws FileParsingException {
        MZXMLIndex tmp = this.index;
        if (tmp == null) {
            MZXMLFile mZXMLFile = this;
            synchronized (mZXMLFile) {
                tmp = this.getIndex();
                if (tmp == null) {
                    this.index = tmp = this.parseIndex();
                }
            }
        }
        return tmp;
    }

    @Override
    public LCMSRunInfo parseRunInfo() throws FileParsingException {
        MZXMLRunHeaderParser parser = new MZXMLRunHeaderParser(this);
        return parser.parse();
    }

    @Override
    protected void releaseResources() {
        this.index = null;
    }

    @Override
    public MZXMLMultiSpectraParser getSpectraParser(InputStream inputStream, LCMSDataSubset subset, ObjectPool<XMLStreamReaderImpl> readerPool, Integer numSpectra) {
        MZXMLMultiSpectraParser parser;
        try {
            parser = new MZXMLMultiSpectraParser(inputStream, subset, this);
        }
        catch (FileParsingException ex) {
            throw new IllegalStateException(ex);
        }
        parser.setNumScansToProcess(numSpectra);
        parser.setReaderPool(readerPool);
        return parser;
    }

    @Override
    public IndexBuilder<MZXMLIndexElement> getIndexBuilder(IndexBuilder.Info info) {
        MultiSpectraParser parser = this.getSpectraParser(info.is, LCMSDataSubset.STRUCTURE_ONLY, (ObjectPool)this.getReaderPool(), (Integer)null);
        MZXMLMultiSpectraParser.MZXMLIndexBuilder builder = ((MZXMLMultiSpectraParser)parser).getIndexBuilder(info);
        return builder;
    }

    @Override
    protected MZXMLIndex fixIndex(MZXMLIndex idx) {
        super.fixIndex(idx);
        int curInternalNum = 1;
        MZXMLIndex newIndex = new MZXMLIndex();
        Set entries = idx.getMapByNum().entrySet();
        for (Map.Entry entry : entries) {
            MZXMLIndexElement eOld = (MZXMLIndexElement)entry.getValue();
            MZXMLIndexElement eNew = new MZXMLIndexElement(curInternalNum, eOld.getRawNumber(), eOld.getOffsetLength());
            newIndex.add(eNew);
            ++curInternalNum;
        }
        return newIndex;
    }

    public static void main(String[] args) throws FileParsingException, JAXBException {
        LogHelper.configureJavaUtilLogging();
        Logger logger = LoggerFactory.getLogger(MZXMLFile.class);
        if (args.length == 0) {
            System.out.println("Give me a dollar. And a list of mzXML files. E.g.: \n\tjava -jar msftbx.jar ./*.mzXML");
            System.exit(0);
        }
        String[] filenames = args;
        Integer numThreads = null;
        Integer numSpectraPerThread = 50;
        ArrayList<Path> paths = new ArrayList<Path>();
        for (int i = 0; i < filenames.length; ++i) {
            Path path;
            String filename = filenames[i];
            if (i == 0) {
                try {
                    int numThreadsParsed = Integer.parseInt(filename);
                    numThreads = numThreadsParsed;
                    System.out.printf("Setting number of threads to: %d\n", numThreadsParsed);
                    continue;
                }
                catch (NumberFormatException numThreadsParsed) {
                    // empty catch block
                }
            }
            if (i == 1) {
                try {
                    int numSpectraPerThreadParsed = Integer.parseInt(filename);
                    numSpectraPerThread = numSpectraPerThreadParsed;
                    System.out.printf("Setting number of spectra per thread to: %d\n", numSpectraPerThreadParsed);
                    continue;
                }
                catch (NumberFormatException numSpectraPerThreadParsed) {
                    // empty catch block
                }
            }
            if (!Files.exists(path = Paths.get(filename, new String[0]).toAbsolutePath(), new LinkOption[0])) {
                System.err.println("File does not exist: " + path.toString());
                System.exit(1);
            }
            if (Files.isRegularFile(path, new LinkOption[0])) {
                paths.add(path);
                continue;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            FileListing fileListing = new FileListing(path, ".*\\.mzXML");
            fileListing.setFollowLinks(false);
            fileListing.setRecursive(false);
            paths.addAll(fileListing.findFiles());
        }
        for (Path path : paths) {
            double fileSize = path.toFile().length() / 0x100000L;
            System.out.printf("File: %s (%.2fMb)\n", path.toString(), fileSize);
            MZXMLFile mzxml = new MZXMLFile(path.toString(), false);
            mzxml.setNumThreadsForParsing(numThreads);
            mzxml.setTasksPerCpuPerBatch(numSpectraPerThread);
            mzxml.setParsingTimeout(30000L);
            long startTime = System.nanoTime();
            MZXMLIndex idx = mzxml.fetchIndex();
            if (idx.size() > 0) {
                MZXMLIndexElement byNum = (MZXMLIndexElement)idx.getByNum(1);
                MZXMLIndexElement byRawNum = (MZXMLIndexElement)idx.getByRawNum(byNum.getRawNumber());
                MZXMLIndexElement byId = (MZXMLIndexElement)idx.getById(byNum.getId());
                boolean bl = true;
            } else {
                System.err.println("Parsed index was empty!");
            }
            NavigableMap index = mzxml.fetchIndex().getMapByNum();
            double timeSpentParsingIndex = (double)(System.nanoTime() - startTime) / 1.0E9;
            System.out.printf("It took: %.2f seconds to parse index (%d spectra)\n", timeSpentParsingIndex, index.size());
            LCMSRunInfo lcmsRunInfo = mzxml.fetchRunInfo();
            ScanCollectionDefault scanCollection = null;
            boolean parseList = false;
            if (parseList) {
                startTime = System.nanoTime();
                mzxml.time_reading = 0L;
                List<Integer> integers = Arrays.asList(index.keySet().toArray(new Integer[0]));
                List<IScan> parsedScans = mzxml.parse(integers);
                scanCollection = new ScanCollectionDefault(false);
                for (IScan parsedScan : parsedScans) {
                    scanCollection.addScan(parsedScan);
                }
                double timeSpentParsingStructure = (double)(System.nanoTime() - startTime) / 1.0E9;
                int numSpectraStructure = scanCollection.getScanCount();
                System.out.printf("It took: %.2f seconds to parse structure of all scans (%d spectra, %.2f spec/s, %.2f Mb/s)\n", timeSpentParsingStructure, numSpectraStructure, (double)numSpectraStructure / timeSpentParsingStructure, fileSize / timeSpentParsingStructure);
                mzxml.time_reading = 0L;
            } else {
                startTime = System.nanoTime();
                mzxml.time_reading = 0L;
                LCMSDataSubset subset = LCMSDataSubset.WHOLE_RUN;
                scanCollection = new ScanCollectionDefault(false);
                scanCollection.setDataSource(mzxml);
                scanCollection.loadData(subset, StorageStrategy.STRONG);
                boolean loadMs2 = false;
                if (loadMs2) {
                    HashSet<Integer> msLvl2 = new HashSet<Integer>();
                    msLvl2.add(2);
                    IntervalST<Double, TreeMap<Integer, IScan>> ms2ranges = scanCollection.getMapMsLevel2rangeGroups().get(2);
                    if (ms2ranges != null) {
                        Iterator<IntervalST.Node<Double, TreeMap<Integer, IScan>>> ms2RangesIter = ms2ranges.iterator();
                        IntervalST.Node<Double, TreeMap<Integer, IScan>> firstNode = ms2RangesIter.next();
                        Interval1D<Double> interval = firstNode.getInterval();
                        DoubleRange doubleRange = DoubleRange.fromInterval1D(interval);
                        ArrayList<DoubleRange> doubleRanges = new ArrayList<DoubleRange>(1);
                        doubleRanges.add(doubleRange);
                        List<IScan> listMS2ScansFirstGroup = mzxml.parse(new LCMSDataSubset(null, null, msLvl2, doubleRanges));
                        int a = 1;
                        IntervalST.Node<Double, TreeMap<Integer, IScan>> secondGroup = ms2RangesIter.next();
                        List<Integer> scanNumsInSecondGroup = Arrays.asList(secondGroup.getValue().keySet().toArray(new Integer[0]));
                        List<IScan> list = mzxml.parse(scanNumsInSecondGroup);
                        a = 2;
                    }
                }
                double timeSpentParsingSpectra = (double)(System.nanoTime() - startTime) / 1.0E9;
                int numSpectra = scanCollection.getScanCount();
                System.out.printf("It took: %.2f seconds to parse all scans (%d spectra, %.2f spec/s, %.2f Mb/s)\n", timeSpentParsingSpectra, numSpectra, (double)numSpectra / timeSpentParsingSpectra, fileSize / timeSpentParsingSpectra);
                double timeIO = (double)mzxml.time_reading / 1.0E9;
                System.out.printf("Out of which %.2fs were spent on IO (%.2fMb/s).\n", timeIO, fileSize / timeIO);
                mzxml.time_reading = 0L;
            }
            if (!scanCollection.getMapNum2scan().isEmpty()) {
                IScan scan = scanCollection.getMapNum2scan().firstEntry().getValue();
                ISpectrum spectrum = scan.getSpectrum();
                if (spectrum != null) {
                    double[] mzs = spectrum.getMZs();
                    System.out.print("First ten valus of m/z array of the 1st scan:\n\t");
                    for (int i = 0; i < mzs.length && i < 10; ++i) {
                        System.out.printf("%.3f ", mzs[i]);
                    }
                    System.out.println();
                } else {
                    System.out.println("The first scan is there, but the spectrum has not been parsed.");
                }
            }
            TreeMap<Integer, IScan> num2scanMap = scanCollection.getMapNum2scan();
            Set<Map.Entry<Integer, IScan>> num2scanEntries = num2scanMap.entrySet();
            int counterMzIntPairs = 0;
            for (Map.Entry<Integer, IScan> next : num2scanEntries) {
                IScan scan = next.getValue();
                if (scan.getSpectrum() == null) continue;
                counterMzIntPairs += scan.getSpectrum().getMZs().length;
            }
            System.out.printf("Total number of mz-intensity pairs: %d\n", counterMzIntPairs);
            DecimalFormat formatter = new DecimalFormat("0.##E0");
            double doubleArraysSizeMb = (double)counterMzIntPairs * 2.0 * 8.0 / 1048576.0;
            System.out.printf("Thas is: %s (%.2fMB in doubles)\n", formatter.format(counterMzIntPairs), doubleArraysSizeMb);
            TreeMap<Integer, IntervalST<Double, TreeMap<Integer, IScan>>> mapMsLevel2rangeGroups = scanCollection.getMapMsLevel2rangeGroups();
            Set<Map.Entry<Integer, IntervalST<Double, TreeMap<Integer, IScan>>>> entries = mapMsLevel2rangeGroups.entrySet();
            for (Map.Entry<Integer, IntervalST<Double, TreeMap<Integer, IScan>>> next : entries) {
                Integer msLevel = next.getKey();
                IntervalST<Double, TreeMap<Integer, IScan>> mzRangesAtMsLevel = next.getValue();
                System.out.printf("Tree at MS level: %d\n", msLevel);
                for (IntervalST.Node<Double, TreeMap<Integer, IScan>> node : mzRangesAtMsLevel) {
                    System.out.printf("Interval: %s contains %d scans\n", node.getInterval().toString(), node.getValue().size());
                }
                System.out.println("=================");
                System.out.println();
            }
        }
    }
}

