/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzxml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import umich.ms.datatypes.lcmsrun.Hash;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.datatypes.lcmsrun.MsSoftware;
import umich.ms.datatypes.lcmsrun.OriginalFile;
import umich.ms.datatypes.scan.props.Instrument;
import umich.ms.fileio.exceptions.RunHeaderBoundsNotFound;
import umich.ms.fileio.exceptions.RunHeaderParsingException;
import umich.ms.fileio.filetypes.mzxml.MZXMLFile;
import umich.ms.fileio.filetypes.mzxml.XmlBasedRunHeaderParser;
import umich.ms.fileio.filetypes.mzxml.jaxb.MsRun;
import umich.ms.fileio.filetypes.mzxml.jaxb.OntologyEntryType;
import umich.ms.fileio.filetypes.mzxml.jaxb.Software;
import umich.ms.fileio.filetypes.util.AbstractFile;
import umich.ms.fileio.filetypes.xmlbased.OffsetLength;
import umich.ms.logging.LogHelper;

public class MZXMLRunHeaderParser
extends XmlBasedRunHeaderParser {
    protected MZXMLFile source;
    public static final String TAG_MSRUN = "msRun";
    public static final String TAG_SCAN = "scan";

    public MZXMLRunHeaderParser(MZXMLFile source) {
        this.source = source;
        LogHelper.setJavolutionLogLevelFatal();
    }

    @Override
    public LCMSRunInfo parse() throws RunHeaderParsingException {
        OffsetLength msRunLocation;
        try {
            msRunLocation = this.locateRunHeader(TAG_MSRUN, true, true, TAG_SCAN, true, true);
        }
        catch (RunHeaderParsingException e) {
            if (e instanceof RunHeaderBoundsNotFound) {
                return LCMSRunInfo.getDummyRunInfo();
            }
            throw e;
        }
        MsRun parsedInfo = this.parseHeaderWithJAXB(MsRun.class, msRunLocation);
        LCMSRunInfo runInfo = new LCMSRunInfo();
        List<MsRun.ParentFile> parentFiles = parsedInfo.getParentFile();
        for (MsRun.ParentFile parentFile : parentFiles) {
            String file = parentFile.getFileName();
            file = file.replaceAll("\\\\", "/");
            String location = "";
            String fileName = file;
            try {
                Path path = Paths.get(file, new String[0]);
                location = path.getParent().toString();
                fileName = path.getFileName().toString();
            }
            catch (InvalidPathException e) {
                try {
                    URI uri = URI.create(file).normalize();
                    String uriPath = uri.getPath();
                    while (uriPath.startsWith("/")) {
                        uriPath = uriPath.substring(1);
                    }
                    Path path = Paths.get(uriPath, new String[0]);
                    location = path.getParent().toString();
                    fileName = path.getFileName().toString();
                }
                catch (IllegalArgumentException uri) {
                    // empty catch block
                }
            }
            Hash hash = null;
            if (parentFile.getFileSha1() != null && !parentFile.getFileSha1().isEmpty()) {
                hash = new Hash(parentFile.getFileSha1(), Hash.TYPE.SHA1);
            }
            runInfo.getOriginalFiles().add(new OriginalFile(location, fileName, hash));
        }
        List<MsRun.MsInstrument> msInstruments = parsedInfo.getMsInstrument();
        if (msInstruments.size() > 0) {
            for (MsRun.MsInstrument i : msInstruments) {
                String msInstrumentID;
                if (i.getMsInstrumentID() != null) {
                    msInstrumentID = i.getMsInstrumentID();
                } else if (i.getStringInstrumentID() != null) {
                    msInstrumentID = i.getStringInstrumentID();
                } else if (msInstruments.size() == 1) {
                    msInstrumentID = "ID_UNKNOWN";
                } else {
                    throw new RunHeaderParsingException("Could not find instrument ID attribute. Should be <msInstrument msInstrumentID='xxx'> or <msInstrument id='xxx'>");
                }
                Instrument instrument = new Instrument();
                MsRun.MsInstrument.MsManufacturer msManufacturer = i.getMsManufacturer();
                String manufacturer = msManufacturer != null ? msManufacturer.getValueOntologyEntryType() : "Vendor N/A";
                instrument.setManufacturer(manufacturer);
                OntologyEntryType msModel = i.getMsModel();
                String model = msModel != null ? msModel.getValueOntologyEntryType() : "Model N/A";
                instrument.setModel(model);
                MsRun.MsInstrument.MsMassAnalyzer msMassAnalyzer = i.getMsMassAnalyzer();
                String analyzer = msMassAnalyzer != null ? msMassAnalyzer.getValueOntologyEntryType() : "Analyzer N/A";
                instrument.setAnalyzer(analyzer);
                OntologyEntryType msDetector = i.getMsDetector();
                String detector = msDetector != null ? msDetector.getValueOntologyEntryType() : "Detector N/A";
                instrument.setDetector(detector);
                OntologyEntryType msIonisation = i.getMsIonisation();
                String ionisation = msIonisation != null ? msIonisation.getValueOntologyEntryType() : "Ionisation N/A";
                instrument.setIonisation(ionisation);
                runInfo.addInstrument(instrument, msInstrumentID);
            }
        } else {
            runInfo.addInstrument(Instrument.getDummy(), "ID_UNKNOWN");
        }
        List<MsRun.DataProcessing> dataProcessings = parsedInfo.getDataProcessing();
        for (MsRun.DataProcessing dataProcessing : dataProcessings) {
            Software software;
            if (dataProcessing.isCentroided() != null) {
                runInfo.setCentroided(dataProcessing.isCentroided());
            }
            if ((software = dataProcessing.getSoftware()) == null) continue;
            MsSoftware msSoftware = new MsSoftware(software.getName(), software.getVersion());
            runInfo.getSoftware().add(msSoftware);
        }
        return runInfo;
    }

    @Override
    protected <T> T convertJAXBObjectToDomain(Class<T> clazz, Object unmarshalled) throws RunHeaderParsingException {
        if (unmarshalled == null) {
            throw new RunHeaderParsingException("Unmarshalled run header object was null");
        }
        if (!clazz.isAssignableFrom(unmarshalled.getClass())) {
            throw new RunHeaderParsingException(String.format("When parsing mzML run header, JAXB object's declared type was wrong. Expected: %s; Found: %s", clazz.getSimpleName(), unmarshalled.getClass().getSimpleName()));
        }
        return (T)unmarshalled;
    }

    @Override
    protected InputStream getRunHeaderInputStream(OffsetLength msRunLocation) throws RunHeaderParsingException {
        try {
            RandomAccessFile raf = this.source.getRandomAccessFile();
            raf.seek(msRunLocation.offset);
            String closingTags = "</msRun>";
            byte[] msRunCloseBytes = closingTags.getBytes(StandardCharsets.UTF_8);
            byte[] bytes = new byte[msRunLocation.length + msRunCloseBytes.length];
            raf.readFully(bytes, 0, bytes.length);
            System.arraycopy(msRunCloseBytes, 0, bytes, msRunLocation.length, msRunCloseBytes.length);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(bytes));
            return bufferedInputStream;
        }
        catch (IOException e) {
            throw new RunHeaderParsingException(e);
        }
        finally {
            this.source.close();
        }
    }

    @Override
    public AbstractFile getAbstractFile() {
        return this.source;
    }
}

