/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzxml;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javolution.text.CharArray;
import javolution.xml.internal.stream.XMLStreamReaderImpl;
import javolution.xml.stream.XMLStreamException;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.fileio.exceptions.RunHeaderBoundsNotFound;
import umich.ms.fileio.exceptions.RunHeaderParsingException;
import umich.ms.fileio.filetypes.util.AbstractFile;
import umich.ms.fileio.filetypes.xmlbased.OffsetLength;
import umich.ms.logging.LogHelper;

public abstract class XmlBasedRunHeaderParser {
    protected abstract InputStream getRunHeaderInputStream(OffsetLength var1) throws RunHeaderParsingException;

    protected abstract <T> T convertJAXBObjectToDomain(Class<T> var1, Object var2) throws RunHeaderParsingException;

    public abstract AbstractFile getAbstractFile();

    public abstract LCMSRunInfo parse() throws RunHeaderParsingException;

    protected <T> T parseHeaderWithJAXB(Class<T> clazz, OffsetLength msRunLocation) throws RunHeaderParsingException {
        T parsedInfo;
        ClassLoader classLoaderOrig = Thread.currentThread().getContextClassLoader();
        try {
            InputStream runHeaderInputStream = this.getRunHeaderInputStream(msRunLocation);
            String packageName = clazz.getPackage().getName();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            JAXBContext ctx = JAXBContext.newInstance((String)packageName, (ClassLoader)this.getClass().getClassLoader());
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            Object unmarshalled = unmarshaller.unmarshal(runHeaderInputStream);
            parsedInfo = this.convertJAXBObjectToDomain(clazz, unmarshalled);
        }
        catch (JAXBException e) {
            throw new RunHeaderParsingException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoaderOrig);
        }
        if (parsedInfo == null) {
            throw new RunHeaderParsingException("Something happened while unmarshalling MsRun header, MsRun was null.");
        }
        return parsedInfo;
    }

    protected OffsetLength locateRunHeader(String firstTag, boolean firstTagIsStart, boolean firstTagGetStartLoc, String lastTag, boolean lastTagIsStart, boolean lastTagGetStartLoc) throws RunHeaderParsingException {
        XMLStreamReaderImpl reader = new XMLStreamReaderImpl();
        LogHelper.setJavolutionLogLevelFatal();
        long headerStartOffset = -1L;
        long headerEndOffset = -1L;
        int MAX_OFFSET = 0x100000;
        try {
            int eventType;
            BufferedInputStream bis = this.getAbstractFile().getBufferedInputStream();
            reader.setInput(bis, StandardCharsets.UTF_8.name());
            do {
                eventType = reader.next();
                switch (eventType) {
                    case 1: {
                        CharArray localName = reader.getLocalName();
                        if (firstTagIsStart && localName.equals(firstTag)) {
                            if (firstTagGetStartLoc) {
                                headerStartOffset = reader.getLocation().getLastStartTagPos();
                                break;
                            }
                            headerStartOffset = reader.getLocation().getCharacterOffset();
                            break;
                        }
                        if (!lastTagIsStart || !localName.equals(lastTag)) break;
                        if (lastTagGetStartLoc) {
                            headerEndOffset = reader.getLocation().getLastStartTagPos();
                            break;
                        }
                        headerEndOffset = reader.getLocation().getCharacterOffset();
                        break;
                    }
                    case 2: {
                        CharArray localName = reader.getLocalName();
                        if (!firstTagIsStart && localName.equals(firstTag)) {
                            if (firstTagGetStartLoc) {
                                headerStartOffset = reader.getLocation().getLastStartTagPos();
                                break;
                            }
                            headerStartOffset = reader.getLocation().getCharacterOffset();
                            break;
                        }
                        if (lastTagIsStart || !localName.equals(lastTag)) break;
                        if (lastTagGetStartLoc) {
                            headerEndOffset = reader.getLocation().getLastStartTagPos();
                            break;
                        }
                        headerEndOffset = reader.getLocation().getCharacterOffset();
                        break;
                    }
                    case 4: {
                        if (!reader.isWhiteSpace()) break;
                    }
                }
                if (reader.getLocation().getCharacterOffset() <= 0x100000) continue;
                throw new RunHeaderBoundsNotFound(String.format("Could not locate the header of the file using <%s> starting tag and <%s> closing tag withing the first %d characters", firstTag, lastTag, 0x100000));
            } while (reader.hasNext() && eventType != 8 && (headerStartOffset == -1L || headerEndOffset == -1L));
            this.getAbstractFile().close();
        }
        catch (FileNotFoundException | XMLStreamException e) {
            throw new RunHeaderParsingException("Error when parsing MS run header info", e);
        }
        finally {
            this.getAbstractFile().close();
        }
        if (headerStartOffset == -1L || headerEndOffset == -1L) {
            throw new RunHeaderBoundsNotFound(String.format("Could not find <%s> opening and <%s> closing tags when parsing LCMS run header", firstTag, lastTag));
        }
        return new OffsetLength(headerStartOffset, (int)(headerEndOffset - headerStartOffset));
    }
}

