/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzxml.deprecated;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.helpers.DefaultHandler;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.scan.PeaksCompression;
import umich.ms.datatypes.scan.impl.ScanDefault;
import umich.ms.datatypes.scan.props.Polarity;
import umich.ms.datatypes.scan.props.PrecursorInfo;
import umich.ms.datatypes.spectrum.ISpectrum;
import umich.ms.datatypes.spectrum.impl.SpectrumDefault;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzxml.MZXMLPeaksDecoder;
import umich.ms.util.ByteArrayHolder;
import umich.ms.util.base64.Base64;
import umich.ms.util.base64.Base64Context;
import umich.ms.util.base64.Base64ContextPooled;

@Deprecated
class MZXMLListOfScanDefaultSAXHandler
extends DefaultHandler {
    private List<IScan> parsedScans;
    private ScanDefault curScan;
    private Double isolationWindowWidth = null;
    private int peaksCount = 0;
    private StringBuilder charBuffer = new StringBuilder(262144);
    private String compressionType = null;
    private Integer precision = null;
    private PrecursorInfo precursorInfo = null;
    private static DatatypeFactory dataFactory = null;
    private boolean removeEmptyScans;

    public MZXMLListOfScanDefaultSAXHandler(boolean removeEmptyScans, Integer numScansToBeProcessed) {
        this.removeEmptyScans = removeEmptyScans;
        this.parsedScans = numScansToBeProcessed != null ? new ArrayList<IScan>(numScansToBeProcessed) : new ArrayList<IScan>();
    }

    public boolean isRemoveEmptyScans() {
        return this.removeEmptyScans;
    }

    public void setRemoveEmptyScans(boolean removeEmptyScans) {
        this.removeEmptyScans = removeEmptyScans;
    }

    public List<IScan> getParsedScans() {
        return this.parsedScans;
    }

    private String checkTagLocalNameQualifiedName(String lName, String qName) throws SAXException {
        String tagName = null;
        if (lName != null && !lName.isEmpty()) {
            tagName = lName;
        } else if (qName != null && !qName.isEmpty()) {
            tagName = qName;
        } else {
            throw new SAXException("Found weird tag which had both localName and qualifiedName of zero size");
        }
        return tagName;
    }

    private String checkCurrentAttribute(Attributes attrs, String attrName, String tagName, boolean required) throws SAXNotRecognizedException {
        String attrValue = attrs.getValue(attrName);
        if (attrValue == null && (attrValue = attrs.getValue(attrName.toLowerCase())) == null && required) {
            throw new SAXNotRecognizedException("Could not find \"" + attrName + "\" property in <" + tagName + ">");
        }
        return attrValue;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        String tagName = this.checkTagLocalNameQualifiedName(lName, qName);
        if (tagName.equalsIgnoreCase("scan")) {
            this.addCurScanAndFlushVars();
            String curAttr = this.checkCurrentAttribute(attrs, "num", tagName, true);
            int scanNumber = Integer.parseInt(curAttr);
            curAttr = this.checkCurrentAttribute(attrs, "msLevel", tagName, true);
            int msLevel = Integer.parseInt(curAttr);
            curAttr = this.checkCurrentAttribute(attrs, "peaksCount", tagName, true);
            this.peaksCount = Integer.parseInt(curAttr);
            double retentionTime = -1.0;
            String retentionTimeStr = this.checkCurrentAttribute(attrs, "retentionTime", tagName, true);
            if (retentionTimeStr == null) {
                throw new SAXException("Could not read retention time for scan num: " + Integer.toString(scanNumber));
            }
            retentionTime = (double)dataFactory.newDuration(retentionTimeStr).getTimeInMillis(new Date()) / 1000.0 / 60.0;
            Polarity polarity = null;
            String polarityStr = this.checkCurrentAttribute(attrs, "polarity", tagName, false);
            if (polarityStr != null) {
                switch (polarityStr) {
                    case "+": {
                        polarity = Polarity.POSITIVE;
                        break;
                    }
                    case "-": {
                        polarity = Polarity.NEGATIVE;
                        break;
                    }
                    default: {
                        polarity = null;
                    }
                }
            }
            boolean centroided = false;
            String centroidedStr = this.checkCurrentAttribute(attrs, "centroided", tagName, false);
            if (centroidedStr != null && (centroidedStr.equals("1") || Boolean.parseBoolean(centroidedStr))) {
                centroided = true;
            }
            this.curScan = new ScanDefault(scanNumber, retentionTime, msLevel, centroided);
            this.curScan.setPolarity(polarity);
            return;
        }
        if (tagName.equalsIgnoreCase("peaks")) {
            this.charBuffer.setLength(0);
            String compressionTypeStr = this.checkCurrentAttribute(attrs, "compressionType", tagName, false);
            this.compressionType = compressionTypeStr == null || compressionTypeStr.equals("none") ? null : compressionTypeStr;
            String precisionStr = this.checkCurrentAttribute(attrs, "precision", tagName, false);
            this.precision = precisionStr != null ? Integer.valueOf(Integer.parseInt(precisionStr)) : Integer.valueOf(32);
            return;
        }
        if (tagName.equalsIgnoreCase("precursorMz")) {
            String windowWideness;
            this.charBuffer.setLength(0);
            this.precursorInfo = new PrecursorInfo();
            String parentScanNum = this.checkCurrentAttribute(attrs, "precursorScanNum", tagName, false);
            if (parentScanNum != null) {
                this.precursorInfo.setParentScanNum(Integer.parseInt(parentScanNum));
            }
            if ((windowWideness = this.checkCurrentAttribute(attrs, "windowWideness", tagName, false)) != null) {
                this.isolationWindowWidth = Double.parseDouble(windowWideness);
            }
            return;
        }
    }

    private void addCurScanAndFlushVars() {
        if (!(this.curScan == null || this.isRemoveEmptyScans() && this.peaksCount == 0)) {
            ISpectrum spectrum;
            if (this.precursorInfo != null && this.curScan.getMsLevel() > 1) {
                this.curScan.setPrecursor(this.precursorInfo);
            }
            if ((spectrum = this.curScan.getSpectrumRef().get()) != null) {
                if (this.curScan.getTic() == null) {
                    this.curScan.setTic(spectrum.getSumInt());
                }
                if (this.curScan.getScanMzWindowLower() == null) {
                    this.curScan.setScanMzWindowLower(spectrum.getMinMZ());
                }
                if (this.curScan.getScanMzWindowUpper() == null) {
                    this.curScan.setScanMzWindowUpper(spectrum.getMaxMZ());
                }
                if (this.curScan.getBasePeakIntensity() == null) {
                    this.curScan.setBasePeakIntensity(spectrum.getMaxInt());
                }
            }
            this.parsedScans.add(this.curScan);
        }
        this.curScan = null;
        this.precision = null;
        this.precursorInfo = null;
        this.compressionType = null;
        this.peaksCount = 0;
    }

    @Override
    public void endElement(String namespaceURI, String lName, String qName) throws SAXException {
        String tagName = this.checkTagLocalNameQualifiedName(lName, qName);
        if (tagName.equalsIgnoreCase("scan")) {
            this.addCurScanAndFlushVars();
            return;
        }
        if (tagName.equalsIgnoreCase("precursorMz")) {
            double precursorMzLo;
            double precursorMzHi = precursorMzLo = Double.parseDouble(this.charBuffer.toString());
            if (this.isolationWindowWidth != null) {
                precursorMzLo -= this.isolationWindowWidth / 2.0;
                precursorMzHi += this.isolationWindowWidth / 2.0;
            }
            this.precursorInfo.setMzRangeStart(precursorMzLo);
            this.precursorInfo.setMzRangeEnd(precursorMzHi);
            this.curScan.setPrecursor(this.precursorInfo);
            this.isolationWindowWidth = null;
            return;
        }
        if (tagName.equalsIgnoreCase("peaks")) {
            if (this.isRemoveEmptyScans() && this.charBuffer.length() == 0) {
                return;
            }
            try {
                char[] chars = new char[this.charBuffer.length()];
                this.charBuffer.getChars(0, this.charBuffer.length(), chars, 0);
                Base64 base64 = new Base64();
                Base64ContextPooled ctx = new Base64ContextPooled();
                Base64Context decodedB64 = base64.decode(chars, 0, chars.length, (Base64Context)ctx);
                ByteArrayHolder bah = decodedB64.readResults();
                PeaksCompression compression = PeaksCompression.NONE;
                if (this.compressionType != null && "zlib".equalsIgnoreCase(this.compressionType)) {
                    compression = PeaksCompression.ZLIB;
                }
                MZXMLPeaksDecoder.DecodedData decoded = MZXMLPeaksDecoder.decode(bah.getUnderlyingBytes(), bah.getPosition(), this.precision, compression);
                ((Base64Context)ctx).close();
                double basepeakMz = decoded.mzs.length == 0 ? 0.0 : decoded.mzs[decoded.maxIntensityPos];
                SpectrumDefault spectrum = new SpectrumDefault(decoded.mzs, decoded.intensities, decoded.minIntensity, decoded.minIntensityNonZero, decoded.maxIntensity, decoded.maxIntensityMz, decoded.intensitySum);
                this.curScan.setSpectrum(spectrum, false);
            }
            catch (IOException | DataFormatException | FileParsingException e) {
                throw new SAXException("A problem occurred when decoding Base64 peaks string.", e);
            }
            return;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.charBuffer.append(buf, offset, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            ClassLoader orig = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(MZXMLListOfScanDefaultSAXHandler.class.getClassLoader());
            try {
                dataFactory = DatatypeFactory.newInstance();
            }
            finally {
                Thread.currentThread().setContextClassLoader(orig);
            }
        }
        catch (DatatypeConfigurationException e) {
            Logger.getLogger(MZXMLListOfScanDefaultSAXHandler.class.getCanonicalName()).log(Level.SEVERE, "Couldn't construst DatatypeFactory.newInstance() in a static block");
        }
    }
}

