/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.pepxml.example;

import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import umich.ms.fileio.filetypes.pepxml.jaxb.primitive.MsmsPipelineAnalysis;
import umich.ms.fileio.filetypes.pepxml.jaxb.primitive.MsmsRunSummary;
import umich.ms.fileio.filetypes.pepxml.jaxb.primitive.SearchHit;
import umich.ms.fileio.filetypes.pepxml.jaxb.primitive.SearchResult;
import umich.ms.fileio.filetypes.pepxml.jaxb.primitive.SpectrumQuery;

public class PepXmlExample {
    public static void main(String[] args) throws Exception {
        String pathIn = args[0];
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(pathIn);
        File fileOut = Paths.get(pathIn + ".txt", new String[0]).toFile();
        try (PrintWriter printWriter = new PrintWriter(fileOut);){
            for (String path : paths) {
                MsmsRunSummary run;
                List<SpectrumQuery> queries;
                Path p = Paths.get(path, new String[0]).toAbsolutePath();
                File f = new File(p.toString());
                JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{MsmsPipelineAnalysis.class});
                Unmarshaller unmarshaller = ctx.createUnmarshaller();
                Object unmarshalled = unmarshaller.unmarshal(f);
                MsmsPipelineAnalysis pipelineAnalysis = (MsmsPipelineAnalysis)unmarshalled;
                if (pipelineAnalysis.getMsmsRunSummary().isEmpty()) {
                    PepXmlExample.error("MS/MS run summary was empty!");
                }
                if ((queries = (run = pipelineAnalysis.getMsmsRunSummary().get(0)).getSpectrumQuery()).isEmpty()) {
                    PepXmlExample.error("Spectrum queries table was empty!");
                }
                for (SpectrumQuery query : queries) {
                    SearchResult result;
                    List<SearchHit> searchHit;
                    List<SearchResult> searchResult = query.getSearchResult();
                    if (searchResult.isEmpty()) {
                        PepXmlExample.error(String.format("Search RESULT was empty for query #%d [spec id: %s]", query.getIndex(), query.getSpectrum()));
                    }
                    if ((searchHit = (result = searchResult.get(0)).getSearchHit()).isEmpty()) {
                        PepXmlExample.error(String.format("Search HIT was empty for query #%d [spec id: %s]", query.getIndex(), query.getSpectrum()));
                    }
                    for (SearchHit hit : searchHit) {
                        if (hit.getHitRank() > 10L) break;
                        String scoreStr = hit.getSearchScore().get(0).getValueStr();
                        Double scoreVal = Double.parseDouble(scoreStr);
                        printWriter.printf("%s,%d,%s,%s,%d\n", query.getSpectrum(), hit.getHitRank(), hit.getPeptide(), scoreStr, hit.getNumMatchedIons());
                    }
                }
            }
            printWriter.flush();
        }
    }

    private static void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }
}

