/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.pepxml.example;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import umich.ms.fileio.filetypes.pepxml.jaxb.nested.MsmsPipelineAnalysis;

public class PepXmlNestedExample {
    public static void main(String[] args) throws JAXBException {
        MsmsPipelineAnalysis.MsmsRunSummary run;
        List<MsmsPipelineAnalysis.MsmsRunSummary.SpectrumQuery> queries;
        String path = "G:\\tmp\\pepxml\\test_data\\interact-20130328_EXQ8_NaNa_SA_HeLa_rep04_06.pep.xml";
        Path p = Paths.get(path, new String[0]).toAbsolutePath();
        File f = new File(p.toString());
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{MsmsPipelineAnalysis.class});
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        Object unmarshalled = unmarshaller.unmarshal(f);
        MsmsPipelineAnalysis pipelineAnalysis = (MsmsPipelineAnalysis)unmarshalled;
        if (pipelineAnalysis.getMsmsRunSummary().isEmpty()) {
            PepXmlNestedExample.error("MS/MS run summary was empty!");
        }
        if ((queries = (run = pipelineAnalysis.getMsmsRunSummary().get(0)).getSpectrumQuery()).isEmpty()) {
            PepXmlNestedExample.error("Spectrum queries table was empty!");
        }
        for (MsmsPipelineAnalysis.MsmsRunSummary.SpectrumQuery query : queries) {
            boolean bl;
            MsmsPipelineAnalysis.MsmsRunSummary.SpectrumQuery.SearchResult.SearchHit firstHit;
            MsmsPipelineAnalysis.MsmsRunSummary.SpectrumQuery.SearchResult.SearchHit.ModificationInfo mods;
            MsmsPipelineAnalysis.MsmsRunSummary.SpectrumQuery.SearchResult result;
            List<MsmsPipelineAnalysis.MsmsRunSummary.SpectrumQuery.SearchResult.SearchHit> searchHit;
            List<MsmsPipelineAnalysis.MsmsRunSummary.SpectrumQuery.SearchResult> searchResult = query.getSearchResult();
            if (searchResult.isEmpty()) {
                PepXmlNestedExample.error(String.format("Search RESULT was empty for query #%d [spec id: %s]", query.getIndex(), query.getSpectrum()));
            }
            if ((searchHit = (result = searchResult.get(0)).getSearchHit()).isEmpty()) {
                PepXmlNestedExample.error(String.format("Search HIT was empty for query #%d [spec id: %s]", query.getIndex(), query.getSpectrum()));
            }
            if ((mods = (firstHit = searchHit.get(0)).getModificationInfo()) == null) continue;
            System.out.printf("mod info is not null for query #%d [spec id: %s]\n", query.getIndex(), query.getSpectrum());
            if (!mods.getModAminoacidMass().isEmpty()) {
                bl = true;
            }
            if (mods.getModCtermMass() != null) {
                bl = true;
            }
            if (mods.getModNtermMass() == null) continue;
            bl = true;
        }
        boolean a = true;
    }

    private static void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }
}

