/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.thermo.raw;

import com4j.ComException;
import com4j.ExecutionException;
import java.util.List;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.spectrum.ISpectrum;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.AbstractLCMSDataSource;
import umich.ms.fileio.filetypes.thermo.raw.ThermoRawIndex;
import umich.ms.fileio.filetypes.thermo.raw.com4j.ClassFactory;
import umich.ms.fileio.filetypes.thermo.raw.com4j.IXRawfile;
import umich.ms.fileio.filetypes.thermo.raw.com4j.IXRawfile5;

public class ThermoRawFile
extends AbstractLCMSDataSource<ThermoRawIndex> {
    protected ThermoRawIndex index;
    protected LCMSRunInfo runInfo;
    protected volatile IXRawfile5 xRawfile5 = null;

    public static boolean isPlatformSupported() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().startsWith("windows");
    }

    public static boolean isThermoLibInstalled() {
        try {
            IXRawfile xRawfile = ClassFactory.createMSFileReader_XRawfile();
            IXRawfile5 xRawfile5 = xRawfile.queryInterface(IXRawfile5.class);
            if (xRawfile5 == null) {
                return false;
            }
        }
        catch (ComException | ExecutionException ex) {
            return false;
        }
        return true;
    }

    protected synchronized IXRawfile5 fetchXrawfile() {
        if (this.xRawfile5 == null) {
            IXRawfile xRawfile = ClassFactory.createMSFileReader_XRawfile();
            this.xRawfile5 = xRawfile.queryInterface(IXRawfile5.class);
            this.xRawfile5.open(this.path);
        }
        return this.xRawfile5;
    }

    public static boolean isThermoSupportedHere() {
        return ThermoRawFile.isPlatformSupported() && ThermoRawFile.isThermoLibInstalled();
    }

    public ThermoRawFile(String path) {
        super(path);
    }

    @Override
    public String getName() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseMemory() {
        ThermoRawFile thermoRawFile = this;
        synchronized (thermoRawFile) {
            if (this.xRawfile5 != null) {
                this.xRawfile5.close();
                this.xRawfile5 = null;
            }
            this.index = null;
            this.runInfo = null;
        }
    }

    @Override
    public LCMSRunInfo parseRunInfo() throws FileParsingException {
        LCMSRunInfo info = new LCMSRunInfo();
        return null;
    }

    @Override
    public ThermoRawIndex getIndex() {
        return null;
    }

    @Override
    public ThermoRawIndex fetchIndex() throws FileParsingException {
        return null;
    }

    @Override
    public ThermoRawIndex parseIndex() throws FileParsingException {
        return null;
    }

    @Override
    public ISpectrum parseSpectrum(int num) throws FileParsingException {
        return null;
    }

    @Override
    public IScan parseScan(int num, boolean parseSpectrum) throws FileParsingException {
        return null;
    }

    @Override
    public List<IScan> parse(LCMSDataSubset subset) throws FileParsingException {
        return null;
    }

    @Override
    public List<IScan> parse(List<Integer> scanNums) throws FileParsingException {
        return null;
    }
}

