/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.util;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.commons.pool2.ObjectPool;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.util.ByteArrayHolder;
import umich.ms.util.PooledByteArrayHolders;

public class ZlibInflater {
    private static final transient ObjectPool<ByteArrayHolder> pool = PooledByteArrayHolders.getInstance().getPool();

    private ZlibInflater() {
    }

    public static ObjectPool<ByteArrayHolder> getPool() {
        return pool;
    }

    public static ByteArrayHolder zlibUncompressBuffer(byte[] compressed, Integer uncompressedLen) throws IOException, DataFormatException, FileParsingException {
        return ZlibInflater.zlibUncompressBuffer(compressed, compressed.length, uncompressedLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayHolder zlibUncompressBuffer(byte[] bytes, int length, Integer uncompressedLen) throws IOException, DataFormatException, FileParsingException {
        Inflater inflater = new Inflater();
        inflater.setInput(bytes, 0, length);
        int bufSize = uncompressedLen == null ? length * 2 : uncompressedLen;
        ByteArrayHolder bah = null;
        try {
            bah = pool.borrowObject();
        }
        catch (Exception e) {
            throw new FileParsingException("Could not borrow ByteArrayHolder from the pool.", e);
        }
        try {
            int pos = 0;
            bah.ensureCapacity(bufSize, false);
            while (!inflater.finished()) {
                if (pos != 0) {
                    bah.ensureHasSpace(length / 2);
                }
                pos += inflater.inflate(bah.getUnderlyingBytes(), pos, bah.getCapacityLeft());
                bah.setPosition(pos);
            }
        }
        finally {
            inflater.end();
        }
        return bah;
    }
}

