/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.xmlbased;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javolution.xml.internal.stream.XMLStreamReaderImpl;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.impl.SoftReferenceObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.datatypes.index.Index;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.spectrum.ISpectrum;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.AbstractLCMSDataSource;
import umich.ms.fileio.filetypes.util.MultiSpectraParser;
import umich.ms.fileio.filetypes.xmlbased.IndexBuilder;
import umich.ms.fileio.filetypes.xmlbased.OffsetLength;
import umich.ms.fileio.filetypes.xmlbased.XMLBasedIndexElement;
import umich.ms.fileio.filetypes.xmlbased.XMLStreamReaderFactory;
import umich.ms.util.ByteArrayHolder;
import umich.ms.util.PooledByteArrayHolders;

public abstract class AbstractXMLBasedDataSource<E extends XMLBasedIndexElement, I extends Index<E>>
extends AbstractLCMSDataSource<I> {
    private final int INDEX_BUILDER_MIN_READ_SIZE = 1024;
    private final int INDEX_BUILDER_MIN_OVERLAP = 512;
    private final int INDEX_BUILDER_READ_BUF_SIZE = 0x800000;
    protected transient ObjectPool<XMLStreamReaderImpl> readerPool = this.instantiateReaderPool();
    public volatile transient long time_reading = 0L;
    Logger log = LoggerFactory.getLogger(AbstractXMLBasedDataSource.class);

    public AbstractXMLBasedDataSource(String path) {
        super(path);
    }

    @Override
    public String getName() {
        return this.getPath();
    }

    @Override
    public void releaseMemory() {
        this.runInfo = null;
        this.readerPool.close();
        this.readerPool = this.instantiateReaderPool();
        this.releaseResources();
        System.gc();
    }

    protected abstract void releaseResources();

    protected ObjectPool<XMLStreamReaderImpl> instantiateReaderPool() {
        return new SoftReferenceObjectPool<XMLStreamReaderImpl>(new XMLStreamReaderFactory());
    }

    @Override
    public List<IScan> parse(LCMSDataSubset subset) throws FileParsingException {
        Integer scanNumHi;
        Integer scanNumLo;
        Object idx = this.fetchIndex();
        if (idx.getMapByNum().isEmpty()) {
            return Collections.emptyList();
        }
        LCMSRunInfo inf = this.fetchRunInfo();
        NavigableMap idxMap = idx.getMapByNum();
        NavigableMap subIdx = idxMap.subMap(scanNumLo = subset.getScanNumLo() == null ? (Integer)idxMap.firstKey() : idxMap.ceilingKey(subset.getScanNumLo()), true, scanNumHi = subset.getScanNumHi() == null ? (Integer)idxMap.lastKey() : idxMap.floorKey(subset.getScanNumHi()), true);
        if (subIdx.isEmpty()) {
            throw new FileParsingException("The run does not contain any spectra in the number range you provided!");
        }
        ArrayList<IScan> scans = new ArrayList<IScan>(subIdx.size());
        int numThreads = this.getNumThreadsForParsing();
        int numSpectraPerThread = this.getTasksPerCpuPerBatch();
        ExecutorService exec = Executors.newFixedThreadPool(numThreads);
        Set entrySet = subIdx.entrySet();
        Iterator idxEntriesIter = entrySet.iterator();
        int readLen = 262144;
        byte[] readBuf1 = new byte[readLen];
        byte[] readBuf2 = new byte[readLen];
        try {
            RandomAccessFile raf = this.getRandomAccessFile();
            ArrayList<OffsetLength> readTasks = null;
            do {
                if (Thread.interrupted()) {
                    this.log.debug("Main AbstractXMLBasedDataSource read thread was interrupted, parsing cancelled.");
                    throw new FileParsingException("Thread interrupted, parsing was cancelled.");
                }
                if (readTasks != null && !readTasks.isEmpty()) {
                    byte[] readBufTmp = readBuf1;
                    readBuf1 = readBuf2;
                    readBuf2 = readBufTmp;
                } else {
                    int numScansToRead = numThreads * numSpectraPerThread;
                    readTasks = new ArrayList<OffsetLength>(numScansToRead);
                    readBuf1 = this.readContinuousBatchOfSpectra(idxEntriesIter, raf, readBuf1, readTasks, numScansToRead);
                }
                int[] workerScanCounts = this.distributeParseLoad(numThreads, readTasks);
                ArrayList<Future<List<IScan>>> parseTasks = this.submitParseTasks(subset, this.runInfo, numThreads, exec, readBuf1, readTasks, workerScanCounts, true);
                int maxScansToReadInBatch = numThreads * numSpectraPerThread;
                readTasks = new ArrayList(maxScansToReadInBatch);
                if (idxEntriesIter.hasNext()) {
                    readBuf2 = this.readContinuousBatchOfSpectra(idxEntriesIter, raf, readBuf2, readTasks, maxScansToReadInBatch);
                }
                for (Future<List<IScan>> parseTask : parseTasks) {
                    try {
                        List<IScan> parsedScans = parseTask.get(this.getParsingTimeout(), TimeUnit.SECONDS);
                        if (parsedScans == null) continue;
                        for (IScan scan : parsedScans) {
                            scans.add(scan);
                        }
                    }
                    catch (InterruptedException | NullPointerException | ExecutionException | TimeoutException e) {
                        throw new FileParsingException(e);
                    }
                }
            } while (idxEntriesIter.hasNext() || !readTasks.isEmpty());
            this.close();
        }
        catch (IOException ex) {
            throw new FileParsingException(ex);
        }
        finally {
            this.close();
            exec.shutdown();
        }
        try {
            exec.awaitTermination(this.getParsingTimeout(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new FileParsingException(String.format("Executor pool failed to shut down in %d sec!", this.getParsingTimeout()), e);
        }
        return scans;
    }

    protected int[] distributeParseLoad(int numWorkers, ArrayList<OffsetLength> readTasks) {
        int[] workerScanCounts = new int[numWorkers];
        Arrays.fill(workerScanCounts, readTasks.size() / numWorkers);
        int leftoverScans = readTasks.size() % numWorkers;
        int i = 0;
        while (i < leftoverScans) {
            int n = i++;
            workerScanCounts[n] = workerScanCounts[n] + 1;
        }
        return workerScanCounts;
    }

    protected I fixIndex(I idx) {
        if (idx.size() < 2) {
            return idx;
        }
        NavigableMap map = idx.getMapByNum();
        Set entries = map.entrySet();
        Iterator it = entries.iterator();
        Map.Entry curr = it.next();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            OffsetLength currOfflen = ((XMLBasedIndexElement)curr.getValue()).getOffsetLength();
            OffsetLength nextOfflen = ((XMLBasedIndexElement)next.getValue()).getOffsetLength();
            ((XMLBasedIndexElement)curr.getValue()).setOffsetLength(new OffsetLength(currOfflen.offset, (int)(nextOfflen.offset - currOfflen.offset)));
            curr = next;
        }
        return idx;
    }

    protected ArrayList<Future<List<IScan>>> submitParseTasks(LCMSDataSubset subset, LCMSRunInfo info, int numWorkers, ExecutorService exec, byte[] readBuf1, ArrayList<OffsetLength> readTasks, int[] workerScanCounts, boolean areScansContinuous) {
        ArrayList<Future<List<IScan>>> parseTasks = new ArrayList<Future<List<IScan>>>(numWorkers);
        int numSpectraAssignedForParsing = 0;
        long baseOffset = readTasks.get((int)0).offset;
        int offsetInReadBufForCurWorker = 0;
        for (int thisWorkerScanCount : workerScanCounts) {
            ByteArrayInputStream bais;
            if (thisWorkerScanCount == 0) break;
            int readTaskLoNum = numSpectraAssignedForParsing;
            int readTaskHiNum = numSpectraAssignedForParsing + thisWorkerScanCount - 1;
            if (areScansContinuous) {
                OffsetLength readTaskLo = readTasks.get(readTaskLoNum);
                OffsetLength readTaskHi = readTasks.get(readTaskHiNum);
                int offsetInReadBuf = (int)(readTaskLo.offset - baseOffset);
                int lengthOfRead = (int)(readTaskHi.offset - readTaskLo.offset + (long)readTaskHi.length);
                bais = new ByteArrayInputStream(readBuf1, offsetInReadBuf, lengthOfRead);
            } else {
                int fullReadTasksLenForThisWorker = 0;
                for (int i = numSpectraAssignedForParsing; i <= readTaskHiNum; ++i) {
                    fullReadTasksLenForThisWorker += readTasks.get((int)i).length;
                }
                bais = new ByteArrayInputStream(readBuf1, offsetInReadBufForCurWorker, fullReadTasksLenForThisWorker);
                offsetInReadBufForCurWorker += fullReadTasksLenForThisWorker;
            }
            MultiSpectraParser parser = this.getSpectraParser(bais, subset, this.readerPool, thisWorkerScanCount);
            Future<List<IScan>> task = exec.submit(parser);
            parseTasks.add(task);
            numSpectraAssignedForParsing += thisWorkerScanCount;
        }
        return parseTasks;
    }

    public abstract MultiSpectraParser getSpectraParser(InputStream var1, LCMSDataSubset var2, ObjectPool<XMLStreamReaderImpl> var3, Integer var4);

    protected byte[] readContinuousBatchOfSpectra(Iterator<? extends Map.Entry<Integer, ? extends XMLBasedIndexElement>> entries, RandomAccessFile file, byte[] readBuf, ArrayList<OffsetLength> readTasks, int maxScansToReadInBatch) throws IOException {
        while (entries.hasNext() && readTasks.size() < maxScansToReadInBatch) {
            readTasks.add(entries.next().getValue().getOffsetLength());
        }
        OffsetLength readFirst = readTasks.get(0);
        OffsetLength readLast = readTasks.get(readTasks.size() - 1);
        long readOffset = readFirst.offset;
        int readLength = (int)(readLast.offset - readOffset + (long)readLast.length);
        if (readBuf.length < readLength) {
            readBuf = new byte[readLength];
        } else {
            Arrays.fill(readBuf, (byte)0);
        }
        long time_start = System.nanoTime();
        file.seek(readOffset);
        file.readFully(readBuf, 0, readLength);
        this.time_reading += System.nanoTime() - time_start;
        return readBuf;
    }

    protected byte[] readListOfSpectra(ListIterator<Integer> scanNumsIter, int maxScansToReadInBatch, ArrayList<OffsetLength> readTasks, NavigableMap<Integer, ? extends XMLBasedIndexElement> index, RandomAccessFile file, byte[] readBuf) throws IOException {
        int readLength;
        int spaceLeft;
        OffsetLength lastReadTask;
        long readOffset;
        if (!scanNumsIter.hasNext()) {
            throw new IllegalArgumentException("Scan number iterator had no active elements");
        }
        Arrays.fill(readBuf, (byte)2);
        Integer scanNumPrev = null;
        int batchStart = 0;
        int batchLen = 0;
        int readBufPos = 0;
        Integer scanNumCur = scanNumsIter.next();
        OffsetLength offsetLength = ((XMLBasedIndexElement)index.get(scanNumCur)).getOffsetLength();
        if (offsetLength == null) {
            throw new IllegalArgumentException("The scan number requested for reading was not in the index");
        }
        readTasks.add(offsetLength);
        ++batchLen;
        if (!scanNumsIter.hasNext() || maxScansToReadInBatch == 1) {
            int spaceLeft2 = readBuf.length - readBufPos;
            long readOffset2 = readTasks.get((int)batchStart).offset;
            int readLength2 = (int)(offsetLength.offset - readOffset2 + (long)offsetLength.length);
            if (spaceLeft2 < readLength2) {
                readBuf = Arrays.copyOf(readBuf, readBuf.length + readLength2);
            }
            file.seek(readOffset2);
            file.readFully(readBuf, readBufPos, readLength2);
            return readBuf;
        }
        while (scanNumsIter.hasNext() && readTasks.size() < maxScansToReadInBatch) {
            scanNumCur = scanNumsIter.next();
            offsetLength = ((XMLBasedIndexElement)index.get(scanNumCur)).getOffsetLength();
            if (offsetLength == null) {
                throw new IllegalArgumentException("The scan number requested for reading was not in the index");
            }
            Integer scanNumLower = index.lowerKey(scanNumCur);
            if (scanNumPrev != scanNumLower) {
                readOffset = readTasks.get((int)batchStart).offset;
                lastReadTask = readTasks.get(batchStart + batchLen - 1);
                spaceLeft = readBuf.length - readBufPos;
                readLength = (int)(lastReadTask.offset - readOffset + (long)lastReadTask.length);
                if (spaceLeft < readLength) {
                    readBuf = Arrays.copyOf(readBuf, readBuf.length + readLength);
                }
                file.seek(readOffset);
                file.readFully(readBuf, readBufPos, readLength);
                readBufPos += readLength;
                batchLen = 0;
                batchStart = readTasks.size();
            }
            readTasks.add(offsetLength);
            ++batchLen;
            scanNumPrev = scanNumCur;
        }
        if (batchLen > 0) {
            readOffset = readTasks.get((int)batchStart).offset;
            lastReadTask = readTasks.get(batchStart + batchLen - 1);
            spaceLeft = readBuf.length - readBufPos;
            readLength = (int)(lastReadTask.offset - readOffset + (long)lastReadTask.length);
            if (spaceLeft < readLength) {
                readBuf = Arrays.copyOf(readBuf, readBuf.length + readLength);
            }
            file.seek(readOffset);
            file.readFully(readBuf, readBufPos, readLength);
        }
        return readBuf;
    }

    @Override
    @Deprecated
    public List<IScan> parse(List<Integer> scanNums) throws FileParsingException {
        if (scanNums.isEmpty()) {
            throw new IllegalArgumentException("The scan list you provided contained no valid scan numbers.");
        }
        Object idx = this.fetchIndex();
        LCMSRunInfo inf = this.fetchRunInfo();
        for (Integer scanNum : scanNums) {
            if (idx.getByNum(scanNum) != null) continue;
            throw new IllegalArgumentException(String.format("One of the scan numbers you requested didn't exist in the Index (scan #%d)", scanNum));
        }
        ArrayList<IScan> scans = new ArrayList<IScan>(scanNums.size());
        int numWorkers = this.getNumThreadsForParsing();
        int numSpectraPerWorker = this.getTasksPerCpuPerBatch();
        ExecutorService exec = Executors.newFixedThreadPool(numWorkers);
        ListIterator<Integer> scanNumsIter = scanNums.listIterator();
        LCMSDataSubset subset = LCMSDataSubset.WHOLE_RUN;
        byte[] readBuf1 = new byte[262144];
        byte[] readBuf2 = new byte[262144];
        try {
            RandomAccessFile raf = this.getRandomAccessFile();
            ArrayList<OffsetLength> readTasks = null;
            do {
                if (Thread.interrupted()) {
                    throw new FileParsingException("Thread interrupted, parsing was cancelled.");
                }
                if (readTasks != null && !readTasks.isEmpty()) {
                    byte[] readBufTmp = readBuf1;
                    readBuf1 = readBuf2;
                    readBuf2 = readBufTmp;
                } else {
                    int maxScansToReadInBatch = numWorkers * numSpectraPerWorker;
                    readTasks = new ArrayList<OffsetLength>(maxScansToReadInBatch);
                    readBuf1 = this.readListOfSpectra(scanNumsIter, maxScansToReadInBatch, readTasks, idx.getMapByNum(), raf, readBuf1);
                }
                int[] workerScanCounts = this.distributeParseLoad(numWorkers, readTasks);
                ArrayList<Future<List<IScan>>> parseTasks = this.submitParseTasks(subset, this.runInfo, numWorkers, exec, readBuf1, readTasks, workerScanCounts, false);
                int maxScansToReadInBatch = numWorkers * numSpectraPerWorker;
                readTasks = new ArrayList(maxScansToReadInBatch);
                if (scanNumsIter.hasNext()) {
                    readBuf2 = this.readListOfSpectra(scanNumsIter, maxScansToReadInBatch, readTasks, idx.getMapByNum(), raf, readBuf2);
                }
                for (Future<List<IScan>> parseTask : parseTasks) {
                    try {
                        List<IScan> parsedScans = parseTask.get(this.getParsingTimeout(), TimeUnit.SECONDS);
                        if (parsedScans == null) continue;
                        for (IScan scan : parsedScans) {
                            scans.add(scan);
                        }
                    }
                    catch (InterruptedException | NullPointerException | ExecutionException | TimeoutException e) {
                        throw new FileParsingException(e);
                    }
                }
            } while (scanNumsIter.hasNext() || !readTasks.isEmpty());
            this.close();
        }
        catch (IOException ex) {
            throw new FileParsingException(ex);
        }
        finally {
            this.close();
            exec.shutdown();
        }
        try {
            exec.awaitTermination(this.getParsingTimeout(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new FileParsingException(String.format("Executor pool failed to shut down in %d sec!", this.getParsingTimeout()), e);
        }
        return scans;
    }

    @Override
    public IScan parseScan(int num, boolean parseSpectrum) throws FileParsingException {
        NavigableMap idx = this.fetchIndex().getMapByNum();
        LCMSRunInfo info = this.fetchRunInfo();
        XMLBasedIndexElement indexElement = (XMLBasedIndexElement)idx.get(num);
        if (indexElement == null) {
            throw new FileParsingException(String.format("No such scan number found in the index [%d]", num));
        }
        OffsetLength offsetLength = indexElement.getOffsetLength();
        if (offsetLength == null) {
            throw new IllegalArgumentException("The scan you've requested to parse spectrumRef for was not found in the index");
        }
        try {
            IScan scan;
            MultiSpectraParser parser;
            List scansParsed;
            long offset = offsetLength.offset;
            int length = offsetLength.length;
            ByteArrayHolder bah = PooledByteArrayHolders.getInstance().getPool().borrowObject();
            bah.ensureCapacity(length);
            RandomAccessFile raf = this.getRandomAccessFile();
            raf.seek(offset);
            raf.readFully(bah.getUnderlyingBytes(), 0, length);
            bah.setPosition(length);
            ByteArrayInputStream is = new ByteArrayInputStream(bah.getUnderlyingBytes(), 0, length);
            LCMSDataSubset subset = LCMSDataSubset.WHOLE_RUN;
            if (!parseSpectrum) {
                subset = LCMSDataSubset.STRUCTURE_ONLY;
            }
            if ((scansParsed = (List)(parser = this.getSpectraParser(is, subset, this.readerPool, 1)).call()) == null || scansParsed.isEmpty()) {
                throw new FileParsingException("Could not parse a single spectrumRef from the file");
            }
            if (scansParsed.size() != 1) {
                throw new FileParsingException("Somehow more than one scan was parsed, when we tried to parse a single spectrumRef");
            }
            IScan iScan = scan = (IScan)scansParsed.get(0);
            return iScan;
        }
        catch (Exception e) {
            throw new FileParsingException(e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public ISpectrum parseSpectrum(int num) throws FileParsingException {
        IScan scan = this.parseScan(num, true);
        if (scan == null) {
            throw new FileParsingException("Could not parse spectrumRef from file");
        }
        return scan.getSpectrum();
    }

    public I buildIndex(I idx) throws FileParsingException {
        int numWorkers = this.getNumThreadsForParsing();
        ExecutorService exec = Executors.newFixedThreadPool(numWorkers);
        int readLen = 0x800000;
        byte[] readBuf1 = new byte[readLen];
        byte[] readBuf2 = new byte[readLen];
        boolean isBuf2Filled = false;
        long readBufOffset = -1L;
        ArrayList<E> unfinishedIndexElements = new ArrayList<E>(100);
        try {
            RandomAccessFile raf = this.getRandomAccessFile();
            long fileLen = raf.length();
            if (fileLen == 0L) {
                throw new FileParsingException("File size was zero when trying to build index.");
            }
            long posCur = 0L;
            long posNext = -1L;
            int fileLenInt = fileLen >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)fileLen;
            int curReadLen = Math.min(fileLenInt, readLen);
            int iteration = 0;
            do {
                ++iteration;
                if (Thread.interrupted()) {
                    throw new FileParsingException("Thread interrupted, parsing was cancelled.");
                }
                if (isBuf2Filled) {
                    byte[] readBufTmp = readBuf1;
                    readBuf1 = readBuf2;
                    readBuf2 = readBufTmp;
                } else {
                    raf.seek(posCur);
                    readBufOffset = raf.getFilePointer();
                    raf.readFully(readBuf1, 0, curReadLen);
                    posCur = raf.getFilePointer();
                }
                IndexBuilder.Info[] infos = this.distributeIndexBuilders(readBuf1, curReadLen, readBufOffset, numWorkers);
                List<Future<IndexBuilder.Result<E>>> futures = this.submitIndexBuilders(infos, exec);
                if (posCur < fileLen) {
                    posNext = posCur - 512L;
                    assert (posNext > 0L);
                    curReadLen = posNext + (long)curReadLen <= fileLen ? curReadLen : (int)(fileLen - posNext);
                    raf.seek(posNext);
                    readBufOffset = posNext;
                    raf.readFully(readBuf2, 0, curReadLen);
                    posCur = raf.getFilePointer();
                    isBuf2Filled = true;
                } else {
                    isBuf2Filled = false;
                }
                for (Future<IndexBuilder.Result<E>> future : futures) {
                    try {
                        IndexBuilder.Result<E> result = future.get(this.getParsingTimeout(), TimeUnit.SECONDS);
                        if (result != null) {
                            List<E> indexElements = result.getIndexElements();
                            for (XMLBasedIndexElement indexElement : indexElements) {
                                idx.add((XMLBasedIndexElement)indexElement);
                            }
                            List<E> unfinishedElems = result.getUnfinishedIndexElements();
                            if (unfinishedElems.isEmpty()) continue;
                            unfinishedIndexElements.addAll(unfinishedElems);
                            continue;
                        }
                        throw new FileParsingException("Result was null, which should never happen");
                    }
                    catch (InterruptedException | NullPointerException | ExecutionException | TimeoutException e) {
                        throw new FileParsingException(e);
                    }
                }
            } while (posCur < fileLen || isBuf2Filled);
            if (!unfinishedIndexElements.isEmpty()) {
                for (XMLBasedIndexElement e : unfinishedIndexElements) {
                    XMLBasedIndexElement byNum = (XMLBasedIndexElement)idx.getByNum(e.getNumber());
                    if (byNum != null) continue;
                    idx.add((XMLBasedIndexElement)e);
                }
            }
            idx = this.fixIndex(idx);
            this.close();
        }
        catch (IOException ex) {
            throw new FileParsingException(ex);
        }
        finally {
            this.close();
            exec.shutdown();
        }
        try {
            exec.awaitTermination(this.getParsingTimeout(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new FileParsingException(String.format("Executor pool failed to shut down in %d sec!", this.getParsingTimeout()), e);
        }
        return idx;
    }

    private IndexBuilder.Info[] distributeIndexBuilders(byte[] readBuf, int bytesValid, long offsetInFile, int numWorkers) {
        if (bytesValid == 0) {
            return new IndexBuilder.Info[0];
        }
        int baseReadLen = 1536;
        if (bytesValid <= 1536) {
            ByteArrayInputStream is = new ByteArrayInputStream(readBuf, 0, bytesValid);
            IndexBuilder.Info worker = new IndexBuilder.Info(offsetInFile, 0L, is);
            return new IndexBuilder.Info[]{worker};
        }
        double bytesPerWorker = ((double)bytesValid + (double)((numWorkers - 1) * 512)) / (double)numWorkers;
        double numWorkersForMinReadLengths = (double)(bytesValid - 512) / 1024.0;
        int bpw = (int)Math.ceil(bytesPerWorker);
        int nwfmrl = (int)Math.ceil(numWorkersForMinReadLengths);
        int numAssignedWorkers = Math.min(numWorkers, nwfmrl);
        IndexBuilder.Info[] workers = new IndexBuilder.Info[numAssignedWorkers];
        int curOffset = 0;
        int curReadLen = numAssignedWorkers == numWorkers ? bpw : 1536;
        for (int i = 0; i < workers.length; ++i) {
            IndexBuilder.Info worker;
            ByteArrayInputStream is = new ByteArrayInputStream(readBuf, curOffset, curReadLen);
            workers[i] = worker = new IndexBuilder.Info(offsetInFile, curOffset, is);
            if ((curOffset += curReadLen - 512) + curReadLen <= bytesValid) continue;
            curReadLen = bytesValid - curOffset;
        }
        return workers;
    }

    public abstract IndexBuilder<E> getIndexBuilder(IndexBuilder.Info var1);

    private List<Future<IndexBuilder.Result<E>>> submitIndexBuilders(IndexBuilder.Info[] builders, ExecutorService exec) {
        ArrayList<Future<IndexBuilder.Result<Future<E>>>> result = new ArrayList<Future<IndexBuilder.Result<Future<E>>>>(builders.length);
        for (IndexBuilder.Info info : builders) {
            IndexBuilder<E> builder = this.getIndexBuilder(info);
            Future<E> task = exec.submit(builder);
            result.add(task);
        }
        return result;
    }
}

