/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.xmlbased;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import umich.ms.fileio.filetypes.xmlbased.XMLBasedIndexElement;

public interface IndexBuilder<T extends XMLBasedIndexElement>
extends Callable<Result<T>> {
    public Result<T> buildIndex(Info var1) throws Exception;

    public static class Result<T extends XMLBasedIndexElement> {
        private Info info;
        private List<T> indexElements;
        private List<T> unfinishedIndexElements;

        public Result(Info info) {
            this.info = info;
            this.indexElements = new ArrayList<T>(100);
            this.unfinishedIndexElements = new ArrayList<T>(1);
        }

        public List<T> getIndexElements() {
            return this.indexElements;
        }

        public List<T> getUnfinishedIndexElements() {
            return this.unfinishedIndexElements;
        }

        public boolean addIndexElement(T indexElement) {
            return this.indexElements.add(indexElement);
        }

        public boolean addUnfinishedIndexElement(T indexElement) {
            return this.unfinishedIndexElements.add(indexElement);
        }

        public Info getInfo() {
            return this.info;
        }
    }

    public static class Info {
        public final long offsetInFile;
        public final long offsetInBuffer;
        public final InputStream is;

        public Info(long offsetInFile, long offsetInBuffer, InputStream is) {
            this.offsetInFile = offsetInFile;
            this.offsetInBuffer = offsetInBuffer;
            this.is = is;
        }
    }
}

