/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.logging;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;
import javolution.context.LogContext;
import org.slf4j.Logger;

public class LogHelper {
    private LogHelper() {
    }

    public static final void setJavolutionLogLevel(Logger log) {
        if (log.isTraceEnabled()) {
            LogContext.enter().setLevel(LogContext.Level.DEBUG);
        } else if (log.isDebugEnabled()) {
            LogContext.enter().setLevel(LogContext.Level.DEBUG);
        } else if (log.isInfoEnabled()) {
            LogContext.enter().setLevel(LogContext.Level.INFO);
        } else if (log.isWarnEnabled()) {
            LogContext.enter().setLevel(LogContext.Level.WARNING);
        } else if (log.isErrorEnabled()) {
            LogContext.enter().setLevel(LogContext.Level.ERROR);
        } else {
            LogContext.enter().setLevel(LogContext.Level.FATAL);
        }
    }

    public static final void setJavolutionLogLevel(LogContext.Level level) {
        LogContext.enter().setLevel(level);
    }

    public static final void setJavolutionLogLevelFatal() {
        LogContext.enter().setLevel(LogContext.Level.FATAL);
    }

    public static final void configureJavaUtilLogging() {
        try (InputStream is = LogHelper.class.getResourceAsStream("logging.properties");){
            if (is == null) {
                throw new IOException("Can't find/open logging.properties");
            }
            LogManager logMan = LogManager.getLogManager();
            logMan.readConfiguration(is);
        }
        catch (IOException e) {
            java.util.logging.Logger.getAnonymousLogger().severe("Could not load development logging.properties file using LogHelper.class.getResourceAsStream(\"/logging.properties\")");
            java.util.logging.Logger.getAnonymousLogger().severe(e.getMessage());
        }
    }
}

