/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.util.base64;

import java.nio.charset.StandardCharsets;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.util.base64.Base64Context;

public class Base64 {
    static final int EOF = -1;
    public static final int MIME_CHUNK_SIZE = 76;
    public static final int PEM_CHUNK_SIZE = 64;
    public static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected static final int MASK_8BITS = 255;
    protected static final byte PAD_DEFAULT = 61;
    protected final byte PAD = (byte)61;
    private final int unencodedBlockSize;
    private final int encodedBlockSize;
    protected final int lineLength;
    private final int chunkSeparatorLength;
    private static final int BITS_PER_ENCODED_BYTE = 6;
    private static final int BYTES_PER_UNENCODED_BLOCK = 3;
    private static final int BYTES_PER_ENCODED_BLOCK = 4;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final int MASK_6BITS = 63;
    private final byte[] encodeTable;
    private final byte[] decodeTable = DECODE_TABLE;
    private final byte[] lineSeparator;
    private final int decodeSize;
    private final int encodeSize;

    public Base64() {
        this(0);
    }

    protected Base64(int lineLength) {
        this(lineLength, CHUNK_SEPARATOR, false);
    }

    public Base64(int lineLength, byte[] lineSeparator, boolean urlSafe) {
        this.unencodedBlockSize = 3;
        this.encodedBlockSize = 4;
        this.chunkSeparatorLength = lineSeparator == null ? 0 : lineSeparator.length;
        boolean useChunking = lineLength > 0 && this.chunkSeparatorLength > 0;
        int n = this.lineLength = useChunking ? lineLength / this.encodedBlockSize * this.encodedBlockSize : 0;
        if (lineSeparator != null) {
            if (this.containsAlphabetOrPad(lineSeparator)) {
                String sep = new String(lineSeparator, StandardCharsets.UTF_8);
                throw new IllegalArgumentException("lineSeparator must not contain base64 characters: [" + sep + "]");
            }
            if (lineLength > 0) {
                this.encodeSize = 4 + lineSeparator.length;
                this.lineSeparator = new byte[lineSeparator.length];
                System.arraycopy(lineSeparator, 0, this.lineSeparator, 0, lineSeparator.length);
            } else {
                this.encodeSize = 4;
                this.lineSeparator = null;
            }
        } else {
            this.encodeSize = 4;
            this.lineSeparator = null;
        }
        this.decodeSize = this.encodeSize - 1;
        this.encodeTable = urlSafe ? URL_SAFE_ENCODE_TABLE : STANDARD_ENCODE_TABLE;
    }

    public boolean isInAlphabet(byte[] arrayOctet, boolean allowWSPad) {
        for (int i = 0; i < arrayOctet.length; ++i) {
            if (this.isInAlphabet(arrayOctet[i]) || allowWSPad && (arrayOctet[i] == 61 || Base64.isWhiteSpace(arrayOctet[i]))) continue;
            return false;
        }
        return true;
    }

    protected boolean isInAlphabet(byte octet) {
        return octet >= 0 && octet < this.decodeTable.length && this.decodeTable[octet] != -1;
    }

    protected static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public boolean isInAlphabet(String basen) {
        return this.isInAlphabet(basen.getBytes(StandardCharsets.UTF_8), true);
    }

    protected boolean containsAlphabetOrPad(byte[] arrayOctet) {
        if (arrayOctet == null) {
            return false;
        }
        for (byte element : arrayOctet) {
            if (61 != element && !this.isInAlphabet(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isUrlSafe() {
        return this.encodeTable == URL_SAFE_ENCODE_TABLE;
    }

    protected int getDefaultBufferSize() {
        return 8192;
    }

    public Base64Context decode(byte[] pArray, Base64Context ctx) throws FileParsingException {
        return this.decode(pArray, 0, pArray.length, ctx);
    }

    public Base64Context decode(byte[] pArray, int offset, int length, Base64Context ctx) throws FileParsingException {
        if (pArray == null || pArray.length == 0) {
            return null;
        }
        this.decodeImpl(pArray, offset, length, ctx);
        this.decodeImpl(pArray, 0, -1, ctx);
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void decodeImpl(byte[] bytes, int offset, int length, Base64Context ctx) throws FileParsingException {
        try {
            if (ctx.eof) {
                return;
            }
            byte[] buffer = null;
            if (length < 0) {
                ctx.eof = true;
            } else {
                buffer = ctx.ensureBufferHasCapacityLeft(length);
            }
            int readPos = offset;
            for (int i = 0; i < length; ++i) {
                byte b;
                if ((b = bytes[readPos++]) == 61) {
                    ctx.eof = true;
                    break;
                }
                try {
                    byte result;
                    if (b < 0 || b >= DECODE_TABLE.length || (result = DECODE_TABLE[b]) < 0) continue;
                    ctx.modulus = (ctx.modulus + 1) % 4;
                    ctx.ibitWorkArea = (ctx.ibitWorkArea << 6) + result;
                    if (ctx.modulus != 0) continue;
                    buffer[ctx.pos] = (byte)(ctx.ibitWorkArea >> 16 & 0xFF);
                    ++ctx.pos;
                    buffer[ctx.pos] = (byte)(ctx.ibitWorkArea >> 8 & 0xFF);
                    ++ctx.pos;
                    buffer[ctx.pos] = (byte)(ctx.ibitWorkArea & 0xFF);
                    ++ctx.pos;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new FileParsingException("Something went wrong in Base64 decoder, got out of array bounds", e);
                }
            }
            if (!ctx.eof || ctx.modulus == 0) return;
            buffer = ctx.ensureBufferHasCapacityLeft(this.decodeSize);
            switch (ctx.modulus) {
                case 1: {
                    return;
                }
                case 2: {
                    ctx.ibitWorkArea >>= 4;
                    buffer[ctx.pos++] = (byte)(ctx.ibitWorkArea & 0xFF);
                    return;
                }
                case 3: {
                    ctx.ibitWorkArea >>= 2;
                    buffer[ctx.pos++] = (byte)(ctx.ibitWorkArea >> 8 & 0xFF);
                    buffer[ctx.pos++] = (byte)(ctx.ibitWorkArea & 0xFF);
                    return;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + ctx.modulus);
                }
            }
        }
        finally {
            ctx.syncBufferPos();
        }
    }

    public Base64Context decode(char[] pArray, Base64Context ctx) throws FileParsingException {
        return this.decode(pArray, 0, pArray.length, ctx);
    }

    public Base64Context decode(char[] pArray, int offset, int length, Base64Context ctx) throws FileParsingException {
        if (pArray == null || pArray.length == 0) {
            return null;
        }
        this.decodeImpl(pArray, offset, length, ctx);
        this.decodeImpl(pArray, 0, -1, ctx);
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void decodeImpl(char[] chars, int offset, int length, Base64Context ctx) throws FileParsingException {
        try {
            if (ctx.eof) {
                return;
            }
            byte[] buffer = null;
            if (length < 0) {
                ctx.eof = true;
            } else {
                buffer = ctx.ensureBufferHasCapacityLeft(length * 2);
            }
            int readPos = offset;
            for (int i = 0; i < length; ++i) {
                byte b;
                if ((b = (byte)chars[readPos++]) == 61) {
                    ctx.eof = true;
                    break;
                }
                try {
                    byte result;
                    if (b < 0 || b >= DECODE_TABLE.length || (result = DECODE_TABLE[b]) < 0) continue;
                    ctx.modulus = (ctx.modulus + 1) % 4;
                    ctx.ibitWorkArea = (ctx.ibitWorkArea << 6) + result;
                    if (ctx.modulus != 0) continue;
                    buffer[ctx.pos] = (byte)(ctx.ibitWorkArea >> 16 & 0xFF);
                    ++ctx.pos;
                    buffer[ctx.pos] = (byte)(ctx.ibitWorkArea >> 8 & 0xFF);
                    ++ctx.pos;
                    buffer[ctx.pos] = (byte)(ctx.ibitWorkArea & 0xFF);
                    ++ctx.pos;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new FileParsingException("Something went wrong in Base64 decoder, got out of array bounds", e);
                }
            }
            if (!ctx.eof || ctx.modulus == 0) return;
            buffer = ctx.ensureBufferHasCapacityLeft(this.decodeSize);
            switch (ctx.modulus) {
                case 1: {
                    return;
                }
                case 2: {
                    ctx.ibitWorkArea >>= 4;
                    buffer[ctx.pos++] = (byte)(ctx.ibitWorkArea & 0xFF);
                    return;
                }
                case 3: {
                    ctx.ibitWorkArea >>= 2;
                    buffer[ctx.pos++] = (byte)(ctx.ibitWorkArea >> 8 & 0xFF);
                    buffer[ctx.pos++] = (byte)(ctx.ibitWorkArea & 0xFF);
                    return;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + ctx.modulus);
                }
            }
        }
        finally {
            ctx.syncBufferPos();
        }
    }
}

