/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.util.base64;

import org.apache.commons.pool2.ObjectPool;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.util.ByteArrayHolder;
import umich.ms.util.PooledByteArrayHolders;
import umich.ms.util.base64.Base64Context;

public class Base64ContextPooled
extends Base64Context {
    protected ObjectPool<ByteArrayHolder> pool = PooledByteArrayHolders.getInstance().getPool();

    @Override
    public void close() throws FileParsingException {
        if (this.bytesHolder != null) {
            try {
                this.pool.returnObject(this.bytesHolder);
                this.bytesHolder = null;
            }
            catch (Exception e) {
                throw new FileParsingException("Could not return a ByteArrayHolder back to the common pool", e);
            }
        }
    }

    @Override
    public byte[] ensureBufferHasCapacityLeft(int size) throws FileParsingException {
        if (this.bytesHolder == null) {
            try {
                this.bytesHolder = this.pool.borrowObject();
            }
            catch (Exception e) {
                throw new FileParsingException("Could not borrow a ByteArrayHolder from the common pool", e);
            }
        }
        this.bytesHolder.ensureHasSpace(size);
        return this.bytesHolder.getUnderlyingBytes();
    }
}

