/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign;

import de.unijena.bioinf.ChemistryBase.ms.ft.Fragment;
import de.unijena.bioinf.ftalign.analyse.FTDataElement;
import de.unijena.bioinf.treealign.TreeAlignmentAlgorithm;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Benchmarker {
    public static long benchmarkCompleteTime(final List<FTDataElement> elements, final TreeAlignmentAlgorithm.Factory<Fragment> factory, int repeats, int numberOfCores) {
        long bestTime = Long.MAX_VALUE;
        for (int t = 0; t < repeats; ++t) {
            ExecutorService service = Executors.newFixedThreadPool(numberOfCores);
            long time1 = System.nanoTime();
            final int n = elements.size();
            int i = 0;
            while (i < n) {
                final int i_ = i++;
                service.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        for (int j = i_ + 1; j < n; ++j) {
                            factory.create((Object)((FTDataElement)elements.get(i_)).getTree().getRoot(), (Object)((FTDataElement)elements.get(j)).getTree().getRoot()).compute();
                        }
                        return null;
                    }
                });
            }
            service.shutdown();
            try {
                service.awaitTermination(1000L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            long time2 = System.nanoTime();
            long runtime = time2 - time1;
            if (runtime >= bestTime) continue;
            bestTime = runtime;
        }
        return bestTime;
    }

    public static long benchmarkCompleteTime(List<FTDataElement> lefts, final List<FTDataElement> rights, final TreeAlignmentAlgorithm.Factory<Fragment> factory, int repeats, int numberOfCores) {
        long bestTime = Long.MAX_VALUE;
        for (int t = 0; t < repeats; ++t) {
            ExecutorService service = Executors.newFixedThreadPool(numberOfCores);
            long time1 = System.nanoTime();
            for (final FTDataElement left : lefts) {
                service.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        for (FTDataElement right : rights) {
                            factory.create((Object)left.getTree().getRoot(), (Object)right.getTree().getRoot()).compute();
                        }
                        return null;
                    }
                });
            }
            service.shutdown();
            try {
                service.awaitTermination(1000L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            long time2 = System.nanoTime();
            long runtime = time2 - time1;
            if (runtime >= bestTime) continue;
            bestTime = runtime;
        }
        return bestTime;
    }

    public static double[][] benchmark(List<FTDataElement> elements, TreeAlignmentAlgorithm.Factory<Fragment> factory, int repeats) {
        int n = elements.size();
        double[][] measurement = new double[2][(n * n - n) / 2];
        int l = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                long bestTime = Long.MAX_VALUE;
                double score = 0.0;
                for (int k = 0; k < repeats; ++k) {
                    long time = System.nanoTime();
                    factory.create((Object)elements.get(i).getTree().getRoot(), (Object)elements.get(j).getTree().getRoot()).compute();
                    long runtime = System.nanoTime() - time;
                    if (runtime >= bestTime) continue;
                    bestTime = runtime;
                }
                measurement[0][l] = bestTime;
                measurement[1][l++] = score;
            }
        }
        return measurement;
    }

    public static double[][] benchmark(List<FTDataElement> lefts, List<FTDataElement> rights, TreeAlignmentAlgorithm.Factory<Fragment> factory, int repeats) {
        int n1 = lefts.size();
        int n2 = rights.size();
        double[][] measurement = new double[2][n1 * n2];
        int l = 0;
        for (int i = 0; i < n1; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                long bestTime = Long.MAX_VALUE;
                double score = 0.0;
                for (int k = 0; k < repeats; ++k) {
                    long time = System.nanoTime();
                    factory.create((Object)lefts.get(i).getTree().getRoot(), (Object)rights.get(j).getTree().getRoot()).compute();
                    long runtime = System.nanoTime() - time;
                    if (runtime >= bestTime) continue;
                    bestTime = runtime;
                }
                measurement[0][l] = bestTime;
                measurement[1][l++] = score;
            }
        }
        return measurement;
    }
}

