/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign;

import de.unijena.bioinf.ftalign.CSVHandler;
import de.unijena.bioinf.ftalign.CSVReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class CIDBase {
    private final HashMap<String, Integer> cids = new HashMap(1000);

    public Integer get(String name) {
        return this.cids.get(name);
    }

    public boolean read(File cidfile) throws IOException {
        return this.read(cidfile, 0, 1);
    }

    public boolean read(File cidfile, final int nameCol, final int cidCol) throws IOException {
        final boolean[] complete = new boolean[]{true};
        CSVReader.read(cidfile, new CSVHandler(){
            private Integer cid;
            private String name;

            @Override
            public void entry(int row, int col, String entry) {
                if (row > 0) {
                    if (col == cidCol) {
                        try {
                            this.cid = Integer.parseInt(entry);
                        }
                        catch (NumberFormatException exc) {
                            this.cid = null;
                            complete[0] = false;
                        }
                    } else if (col == nameCol) {
                        this.name = entry;
                    }
                }
            }

            @Override
            public void endOfRow(int row) {
                if (this.cid != null) {
                    CIDBase.this.cids.put(this.name, this.cid);
                }
            }
        });
        return complete[0];
    }
}

