/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign;

import de.unijena.bioinf.ftalign.CSVHandler;
import de.unijena.bioinf.ftalign.CSVReader;
import de.unijena.bioinf.ftalign.analyse.Pearson;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CSVMatrix {
    public final String[] rows;
    public final String[] cols;
    public final double[][] matrix;

    public CSVMatrix(String[] rows, String[] cols, double[][] matrix) {
        this.rows = rows;
        this.cols = cols;
        this.matrix = matrix;
    }

    public double correlation(CSVMatrix other, FLATTEN mode) {
        return Pearson.pearson(this.flatten(mode), other.flatten(mode));
    }

    public double[] flatten(FLATTEN mode) {
        int n;
        if (mode == FLATTEN.UNSYMETRIC) {
            n = this.rows.length * this.cols.length;
        } else {
            int msize = (this.rows.length * this.rows.length - this.rows.length) / 2;
            n = mode == FLATTEN.SYMETRIC ? msize + this.rows.length : msize;
        }
        double[] flatten = new double[n];
        int k = 0;
        for (int row = 0; row < this.rows.length; ++row) {
            int startCol;
            for (int col = startCol = mode == FLATTEN.UNSYMETRIC ? 0 : (mode == FLATTEN.SYMETRIC ? row : row + 1); col < this.cols.length; ++col) {
                flatten[k++] = this.matrix[row][col];
            }
        }
        return flatten;
    }

    public CSVMatrix reorder(CSVMatrix M) {
        Integer l;
        int k;
        String[] Mrows = Arrays.copyOf(this.rows, this.rows.length);
        String[] Mcols = Arrays.copyOf(this.cols, this.cols.length);
        double[][] Mmatrix = new double[this.rows.length][this.cols.length];
        int[] rowIndizes = new int[this.rows.length];
        int[] colIndizes = new int[this.cols.length];
        boolean needReorder = false;
        HashMap<String, Integer> rowMap = new HashMap<String, Integer>();
        for (k = 0; k < M.rows.length; ++k) {
            rowMap.put(M.rows[k], k);
        }
        for (k = 0; k < this.rows.length; ++k) {
            l = (Integer)rowMap.get(this.rows[k]);
            if (l == null) {
                return null;
            }
            if (l != k) {
                needReorder = true;
            }
            rowIndizes[k] = l;
        }
        HashMap<String, Integer> colMap = new HashMap<String, Integer>();
        for (k = 0; k < M.cols.length; ++k) {
            colMap.put(M.cols[k], k);
        }
        for (k = 0; k < this.cols.length; ++k) {
            l = (Integer)colMap.get(this.cols[k]);
            if (l == null) {
                return null;
            }
            if (l != k) {
                needReorder = true;
            }
            colIndizes[k] = l;
        }
        for (int row = 0; row < this.rows.length; ++row) {
            int rowIndex = rowIndizes[row];
            for (int col = 0; col < this.cols.length; ++col) {
                Mmatrix[row][col] = M.matrix[rowIndex][colIndizes[col]];
            }
        }
        return new CSVMatrix(Mrows, Mcols, Mmatrix);
    }

    public void mapNames(Map<String, String> aliases) {
        int i;
        for (i = 0; i < this.rows.length; ++i) {
            if (!aliases.containsKey(this.rows[i])) {
                throw new RuntimeException("no alias for '" + this.rows[i] + "'");
            }
            this.rows[i] = aliases.get(this.rows[i]);
        }
        for (i = 0; i < this.cols.length; ++i) {
            if (!aliases.containsKey(this.cols[i])) {
                throw new RuntimeException("no alias for '" + this.cols[i] + "'");
            }
            this.cols[i] = aliases.get(this.cols[i]);
        }
    }

    public void write(File file, String dummyHeader) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            this.write(new BufferedWriter(writer), dummyHeader);
        }
    }

    public void write(BufferedWriter writer, String dummyHeader) throws IOException {
        NumberFormat formatter = NumberFormat.getNumberInstance(Locale.ENGLISH);
        formatter.setGroupingUsed(false);
        this.write(writer, dummyHeader, formatter);
    }

    public void write(BufferedWriter writer, String dummyHeader, NumberFormat formater) throws IOException {
        int i = 0;
        if (dummyHeader != null) {
            writer.write(34);
            writer.write(dummyHeader);
            writer.write(34);
            if (this.cols.length > 0) {
                writer.write(44);
            }
        }
        for (String colName : this.cols) {
            writer.write(34);
            writer.write(colName);
            writer.write(34);
            writer.write(++i == this.cols.length ? 10 : 44);
        }
        for (int row = 0; row < this.matrix.length; ++row) {
            String rowName = this.rows[row];
            writer.write(34);
            writer.write(rowName);
            writer.write(34);
            if (this.cols.length > 0) {
                writer.write(44);
            }
            int i2 = 0;
            for (double cell : this.matrix[row]) {
                writer.write(formater.format(cell));
                writer.write(++i2 == this.cols.length ? 10 : 44);
            }
        }
    }

    public static CSVMatrix read(InputStream in) throws IOException {
        final ArrayList rowNames = new ArrayList();
        final ArrayList colNames = new ArrayList();
        final ArrayList rows = new ArrayList();
        CSVReader.read(in, new CSVHandler(){
            private double[] vector;
            private int colSize;

            @Override
            public void entry(int row, int col, String entry) {
                if (row == 0) {
                    colNames.add(entry);
                } else if (col == 0) {
                    rowNames.add(entry);
                } else {
                    this.vector[col - 1] = Double.parseDouble(entry);
                }
            }

            @Override
            public void endOfRow(int row) {
                if (row == 0) {
                    this.colSize = colNames.size();
                    this.vector = new double[this.colSize];
                    Arrays.fill(this.vector, Double.NaN);
                    return;
                }
                if (row == 1 && Double.isNaN(this.vector[this.colSize - 1])) {
                    --this.colSize;
                    colNames.remove(0);
                    this.vector = Arrays.copyOf(this.vector, this.colSize);
                }
                rows.add(this.vector);
                this.vector = new double[this.colSize];
            }
        });
        double[][] matrix = new double[rows.size()][];
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i] = (double[])rows.get(i);
        }
        return new CSVMatrix(rowNames.toArray(new String[0]), colNames.toArray(new String[0]), matrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CSVMatrix read(URL url) throws IOException {
        CSVMatrix matrix = null;
        try (InputStream stream = url.openStream();){
            matrix = CSVMatrix.read(stream);
        }
        return matrix;
    }

    public static enum FLATTEN {
        UNSYMETRIC,
        SYMETRIC,
        SYMETRIC_WITHOUT_DIAGONAL;

    }
}

