/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign;

import de.unijena.bioinf.ftalign.CSVHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSVReader {
    private static final char SEPARATOR = ',';
    private static final char QUOTATION = '\"';

    public static void read(File file, CSVHandler handler) throws IOException {
        CSVReader.read(file.toURI().toURL(), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read(URL url, CSVHandler handler) throws IOException {
        try (InputStream stream = url.openStream();){
            CSVReader.read(stream, handler);
        }
    }

    public static void read(InputStream stream, CSVHandler handler) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String quo = Pattern.quote(String.valueOf('\"'));
        String sep = Pattern.quote(String.valueOf(','));
        Pattern REGEXP = Pattern.compile(quo + "|" + sep + "|\n");
        StringBuilder buffer = new StringBuilder();
        int row = 0;
        while (reader.ready()) {
            int col = 0;
            String line = reader.readLine();
            Matcher matcher = REGEXP.matcher(line);
            int quotations = 0;
            int i = 0;
            while (matcher.find()) {
                switch (matcher.group().charAt(0)) {
                    case '\"': {
                        if (++quotations % 2 == 0) {
                            buffer.append(line.substring(i, matcher.start()));
                            i = matcher.end();
                        } else if (quotations > 1) {
                            buffer.append('\"');
                        }
                        i = matcher.end();
                        break;
                    }
                    case '\n': 
                    case ',': {
                        String entry;
                        if (quotations % 2 != 0) break;
                        if (buffer.length() > 0) {
                            buffer.append(line.substring(i, matcher.start()));
                            entry = buffer.toString().trim();
                            buffer.delete(0, buffer.length());
                        } else {
                            entry = line.substring(i, matcher.start()).trim();
                        }
                        quotations = 0;
                        handler.entry(row, col++, entry);
                        i = matcher.end();
                    }
                }
            }
            handler.endOfRow(row++);
        }
    }
}

