/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign;

import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ftalign.StandardScoring;
import java.util.HashSet;

public class CommonLossScoring
extends StandardScoring {
    private static final String[] LOSSES = new String[]{"H2O", "C2H2", "HO3P", "CH3", "H3O4P", "C2H4", "H3N", "CHN", "CS", "C2H6", "HS", "H2S", "CO", "CH3N", "C2H2O", "C4H4", "C3H2O", "C4H6", "CH4", "C3H4O", "OS", "O2S", "HF", "CH2S", "CH2", "C3H6", "C2H2S", "C2H7N", "C5H10", "CH2O2", "CH2O", "C2O2", "C4H2", "C4H8", "C5H8", "H2", "C2H4O", "C2H5N", "Br", "HBr", "Cl", "HCl", "CO2", "C6H6", "CHNO", "C2H6O", "S", "I", "HI", "CH4S", "CHNS", "CHClO", "C2H3Cl"};
    private HashSet<MolecularFormula> commonLosses = new HashSet();

    public CommonLossScoring(boolean useFragment) {
        super(useFragment);
        for (String l : LOSSES) {
            this.commonLosses.add(MolecularFormula.parse((String)l));
        }
    }

    @Override
    public float scoreFormulas(MolecularFormula left, MolecularFormula right, boolean isLoss) {
        if (!isLoss) {
            if (left.equals(right)) {
                return super.scoreFormulas(left, right, isLoss);
            }
            if (left.isSubtractable(right)) {
                MolecularFormula diff = left.subtract(right);
                if (this.commonLosses.contains(diff)) {
                    return this.matchScore;
                }
                return super.scoreFormulas(left, right, isLoss);
            }
            if (right.isSubtractable(left)) {
                MolecularFormula diff = right.subtract(left);
                if (this.commonLosses.contains(diff)) {
                    return this.matchScore;
                }
                return super.scoreFormulas(left, right, isLoss);
            }
            return super.scoreFormulas(left, right, isLoss);
        }
        return super.scoreFormulas(left, right, isLoss);
    }
}

