/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign;

import de.unijena.bioinf.ChemistryBase.ms.ft.FTree;
import de.unijena.bioinf.ChemistryBase.ms.ft.Fragment;
import de.unijena.bioinf.counting.AlignmentWrapper;
import de.unijena.bioinf.counting.DPPathCounting;
import de.unijena.bioinf.counting.DPSubtreeCounter;
import de.unijena.bioinf.counting.WeightedPathCounting;
import de.unijena.bioinf.counting.Weighting;
import de.unijena.bioinf.ftalign.Benchmarker;
import de.unijena.bioinf.ftalign.ScoreFormula;
import de.unijena.bioinf.ftalign.StandardScoring;
import de.unijena.bioinf.ftalign.TestScoring;
import de.unijena.bioinf.ftalign.TraceLog2;
import de.unijena.bioinf.ftalign.WeightingReader;
import de.unijena.bioinf.ftalign.analyse.FTDataElement;
import de.unijena.bioinf.ftalign.analyse.FTDataset;
import de.unijena.bioinf.ftalign.analyse.TreeSizeNormalizer;
import de.unijena.bioinf.ftalign.graphics.GraphicalBacktrace;
import de.unijena.bioinf.ftalign.graphics.GraphicalBacktrace2;
import de.unijena.bioinf.graphUtils.tree.TreeAdapter;
import de.unijena.bioinf.treealign.AlignmentTree;
import de.unijena.bioinf.treealign.AlignmentTreeBacktrace;
import de.unijena.bioinf.treealign.Backtrace;
import de.unijena.bioinf.treealign.TreeAlignmentAlgorithm;
import de.unijena.bioinf.treealign.scoring.Scoring;
import de.unijena.bioinf.treealign.scoring.SimpleEqualityScoring;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class Main {
    public static final String VERSION = "2.1";
    private static final String BENCHMARK_OPT = "print benchmark as csv (each row is a tuple (dataset1, dataset2, leftSize, rightSize, leftDepth, rightDepth, leftTime, rightTime, score))";
    private static final String MATRIX_OPT = "print results as matrix (rows=dataset1, cols=dataset2).";
    private static final String CSV_OPT = "print result as csv (each row is a tuple (dataset1, dataset2, score)).";
    private static final String T_OPT = "print correlation with tanimoto scores.";
    private static final String SELFAL_OPT = "allow self aligns. This option will be ignored, if more than one dataset is given.";
    private static final String NORM_OPT = "normalize scores by treesize correction";
    private static final String FINGERPRINT_OPT = "replace the scores by the correlation of feature vectors";
    private static final String TANIMOTO_OPT = "file with tanimoto scores of the molecules";
    private static final String VERTEX_OPT = "use fragment scoring";
    private static final String JOIN_OPT = "without numerical argument, allow single joins. Otherwise allow multi joins.";
    private static final String BACKTRACK_OPT = "write backtraces on standard output or into the given directory (as one file per alignment) or file";
    private static final String LOSS_SCORE_OPT = "+AxB-CxD set the neutral loss match score to the value A plus B multiplied with the number of nonhydrogens and the neutral loss missmatch score to C plus D multiplied with the number of nonhydrogens";
    private static final String VERTEX_SCORE_OPT = "<+AxB-CxD> set the fragment match score to the value A plus B multiplied with the number of nonhydrogens and the fragment missmatch score to C plus D multiplied with the number of nonhydrogens";
    private static final String CORE_OPT = "number of threads, which should be used for computing. Take into account, that more parallel threads means also a greater memory usage (each threads computes a single instance, so -n4 means 4 times higher memory consumption), so the number of cpu cores is not the only limitation for this number";
    private static final String JOIN_SCORE_OPT = "+AxB set the join penalty to A plus B multiplied with the length of the join path";
    private static final String GAP_SCORE_OPT = "set gap penalty to the given number";
    private static final String METHOD_OPT = "computation method. Either <alignment> (default), <paths> or <subtree>";
    private static final String WEIGHTING_OPT = "weighting for trees. Prove a csv file with two columns, one for the formula and one for the score. Use a further column with formula '*' to give a score for any formula.";
    private static final NumberFormat decimalFormat = NumberFormat.getInstance(Locale.ENGLISH);
    private PrintStream backtrackOut;

    public static void main(String[] args) {
        new Main().run(args);
    }

    private static String quote(String s) {
        int i = s.indexOf(44);
        int j = s.indexOf(34);
        if (i < 0 && j < 0) {
            return s;
        }
        if (j >= 0) {
            s.replaceAll("\"", "\"\"");
        }
        if (i >= 0) {
            s = "\"" + s + "\"";
        }
        return s;
    }

    private static void printCSVRow(PrintStream csvOut, FTDataElement left, FTDataElement right, double score) {
        csvOut.print('\"');
        csvOut.print(left.getName());
        csvOut.print('\"');
        csvOut.print(',');
        csvOut.print('\"');
        csvOut.print(right.getName());
        csvOut.print('\"');
        csvOut.print(',');
        csvOut.print(left.getMaxDepth());
        csvOut.print(",");
        csvOut.print(right.getMaxDepth());
        csvOut.print(",");
        csvOut.print(left.getSize());
        csvOut.print(",");
        csvOut.print(right.getSize());
        csvOut.print(",");
        csvOut.print(decimalFormat.format(score));
        csvOut.print('\n');
    }

    private static PrintStream setStream(OptionSet set, OptionSpec<File> spec) {
        PrintStream out = null;
        if (set.has(spec)) {
            File file = (File)spec.value(set);
            if (file == null) {
                return System.out;
            }
            try {
                out = new PrintStream((File)spec.value(set));
                return out;
            }
            catch (IOException e) {
                System.err.println("Unable to open file '" + spec.value(set) + "'");
                System.exit(1);
                return null;
            }
        }
        return null;
    }

    public void run(String[] args) {
        FTDataset dataset;
        Object factory;
        File graphicalOutputDir;
        Object scoring;
        List<FTDataElement> rights;
        List<FTDataElement> lefts;
        int numberOfJoins;
        boolean useMultiJoins;
        boolean backtrackInDir;
        File backTrackTarget;
        ArrayList<File> leftSet = new ArrayList<File>();
        ArrayList<File> rightSet = new ArrayList<File>();
        ArrayList<String> argv = new ArrayList<String>(Arrays.asList(args));
        ListIterator iter = argv.listIterator();
        int state = 0;
        while (iter.hasNext()) {
            String value = (String)iter.next();
            if (value.equalsIgnoreCase("--align") || value.equalsIgnoreCase("-align")) {
                state = 1;
                iter.remove();
                continue;
            }
            if (value.equalsIgnoreCase("--with") || value.equalsIgnoreCase("-with")) {
                state = 2;
                iter.remove();
                continue;
            }
            if (value.startsWith("-")) {
                state = 0;
                continue;
            }
            if (state <= 0) continue;
            iter.remove();
            (state == 1 ? leftSet : rightSet).add(new File(value));
        }
        args = argv.toArray(new String[argv.size()]);
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec scoreFrag = parser.accepts("F", VERTEX_SCORE_OPT).withRequiredArg().ofType(ScoreFormula.class);
        ArgumentAcceptingOptionSpec scoreLoss = parser.accepts("L", LOSS_SCORE_OPT).withRequiredArg().ofType(ScoreFormula.class);
        ArgumentAcceptingOptionSpec scoreJoin = parser.accepts("J", JOIN_SCORE_OPT).withRequiredArg().ofType(ScoreFormula.class);
        ArgumentAcceptingOptionSpec scoreMultijoin = parser.accepts("M", JOIN_SCORE_OPT).withRequiredArg().ofType(Float.class);
        ArgumentAcceptingOptionSpec scoreGap = parser.accepts("G", GAP_SCORE_OPT).withRequiredArg().ofType(Float.class);
        ArgumentAcceptingOptionSpec graphicalOutput = parser.acceptsAll(Arrays.asList("g", "graphics"), "Graphical Output of alignments as svg files").withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec matrix = parser.acceptsAll(Arrays.asList("m", "matrix"), MATRIX_OPT).withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec csv = parser.acceptsAll(Arrays.asList("c", "csv"), CSV_OPT).withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec backtrack = parser.acceptsAll(Arrays.asList("b", "backtrack", "backtrace"), BACKTRACK_OPT).withOptionalArg().ofType(File.class);
        parser.accepts("TEST", "test scoring");
        parser.accepts("runtime", "measure complete runtime");
        ArgumentAcceptingOptionSpec tcor = parser.acceptsAll(Arrays.asList("t", "correlation")).withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec tanimoto = parser.accepts("tanimoto", TANIMOTO_OPT).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec joins = parser.acceptsAll(Arrays.asList("j", "join", "joins"), JOIN_OPT).withOptionalArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec benchmark = parser.acceptsAll(Arrays.asList("benchmark"), BENCHMARK_OPT).withOptionalArg().ofType(File.class);
        parser.acceptsAll(Arrays.asList("s", "selfaligns"), SELFAL_OPT);
        parser.accepts("nonsparse", "use the old nonsparse algorithm");
        parser.acceptsAll(Arrays.asList("z", "normalize"), NORM_OPT);
        ArgumentAcceptingOptionSpec cores = parser.accepts("n", CORE_OPT).withRequiredArg().ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]);
        parser.acceptsAll(Arrays.asList("f", "fingerprint"), FINGERPRINT_OPT);
        parser.acceptsAll(Arrays.asList("x", "vertex"), VERTEX_OPT);
        ArgumentAcceptingOptionSpec method = parser.accepts("method", METHOD_OPT).withRequiredArg().ofType(String.class).defaultsTo((Object)"alignment", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec weightingOpt = parser.acceptsAll(Arrays.asList("w", "weights"), WEIGHTING_OPT).withOptionalArg().ofType(File.class);
        parser.accepts("version");
        parser.acceptsAll(Arrays.asList("h", "help"));
        OptionSet set = parser.parse(args);
        if (set.has("h")) {
            System.out.println("Usage:");
            System.out.println("\tjava -jar ftaligner -jxfz -m --align input/dir > output.csv ");
            System.out.println("\tjava -jar ftaligner -jxfz -G0 -F+5x1-3 -L+5x1-2x0.5 -Jx-0.25 -m --align input/dir > output.csv ");
            try {
                parser.printHelpOn((OutputStream)System.out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        if (set.has("version")) {
            System.out.println(VERSION);
            return;
        }
        Weighting<Fragment> weighting = null;
        if (set.has((OptionSpec)weightingOpt)) {
            try {
                File file = (File)weightingOpt.value(set);
                if (file != null) {
                    weighting = new WeightingReader().parseCSV(file);
                } else {
                    InputStream stream = Main.class.getResourceAsStream("/lossweights.csv");
                    InputStreamReader reader = new InputStreamReader(stream);
                    weighting = new WeightingReader().parseCSV(reader);
                    reader.close();
                }
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
        }
        ArrayList openStreams = new ArrayList();
        PrintStream matrixOut = Main.setStream(set, (OptionSpec<File>)matrix);
        final PrintStream csvOut = Main.setStream(set, (OptionSpec<File>)csv);
        PrintStream corOut = Main.setStream(set, (OptionSpec<File>)tcor);
        final boolean backtracking = set.has((OptionSpec)backtrack);
        if (backtracking) {
            backTrackTarget = (File)set.valueOf((OptionSpec)backtrack);
            boolean bl = backtrackInDir = backTrackTarget != null && backTrackTarget.isDirectory();
            if (!backtrackInDir && backTrackTarget != null) {
                try {
                    this.backtrackOut = new PrintStream(backTrackTarget);
                }
                catch (IOException exc) {
                    System.err.println("Error while opening " + backTrackTarget);
                    return;
                }
            } else if (backTrackTarget == null) {
                this.backtrackOut = System.out;
            }
        } else {
            backtrackInDir = false;
            backTrackTarget = null;
        }
        if (set.has((OptionSpec)joins)) {
            if (joins.value(set) != null) {
                useMultiJoins = true;
                numberOfJoins = (Integer)joins.value(set);
            } else {
                useMultiJoins = false;
                numberOfJoins = 1;
            }
        } else {
            useMultiJoins = false;
            numberOfJoins = 0;
        }
        try {
            lefts = FTDataElement.parseDotFilesFromDirectories(leftSet);
            rights = rightSet.isEmpty() ? null : FTDataElement.parseDotFilesFromDirectories(rightSet);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (set.has("TEST")) {
            scoring = new TestScoring();
        } else {
            StandardScoring scoringx = new StandardScoring(set.has("x"), false);
            if (set.has((OptionSpec)scoreFrag)) {
                scoringx.matchScore = ((ScoreFormula)set.valueOf((OptionSpec)scoreFrag)).matchFixed;
                scoringx.scoreForEachNonHydrogen = ((ScoreFormula)set.valueOf((OptionSpec)scoreFrag)).matchSizeDependend;
                scoringx.missmatchPenalty = ((ScoreFormula)set.valueOf((OptionSpec)scoreFrag)).missmatchFixed;
                scoringx.penaltyForEachNonHydrogen = ((ScoreFormula)set.valueOf((OptionSpec)scoreFrag)).missmatchSizeDependend;
            }
            if (set.has((OptionSpec)scoreLoss)) {
                scoringx.lossMatchScore = ((ScoreFormula)set.valueOf((OptionSpec)scoreLoss)).matchFixed;
                scoringx.lossScoreForEachNonHydrogen = ((ScoreFormula)set.valueOf((OptionSpec)scoreLoss)).matchSizeDependend;
                scoringx.lossMissmatchPenalty = ((ScoreFormula)set.valueOf((OptionSpec)scoreLoss)).missmatchFixed;
                scoringx.lossPenaltyForEachNonHydrogen = ((ScoreFormula)set.valueOf((OptionSpec)scoreLoss)).missmatchSizeDependend;
            }
            if (set.has((OptionSpec)scoreJoin)) {
                scoringx.joinMatchScore = ((ScoreFormula)set.valueOf((OptionSpec)scoreJoin)).matchFixed;
                scoringx.joinScoreForEachNonHydrogen = ((ScoreFormula)set.valueOf((OptionSpec)scoreJoin)).matchSizeDependend;
                scoringx.joinMissmatchPenalty = ((ScoreFormula)set.valueOf((OptionSpec)scoreJoin)).missmatchFixed;
                scoringx.joinPenaltyForEachNonHydrogen = ((ScoreFormula)set.valueOf((OptionSpec)scoreJoin)).missmatchSizeDependend;
            }
            if (set.has((OptionSpec)scoreMultijoin)) {
                scoringx.penaltyForEachJoin = ((Float)set.valueOf((OptionSpec)scoreMultijoin)).floatValue();
            }
            if (set.has((OptionSpec)scoreGap)) {
                scoringx.gapScore = ((Float)set.valueOf((OptionSpec)scoreGap)).floatValue();
            }
            scoring = scoringx;
        }
        if (set.has((OptionSpec)graphicalOutput)) {
            File f = (File)graphicalOutput.value(set);
            if (f == null) {
                graphicalOutputDir = new File(".");
            } else if (f.isDirectory()) {
                graphicalOutputDir = (File)graphicalOutput.value(set);
            } else {
                System.err.println("Expect directory for graphical output but file given: '" + f.getName() + "'");
                System.exit(1);
                graphicalOutputDir = null;
            }
        } else {
            graphicalOutputDir = null;
        }
        String methodName = ((String)set.valueOf((OptionSpec)method)).toLowerCase();
        if (methodName.contains("align")) {
            factory = set.has("nonsparse") ? new TreeAlignmentAlgorithm.NonSparseFactory((TreeAdapter)FTree.treeAdapter(), (Scoring)scoring, numberOfJoins > 0) : new TreeAlignmentAlgorithm.Factory((TreeAdapter)FTree.treeAdapter(), (Scoring)scoring, numberOfJoins, useMultiJoins);
        } else if (methodName.contains("path")) {
            factory = new CountingFactory((TreeAdapter<Fragment>)FTree.treeAdapter(), (Scoring<Fragment>)scoring, weighting, false);
        } else if (methodName.contains("subtree")) {
            factory = new CountingFactory((TreeAdapter<Fragment>)FTree.treeAdapter(), (Scoring<Fragment>)scoring, weighting, true);
        } else {
            factory = null;
            System.err.println("Expect either <alignment>, <path> or <subtree> as method. Unknown method <" + methodName + ">");
            System.exit(0);
        }
        FTDataset fTDataset = dataset = rights == null ? new FTDataset(lefts, (TreeAlignmentAlgorithm.Factory<Fragment>)factory) : new FTDataset(lefts, rights, (TreeAlignmentAlgorithm.Factory<Fragment>)factory);
        if (!methodName.contains("align")) {
            dataset.setForceSelf(true);
        }
        int usedCores = (Integer)set.valueOf((OptionSpec)cores);
        if (set.has("runtime")) {
            if (rights == null) {
                System.out.println("runtime: " + (double)Benchmarker.benchmarkCompleteTime(lefts, (TreeAlignmentAlgorithm.Factory<Fragment>)factory, 10, usedCores) / 1.0E9 + " s");
            } else {
                System.out.println("runtime: " + (double)Benchmarker.benchmarkCompleteTime(lefts, rights, (TreeAlignmentAlgorithm.Factory<Fragment>)factory, 10, usedCores) / 1.0E9 + " s");
            }
        }
        if (set.has("z")) {
            dataset.setNormalizer(new TreeSizeNormalizer(0.5));
        }
        if (backtracking || set.has((OptionSpec)graphicalOutput)) {
            dataset.pushBeforeCallback(new FTDataset.BeforeCallback(){

                @Override
                public void run(FTDataElement left, FTDataElement right) {
                    dataset.setTracer(null);
                    if (graphicalOutputDir != null) {
                        dataset.pushTracer((Backtrace<Fragment>)new GraphicalBacktrace(left, right));
                    }
                    if (backtracking) {
                        if (backtrackInDir) {
                            File backtrackFile = new File(backTrackTarget, this.simplify(left.getName(), right.getName()));
                            if (Main.this.backtrackOut != null) {
                                Main.this.backtrackOut.close();
                            }
                            try {
                                Main.this.backtrackOut = new PrintStream(backtrackFile);
                            }
                            catch (FileNotFoundException e) {
                                System.err.println("Can't open file " + backtrackFile);
                                return;
                            }
                        } else if (Main.this.backtrackOut != null) {
                            Main.this.backtrackOut.print("\n\n");
                        }
                        if (Main.this.backtrackOut == null) {
                            return;
                        }
                        Main.this.backtrackOut.println("ALIGN <" + left.getName() + "> WITH <" + right.getName() + ">");
                        dataset.pushTracer((Backtrace<Fragment>)new TraceLog2(Main.this.backtrackOut));
                    }
                }

                private String simplify(String l, String r) {
                    String c = l + r;
                    if (c.length() > 64) {
                        return l.substring(0, 32) + r.substring(0, 32);
                    }
                    return l + r;
                }
            });
        }
        if (set.has((OptionSpec)graphicalOutput)) {
            dataset.pushBeforeCallback(new FTDataset.BeforeCallback(){

                @Override
                public void run(FTDataElement left, FTDataElement right) {
                    dataset.setTracer((Backtrace<Fragment>)new AlignmentTreeBacktrace((TreeAdapter)FTree.treeAdapter()));
                }
            });
            dataset.pushAfterCallback(new FTDataset.AfterCallback(){

                @Override
                public void run(FTDataElement left, FTDataElement right, int i, int j, Backtrace<Fragment> backtrace, double score) {
                    File outG = new File(graphicalOutputDir, left.getName() + "_" + right.getName() + ".dot");
                    try {
                        PrintStream stream = new PrintStream(outG);
                        GraphicalBacktrace2 gfx = new GraphicalBacktrace2(stream, left.getTree(), right.getTree(), (AlignmentTree<Fragment>)((AlignmentTreeBacktrace)dataset.getTracer()).getAlignmentTree());
                        gfx.print();
                        stream.close();
                    }
                    catch (Exception e) {
                        System.err.println(left.getName() + " vs. " + right.getName());
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        if (set.has((OptionSpec)benchmark)) {
            int k;
            double[][] measurement;
            PrintStream benchmarkOut = null;
            if (benchmark.value(set) != null) {
                try {
                    benchmarkOut = new PrintStream((File)benchmark.value(set));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            } else {
                benchmarkOut = System.out;
            }
            benchmarkOut.println("left,right,depthLeft,depthRight,degreeLeft,degreeRight,sizeLeft,sizeRight,score,time");
            if (rights == null) {
                measurement = Benchmarker.benchmark(lefts, (TreeAlignmentAlgorithm.Factory<Fragment>)factory, 20);
                k = 0;
                for (int i = 0; i < lefts.size(); ++i) {
                    for (int j = i + 1; j < lefts.size(); ++j) {
                        long time = (long)measurement[0][k];
                        double score = measurement[1][k++];
                        double seconds = (double)time / 1.0E9;
                        FTDataElement left = lefts.get(i);
                        FTDataElement right = lefts.get(j);
                        benchmarkOut.println(left.getName() + "," + right.getName() + "," + left.getMaxDepth() + "," + right.getMaxDepth() + "," + left.getMaxDegree() + "," + right.getMaxDegree() + "," + left.getSize() + "," + right.getSize() + "," + score + "," + seconds);
                    }
                }
            } else {
                measurement = Benchmarker.benchmark(lefts, rights, (TreeAlignmentAlgorithm.Factory<Fragment>)factory, 20);
                k = 0;
                for (FTDataElement left : lefts) {
                    for (FTDataElement right : rights) {
                        long time = (long)measurement[k][0];
                        double score = measurement[k++][1];
                        double seconds = (double)time / 1.0E9;
                        benchmarkOut.println(left.getName() + "," + right.getName() + "," + left.getMaxDepth() + "," + right.getMaxDepth() + "," + left.getMaxDegree() + "," + right.getMaxDegree() + "," + left.getSize() + "," + right.getSize() + "," + score + "," + seconds);
                    }
                }
            }
            benchmarkOut.close();
        }
        if (!set.has("f") && csvOut != null) {
            dataset.pushAfterCallback(new FTDataset.AfterCallback(){

                @Override
                public void run(FTDataElement left, FTDataElement right, int i, int j, Backtrace<Fragment> backtrace, double score) {
                    Main.printCSVRow(csvOut, left, right, score);
                }
            });
        }
        dataset.computeAllParallel(false, usedCores);
        if (this.backtrackOut != null) {
            this.backtrackOut.close();
        }
        if (set.has("f")) {
            dataset.computeFingerprints();
            if (csvOut != null) {
                csvOut.println("left,right,depthLeft,depthRight,sizeLeft,sizeRight,score");
                for (int i = 0; i < dataset.rows(); ++i) {
                    int startJ;
                    int n = dataset.isSymetric() ? (set.has("s") ? i : i + 1) : 0;
                    for (int j = startJ = (v1094); j < dataset.cols(); ++j) {
                        Main.printCSVRow(csvOut, dataset.getRowElement(i), dataset.getColElement(j), dataset.get(i, j));
                    }
                }
            }
        }
        if (matrixOut != null) {
            try {
                BufferedWriter bw = new BufferedWriter(new PrintWriter(matrixOut));
                dataset.toCSV().write(bw, "scores");
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        if (csvOut != null) {
            csvOut.close();
        }
        if (matrixOut != null) {
            matrixOut.close();
        }
    }

    private static class CountingFactory
    extends TreeAlignmentAlgorithm.Factory<Fragment> {
        private boolean countSubtrees;
        private Weighting<Fragment> weighting;

        public CountingFactory(TreeAdapter<Fragment> adapter, Scoring<Fragment> scoring, Weighting<Fragment> weighting, boolean countSubtrees) {
            super(adapter, scoring, 0, false);
            this.countSubtrees = countSubtrees;
            this.weighting = weighting;
        }

        public TreeAlignmentAlgorithm<Fragment> create(Fragment left, Fragment right) {
            if (this.countSubtrees) {
                return new AlignmentWrapper((DPPathCounting)new DPSubtreeCounter((SimpleEqualityScoring)this.scoring, (Object)left, (Object)right, this.adapter));
            }
            if (this.weighting != null) {
                return new AlignmentWrapper(new WeightedPathCounting((SimpleEqualityScoring)this.scoring, this.weighting, (Object)left, (Object)right, this.adapter));
            }
            return new AlignmentWrapper(new DPPathCounting((SimpleEqualityScoring)this.scoring, (Object)left, (Object)right, this.adapter));
        }
    }
}

