/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScoreFormula {
    public final float matchFixed;
    public final float matchSizeDependend;
    public final float missmatchFixed;
    public final float missmatchSizeDependend;
    private static final String SUBPATTERN = "([+-]?\\s*\\d+(?:\\.\\d*)?)";
    private static final Pattern PATTERN = Pattern.compile("([+-]?\\s*\\d+(?:\\.\\d*)?)?\\s*(?:x\\s*([+-]?\\s*\\d+(?:\\.\\d*)?))?");

    public ScoreFormula(String value) {
        try {
            Matcher matcher = PATTERN.matcher(value.toLowerCase());
            float[] values = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            int index = 0;
            while (matcher.find()) {
                String fixed = matcher.group(1);
                String sizeDependend = matcher.group(2);
                if (fixed != null && !fixed.isEmpty()) {
                    values[index * 2] = Float.parseFloat(fixed);
                }
                if (sizeDependend != null && !sizeDependend.isEmpty()) {
                    values[index * 2 + 1] = Float.parseFloat(sizeDependend);
                }
                if (++index <= 2) continue;
                break;
            }
            this.matchFixed = values[0];
            this.matchSizeDependend = values[1];
            this.missmatchFixed = values[2];
            this.missmatchSizeDependend = values[3];
        }
        catch (RuntimeException exc) {
            exc.printStackTrace();
            throw exc;
        }
    }
}

