/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign;

import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.ms.ft.FTree;
import de.unijena.bioinf.ChemistryBase.ms.ft.Fragment;
import de.unijena.bioinf.graphUtils.tree.PostOrderTraversal;
import de.unijena.bioinf.graphUtils.tree.TreeAdapter;
import de.unijena.bioinf.treealign.scoring.Scoring;
import de.unijena.bioinf.treealign.scoring.SimpleEqualityScoring;
import java.util.Iterator;
import java.util.List;

public class StandardScoring2
implements Scoring<Fragment>,
SimpleEqualityScoring<Fragment> {
    public static final float DEFAULT_MATCHSCORE = 5.0f;
    public static final float DEFAULT_SCOREFOREACHNONHYDROGEN = 1.0f;
    public static final float DEFAULT_MISSMATCHPENALTY = -1.0f;
    public static final float DEFAULT_PENALTYFOREACHNONHYDROGEN = -0.25f;
    public static final float DEFAULT_LOSSMATCHSCORE = 5.0f;
    public static final float DEFAULT_LOSSSCOREFOREACHNONHYDROGEN = 1.0f;
    public static final float DEFAULT_LOSSMISSMATCHPENALTY = -1.0f;
    public static final float DEFAULT_LOSSPENALTYFOREACHNONHYDROGEN = -0.25f;
    public static final float DEFAULT_JOINMATCHSCORE = 5.0f;
    public static final float DEFAULT_JOINSCOREFOREACHNONHYDROGEN = 1.0f;
    public static final float DEFAULT_JOINMISSMATCHPENALTY = -2.0f;
    public static final float DEFAULT_JOINPENALTYFOREACHNONHYDROGEN = -0.5f;
    public static final float DEFAULT_PENALTYFOREACHJOIN = 0.0f;
    public static final float DEFAULT_SCOREFORJOIN = 0.0f;
    public static final float DEFAULT_GAP_SCORE = 0.0f;
    public float matchScore = 5.0f;
    public float scoreForEachNonHydrogen = 1.0f;
    public float missmatchPenalty = -1.0f;
    public float penaltyForEachNonHydrogen = -0.25f;
    public float lossMatchScore = 5.0f;
    public float lossScoreForEachNonHydrogen = 1.0f;
    public float lossMissmatchPenalty = -1.0f;
    public float lossPenaltyForEachNonHydrogen = -0.25f;
    public float penaltyForEachJoin = 0.0f;
    public float gapScore = 0.0f;
    public float joinMatchScore = 5.0f;
    public float joinScoreForEachNonHydrogen = 1.0f;
    public float joinMissmatchPenalty = -2.0f;
    public float joinPenaltyForEachNonHydrogen = -0.5f;
    private boolean useFragment;

    public StandardScoring2(boolean useFragment, boolean usePacking) {
        this.useFragment = useFragment;
    }

    public StandardScoring2(boolean useFragment) {
        this(useFragment, false);
    }

    private static MolecularFormula selfJoin(MolecularFormula l, int n) {
        int i;
        MolecularFormula f = l;
        for (i = 1; i < n; i <<= 1) {
            f = f.add(f);
        }
        i >>= 1;
        while (i < n) {
            f = f.add(l);
            ++i;
        }
        return f;
    }

    public float match(Fragment left, Fragment right) {
        float score = this.scoreFormulas(left.getIncomingEdge().getFormula(), right.getIncomingEdge().getFormula(), true);
        if (this.useFragment) {
            score += this.scoreFormulas(left.getFormula(), right.getFormula(), false);
        }
        return score;
    }

    public float deleteLeft(Fragment left) {
        return this.gapScore;
    }

    public float deleteRight(Fragment right) {
        return this.gapScore;
    }

    public boolean isScoringVertices() {
        return this.useFragment;
    }

    public float joinLeft(Fragment left, Fragment join, Fragment right) {
        float score = this.scoreJoinFormulas(left.getIncomingEdge().getFormula().add(join.getIncomingEdge().getFormula()), right.getIncomingEdge().getFormula());
        if (this.useFragment) {
            score += this.scoreFormulas(join.getFormula(), right.getFormula(), false);
        }
        return score += this.penaltyForEachJoin;
    }

    public float joinRight(Fragment right, Fragment join, Fragment left) {
        return this.joinLeft(right, join, left);
    }

    public float scoreMultiForms(Iterator<Fragment> left, Iterator<Fragment> right) {
        Fragment ln = left.next();
        Fragment rn = right.next();
        MolecularFormula formLeft = ln.getIncomingEdge().getFormula();
        MolecularFormula formRight = rn.getIncomingEdge().getFormula();
        MolecularFormula fragmentLeft = ln.getFormula();
        MolecularFormula fragmentRight = rn.getFormula();
        while (left.hasNext()) {
            ln = left.next();
            formLeft = formLeft.add(ln.getIncomingEdge().getFormula());
        }
        while (right.hasNext()) {
            rn = right.next();
            formRight = formRight.add(rn.getIncomingEdge().getFormula());
        }
        float score = this.scoreJoinFormulas(formLeft, formRight);
        if (this.useFragment) {
            score += this.scoreFormulas(fragmentLeft, fragmentRight, false);
        }
        return score;
    }

    public float join(Iterator<Fragment> leftNodes, Iterator<Fragment> rightNodes, int left, int right) {
        float score = this.scoreMultiForms(leftNodes, rightNodes);
        return score + this.penaltyForEachJoin * (float)Math.max(left, right);
    }

    public float scoreFormulas(MolecularFormula left, MolecularFormula right, boolean isLoss) {
        int length = Math.max(left.atomCount(), right.atomCount());
        int diffs = left.numberOfDifferenceHeteroAtoms(right);
        if (diffs > 0 || left.numberOfHydrogens() != right.numberOfHydrogens()) {
            if (left.isSubtractable(right) || right.isSubtractable(left)) {
                float penalty = isLoss ? this.lossMissmatchPenalty : this.missmatchPenalty;
                float perHetero = isLoss ? this.lossPenaltyForEachNonHydrogen : this.penaltyForEachNonHydrogen;
                return penalty + perHetero * (float)diffs;
            }
            float penalty = isLoss ? this.lossMissmatchPenalty : this.missmatchPenalty;
            float perHetero = isLoss ? this.lossPenaltyForEachNonHydrogen : this.penaltyForEachNonHydrogen;
            return penalty + perHetero * (float)Math.max(left.atomCount() - left.numberOfHydrogens(), right.atomCount() - right.numberOfHydrogens());
        }
        int nonHydrogens = left.atomCount() - left.numberOfHydrogens();
        return isLoss ? this.lossMatchScore + (float)nonHydrogens * this.lossScoreForEachNonHydrogen : this.matchScore + (float)nonHydrogens * this.scoreForEachNonHydrogen;
    }

    public float scoreJoinFormulas(MolecularFormula left, MolecularFormula right) {
        int length = Math.max(left.atomCount(), right.atomCount());
        int diffs = left.numberOfDifferenceHeteroAtoms(right);
        if (diffs > 0 || left.numberOfHydrogens() != right.numberOfHydrogens()) {
            return this.joinMissmatchPenalty + this.joinPenaltyForEachNonHydrogen * (float)diffs;
        }
        int nonHydrogens = left.atomCount() - left.numberOfHydrogens();
        return this.joinMatchScore + (float)nonHydrogens * this.joinScoreForEachNonHydrogen;
    }

    public float scoreVertices(Fragment left, Fragment right) {
        return Math.max(0.0f, this.scoreFormulas(left.getFormula(), right.getFormula(), false));
    }

    public float selfAlignScore(Fragment root) {
        return ((Float)new PostOrderTraversal((Object)root, (TreeAdapter)FTree.treeAdapter()).call((PostOrderTraversal.Call)new PostOrderTraversal.Call<Fragment, Float>(){

            public Float call(Fragment vertex, List<Float> values, boolean isRoot) {
                float sum = isRoot ? StandardScoring2.this.scoreVertices(vertex, vertex) : StandardScoring2.this.match(vertex, vertex);
                for (float f : values) {
                    sum += f;
                }
                return Float.valueOf(sum);
            }
        })).floatValue();
    }

    public boolean isMatching(Fragment left, Fragment right) {
        return left.getIncomingEdge().getFormula().equals(right.getIncomingEdge().getFormula());
    }
}

