/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign;

import de.unijena.bioinf.ChemistryBase.ms.ft.Fragment;
import de.unijena.bioinf.treealign.AbstractBacktrace;
import java.io.PrintStream;
import java.util.Iterator;

public class TraceLog2
extends AbstractBacktrace<Fragment> {
    private final PrintStream out;

    public TraceLog2(PrintStream out) {
        this.out = out;
    }

    public TraceLog2() {
        this.out = System.out;
    }

    public void deleteLeft(float score, Fragment node) {
        this.out.println(this.nodeInfo(node) + ",-,-," + score + ",DELETE");
    }

    private String nodeInfo(Fragment node) {
        return node.getFormula() + "," + node.getIncomingEdge().getFormula();
    }

    public void deleteRight(float score, Fragment node) {
        this.out.println("-,-," + this.nodeInfo(node) + "," + score + ",DELETE");
    }

    public void match(float score, Fragment left, Fragment right) {
        this.out.println(this.nodeInfo(left) + "," + this.nodeInfo(right) + "," + score + ",MATCH");
    }

    public void matchVertices(float score, Fragment left, Fragment right) {
        this.out.println(this.nodeInfoR(left) + "," + this.nodeInfoR(right) + "," + score + ",ROOT");
    }

    private String nodeInfoR(Fragment left) {
        return left.getFormula() + ",!";
    }

    public void join(float score, Iterator<Fragment> left, Iterator<Fragment> right, int leftNumber, int rightNumber) {
        this.out.println(this.nodeInfo(left.next()) + "," + this.nodeInfo(right.next()) + "," + score + ",JOIN");
    }

    public void innerJoinLeft(Fragment node) {
        this.out.println(this.nodeInfo(node) + ",*,*," + "0" + ",PREJOIN");
    }

    public void innerJoinRight(Fragment node) {
        this.out.println("*,*," + this.nodeInfo(node) + ",0" + ",PREJOIN");
    }
}

