/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign;

import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.ms.ft.Fragment;
import de.unijena.bioinf.counting.Weighting;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WeightingReader {
    private static Pattern Regexp = Pattern.compile("(.+?),(\\d+(?:\\.\\d*)?)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Weighting parseCSV(File csv) throws IOException {
        try (FileReader r = null;){
            r = new FileReader(csv);
            Weighting<Fragment> weighting = this.parseCSV(r);
            return weighting;
        }
    }

    public Weighting<Fragment> parseCSV(Reader csvReader) throws IOException {
        String f;
        TObjectDoubleHashMap map = new TObjectDoubleHashMap();
        double defaultScore = Double.NaN;
        BufferedReader reader = new BufferedReader(csvReader);
        String line = reader.readLine();
        if (line == null) {
            return new LossWeighting((TObjectDoubleHashMap<MolecularFormula>)map, 1.0);
        }
        Matcher h = Regexp.matcher(line);
        if (h.find()) {
            f = h.group(1);
            if (f.equals("*")) {
                defaultScore = Double.parseDouble(h.group(2));
            } else {
                map.put((Object)MolecularFormula.parse((String)f), Double.parseDouble(h.group(2)));
            }
        }
        while (reader.ready()) {
            String l = reader.readLine();
            if (l.isEmpty()) continue;
            Matcher m = Regexp.matcher(l);
            if (m.find()) {
                f = m.group(1);
                if (f.equals("*")) {
                    defaultScore = Double.parseDouble(m.group(2));
                    continue;
                }
                map.put((Object)MolecularFormula.parse((String)f), Double.parseDouble(m.group(2)));
                continue;
            }
            throw new IOException("No valid csv file");
        }
        if (Double.isNaN(defaultScore)) {
            throw new IOException("Can't find default score for unseen losses. Please provide a row '*,<score>'");
        }
        return new LossWeighting((TObjectDoubleHashMap<MolecularFormula>)map, defaultScore);
    }

    private static class LossWeighting
    implements Weighting<Fragment> {
        private final TObjectDoubleHashMap<MolecularFormula> formulas;
        private final double defaultScore;

        LossWeighting(TObjectDoubleHashMap<MolecularFormula> map, double defaultScore) {
            this.formulas = new TObjectDoubleHashMap(map.size(), 0.75f, defaultScore);
            this.formulas.putAll(map);
            this.defaultScore = defaultScore;
        }

        public double weight(Fragment u, Fragment v) {
            MolecularFormula formula = u.getIncomingEdge().getFormula();
            return this.formulas.get((Object)formula);
        }
    }
}

