/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign.analyse;

import de.unijena.bioinf.ChemistryBase.ms.ft.FTree;
import de.unijena.bioinf.ChemistryBase.ms.ft.Fragment;
import de.unijena.bioinf.ftalign.CSVMatrix;
import de.unijena.bioinf.ftalign.analyse.FTDataElement;
import de.unijena.bioinf.ftalign.analyse.Normalizer;
import de.unijena.bioinf.ftalign.analyse.Pearson;
import de.unijena.bioinf.graphUtils.tree.TreeAdapter;
import de.unijena.bioinf.treealign.Backtrace;
import de.unijena.bioinf.treealign.StackedBacktrace;
import de.unijena.bioinf.treealign.TreeAlignmentAlgorithm;
import de.unijena.bioinf.treealign.scoring.Scoring;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class FTDataset {
    private final List<FTDataElement> lefts;
    private final List<FTDataElement> rights;
    private final TreeAlignmentAlgorithm.Factory<Fragment> factory;
    private final boolean symetric;
    private final double[][] scoreMatrix;
    private volatile Backtrace<Fragment> tracer;
    private volatile Normalizer normalizer;
    private volatile List<BeforeCallback> beforeCallbacks;
    private volatile List<AfterCallback> afterCallbacks;
    private volatile boolean forceSelf;

    private FTDataset(List<FTDataElement> lefts, List<FTDataElement> rights, boolean symetric, TreeAlignmentAlgorithm.Factory<Fragment> factory) {
        this.lefts = new ArrayList<FTDataElement>(lefts);
        this.rights = new ArrayList<FTDataElement>(rights);
        for (double[] row : this.scoreMatrix = new double[lefts.size()][rights.size()]) {
            Arrays.fill(row, Double.NaN);
        }
        this.symetric = symetric;
        this.factory = factory;
        this.tracer = null;
        this.beforeCallbacks = new ArrayList<BeforeCallback>();
        this.afterCallbacks = new ArrayList<AfterCallback>();
        this.forceSelf = false;
    }

    public FTDataset(List<FTDataElement> elements, TreeAlignmentAlgorithm.Factory<Fragment> factory) {
        this(elements, elements, true, factory);
    }

    public FTDataset(List<FTDataElement> left, List<FTDataElement> right, TreeAlignmentAlgorithm.Factory<Fragment> factory) {
        this(left, right, false, factory);
    }

    public FTDataset(List<FTDataElement> elements, Scoring<Fragment> scoring, int numberOfJoins, boolean many2manyJoins) {
        this(elements, elements, true, (TreeAlignmentAlgorithm.Factory<Fragment>)new TreeAlignmentAlgorithm.Factory((TreeAdapter)FTree.treeAdapter(), scoring, numberOfJoins, many2manyJoins));
    }

    public FTDataset(List<FTDataElement> left, List<FTDataElement> right, Scoring<Fragment> scoring, int numberOfJoins, boolean many2manyJoins) {
        this(left, right, false, (TreeAlignmentAlgorithm.Factory<Fragment>)new TreeAlignmentAlgorithm.Factory((TreeAdapter)FTree.treeAdapter(), scoring, numberOfJoins, many2manyJoins));
    }

    public boolean isForceSelf() {
        return this.forceSelf;
    }

    public void setForceSelf(boolean forceSelf) {
        this.forceSelf = forceSelf;
    }

    public int rows() {
        return this.lefts.size();
    }

    public int cols() {
        return this.rights.size();
    }

    public boolean isSymetric() {
        return this.symetric;
    }

    public FTDataElement getRowElement(int row) {
        return this.lefts.get(row);
    }

    public FTDataElement getColElement(int col) {
        return this.rights.get(col);
    }

    public Normalizer getNormalizer() {
        return this.normalizer;
    }

    public void setNormalizer(Normalizer normalizer) {
        this.normalizer = normalizer;
    }

    public void pushTracer(Backtrace<Fragment> newTracer) {
        if (newTracer == null) {
            throw new IllegalArgumentException("expect non null value as argument");
        }
        if (this.tracer != null && this.tracer instanceof StackedBacktrace) {
            ((StackedBacktrace)this.tracer).push(newTracer);
        } else if (this.tracer == null) {
            this.setTracer(newTracer);
        } else {
            StackedBacktrace stack = new StackedBacktrace();
            stack.push(this.tracer);
            stack.push(newTracer);
            this.tracer = stack;
        }
    }

    public CSVMatrix toCSV() {
        int i;
        double[][] matrixCopy = new double[this.lefts.size()][];
        for (int row = 0; row < this.lefts.size(); ++row) {
            matrixCopy[row] = Arrays.copyOf(this.scoreMatrix[row], this.scoreMatrix[row].length);
        }
        String[] rowNames = new String[this.lefts.size()];
        String[] colNames = new String[this.rights.size()];
        for (i = 0; i < rowNames.length; ++i) {
            rowNames[i] = this.lefts.get(i).getName();
        }
        for (i = 0; i < colNames.length; ++i) {
            colNames[i] = this.rights.get(i).getName();
        }
        return new CSVMatrix(rowNames, colNames, matrixCopy);
    }

    public Backtrace<Fragment> getTracer() {
        return this.tracer;
    }

    public void setTracer(Backtrace<Fragment> newTracer) {
        this.tracer = newTracer;
    }

    public void pushBeforeCallback(BeforeCallback callback) {
        this.beforeCallbacks.add(callback);
    }

    public List<BeforeCallback> getBeforeCallbacks() {
        return Collections.unmodifiableList(this.beforeCallbacks);
    }

    public void pushAfterCallback(AfterCallback callback) {
        this.afterCallbacks.add(callback);
    }

    public List<AfterCallback> getAfterCallback() {
        return Collections.unmodifiableList(this.afterCallbacks);
    }

    public void computeAllParallel() {
        this.computeAllParallel(false, Runtime.getRuntime().availableProcessors());
    }

    public void computeAllParallel(final boolean forced, int numberOfCPUs) {
        if (numberOfCPUs == 1) {
            this.computeAll(forced);
            return;
        }
        if (numberOfCPUs < 1) {
            throw new IllegalArgumentException("illegal number of threads: " + numberOfCPUs);
        }
        ArrayList<Future<Object>> queue = new ArrayList<Future<Object>>(this.lefts.size());
        ExecutorService executor = Executors.newFixedThreadPool(numberOfCPUs);
        for (int i = 0; i < this.lefts.size(); ++i) {
            queue.clear();
            int j = 0;
            while (j < this.rights.size()) {
                final int n = i;
                final int jvalue = j++;
                queue.add(executor.submit(new Callable<Object>(){

                    @Override
                    public Object call() {
                        if (forced) {
                            FTDataset.this.forceCompute(n, jvalue);
                        } else {
                            FTDataset.this.compute(n, jvalue);
                        }
                        return true;
                    }
                }));
            }
            for (Future future : queue) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
        executor.shutdown();
        try {
            executor.awaitTermination(60L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void computeAll() {
        this.computeAll(false);
    }

    public void computeAll(boolean forced) {
        for (int i = 0; i < this.lefts.size(); ++i) {
            for (int j = 0; j < this.rights.size(); ++j) {
                if (forced) {
                    this.forceCompute(i, j);
                    continue;
                }
                this.compute(i, j);
            }
        }
    }

    public double get(int i, int j) {
        return this.scoreMatrix[i][j];
    }

    public void computeFingerprints() {
        if (this.symetric) {
            this.computeSymetricFingerprints();
        } else {
            this.computeAssymetricFingerprints();
        }
    }

    private void computeAssymetricFingerprints() {
        this.computeSymetricFingerprints();
    }

    private void computeSymetricFingerprints() {
        int i;
        double[][] newMatrix = new double[this.lefts.size()][this.rights.size()];
        for (i = 0; i < this.lefts.size(); ++i) {
            double[] vectorLeft = this.scoreMatrix[i];
            for (int j = i; j < this.rights.size(); ++j) {
                double pearson;
                double[] vectorRight = this.scoreMatrix[j];
                newMatrix[i][j] = pearson = Pearson.pearson(vectorLeft, vectorRight);
                newMatrix[j][i] = pearson;
            }
        }
        for (i = 0; i < this.scoreMatrix.length; ++i) {
            System.arraycopy(newMatrix[i], 0, this.scoreMatrix[i], 0, this.scoreMatrix[i].length);
        }
    }

    public double compute(int i, int j) {
        if (!Double.isNaN(this.scoreMatrix[i][j])) {
            return this.scoreMatrix[i][j];
        }
        if (i == j && this.symetric && !this.forceSelf) {
            float score = this.factory.getScoring().selfAlignScore((Object)this.lefts.get(i).getTree().getRoot());
            return this.set(i, i, this.normalize(this.lefts.get(i).getTree(), this.rights.get(i).getTree(), score));
        }
        return this.forceCompute(i, j);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double forceCompute(int i, int j) {
        FTDataElement left = this.lefts.get(i);
        FTDataElement right = this.rights.get(j);
        this.execBeforeCallback(left, right);
        TreeAlignmentAlgorithm alg = this.factory.create((Object)left.getTree().getRoot(), (Object)right.getTree().getRoot());
        float origScore = alg.compute();
        double score = this.normalize(left.getTree(), right.getTree(), origScore);
        this.set(i, j, score);
        if (this.tracer != null || this.afterCallbacks != null) {
            FTDataset fTDataset = this;
            synchronized (fTDataset) {
                if (this.tracer != null) {
                    alg.backtrace(this.tracer);
                }
                for (AfterCallback ac : this.afterCallbacks) {
                    ac.run(left, right, i, j, this.tracer, score);
                }
            }
        }
        return score;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execBeforeCallback(FTDataElement left, FTDataElement right) {
        if (this.beforeCallbacks == null) {
            return;
        }
        FTDataset fTDataset = this;
        synchronized (fTDataset) {
            for (BeforeCallback bc : this.beforeCallbacks) {
                bc.run(left, right);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double set(int i, int j, double value) {
        FTDataset fTDataset = this;
        synchronized (fTDataset) {
            this.scoreMatrix[i][j] = value;
            if (this.symetric && i != j) {
                this.scoreMatrix[j][i] = value;
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double normalize(FTree left, FTree right, float score) {
        FTDataset fTDataset = this;
        synchronized (fTDataset) {
            return this.normalizer == null ? (double)score : this.normalizer.normalize(left, right, (Scoring<Fragment>)this.factory.getScoring(), score);
        }
    }

    public static interface AfterCallback {
        public void run(FTDataElement var1, FTDataElement var2, int var3, int var4, Backtrace<Fragment> var5, double var6);
    }

    public static interface BeforeCallback {
        public void run(FTDataElement var1, FTDataElement var2);
    }
}

