/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign.analyse;

public class Pearson {
    public static double pearson(double[] xs, double[] ys) {
        double Exs = Pearson.expectation(xs);
        double Eys = Pearson.expectation(ys);
        double n = Math.sqrt(Pearson.variance(xs, Exs)) * Math.sqrt(Pearson.variance(ys, Eys));
        return Pearson.covariance(xs, ys, Exs, Eys) / n;
    }

    public static double expectation(double[] xs) {
        double sum = 0.0;
        for (int i = 0; i < xs.length; ++i) {
            sum += xs[i];
        }
        return sum /= (double)xs.length;
    }

    public static double variance(double[] xs) {
        return Pearson.variance(xs, Pearson.expectation(xs));
    }

    public static double variance(double[] xs, double expectation) {
        double sum = 0.0;
        for (int i = 0; i < xs.length; ++i) {
            double d = xs[i] - expectation;
            sum += d * d;
        }
        return sum / (double)xs.length;
    }

    public static double covariance(double[] xs, double[] ys) {
        return Pearson.covariance(xs, ys, Pearson.expectation(xs), Pearson.expectation(ys));
    }

    public static double covariance(double[] xs, double[] ys, double expectation_x, double expectation_y) {
        if (xs.length != ys.length) {
            throw new IllegalArgumentException("Both arrays should have the same length!");
        }
        double sum = 0.0;
        for (int i = 0; i < xs.length; ++i) {
            sum += (xs[i] - expectation_x) * (ys[i] - expectation_y);
        }
        return sum / (double)xs.length;
    }
}

