/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign.analyse;

import de.unijena.bioinf.ChemistryBase.ms.ft.FTree;
import de.unijena.bioinf.ChemistryBase.ms.ft.Fragment;
import de.unijena.bioinf.ftalign.analyse.Normalizer;
import de.unijena.bioinf.treealign.scoring.Scoring;

public class TreeSizeNormalizer
implements Normalizer {
    private final double c;

    public TreeSizeNormalizer(double c) {
        this.c = c;
    }

    @Override
    public double normalize(FTree left, FTree right, Scoring<Fragment> scoring, float score) {
        double f = Math.min(this.score(left, scoring), this.score(right, scoring));
        assert (f > 0.0);
        assert (Math.pow(f, this.c) > 0.0);
        return (double)score / Math.pow(f, this.c);
    }

    public double score(FTree tree, Scoring<Fragment> scoring) {
        return scoring.selfAlignScore((Object)tree.getRoot());
    }
}

