/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign.graphics;

import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.ms.ft.Fragment;
import de.unijena.bioinf.ftalign.analyse.FTDataElement;
import de.unijena.bioinf.treealign.AbstractBacktrace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GraphicalBacktrace
extends AbstractBacktrace<Fragment> {
    private static final Pattern nodePattern = Pattern.compile("([A-z_0-9]+)\\s*\\[label=\"([^\\\\]+)");
    private static final Pattern edgePattern = Pattern.compile("([A-z_0-9]+)\\s*->\\s*([A-z_0-9]+)\\s*\\[label=\"([^\"]+)");
    private static final int minEdgeLength = 1;
    private static final double ranksep = 1.0;
    private static final boolean enumerateNodes = false;
    private static final boolean polyLines = false;
    private static final boolean firstTreeMirrored = true;
    private Color color = new Color();
    private List<String> dotFile = new LinkedList<String>();
    private Map<MolecularFormula, String> leftNodes = new HashMap<MolecularFormula, String>();
    private Map<MolecularFormula, String> leftNodesLabel = new HashMap<MolecularFormula, String>();
    private Map<MolecularFormula, String> rightNodes = new HashMap<MolecularFormula, String>();
    private Map<MolecularFormula, String> rightNodesLabel = new HashMap<MolecularFormula, String>();
    private Map<FormulaEdge, String> leftEdges = new HashMap<FormulaEdge, String>();
    private Map<FormulaEdge, String> rightEdges = new HashMap<FormulaEdge, String>();
    private List<Fragment[]> matchedList = new LinkedList<Fragment[]>();
    private Set<FragmentationTreeWrapper> addedWrapper;
    private Map<Fragment, FragmentationTreeWrapper> treeToWrapper;
    private int enumerator;

    public GraphicalBacktrace(FTDataElement left, FTDataElement right) {
        try {
            FormulaEdge formulaEdge;
            MolecularFormula formula;
            Matcher m;
            String line;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(left.getSource().getFile()));
            while (bufferedReader.ready()) {
                line = bufferedReader.readLine();
                if (!line.contains("->")) {
                    m = nodePattern.matcher(line);
                    if (!m.find()) continue;
                    formula = MolecularFormula.parse((String)m.group(2));
                    this.leftNodes.put(formula, m.group(1));
                    this.leftNodesLabel.put(formula, m.group(2));
                    continue;
                }
                m = edgePattern.matcher(line);
                if (!m.find()) continue;
                formulaEdge = new FormulaEdge(MolecularFormula.parse((String)m.group(1)), MolecularFormula.parse((String)m.group(2)));
                this.leftEdges.put(formulaEdge, m.group(3));
            }
            bufferedReader = new BufferedReader(new FileReader(right.getSource().getFile()));
            while (bufferedReader.ready()) {
                line = bufferedReader.readLine();
                if (!line.contains("->")) {
                    m = nodePattern.matcher(line);
                    if (!m.find()) continue;
                    formula = MolecularFormula.parse((String)m.group(2));
                    this.rightNodes.put(formula, m.group(1));
                    this.rightNodesLabel.put(formula, m.group(2));
                    continue;
                }
                m = edgePattern.matcher(line);
                if (!m.find()) continue;
                formulaEdge = new FormulaEdge(MolecularFormula.parse((String)m.group(1)), MolecularFormula.parse((String)m.group(2)));
                this.rightEdges.put(formulaEdge, m.group(3));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.dotFile.add("digraph DiG {");
        this.dotFile.add("label=\"" + left.getName() + " compared with " + right.getName() + "\"");
        this.dotFile.add("ranksep=1.0");
        this.dotFile.add("node[odering=out]");
        this.dotFile.add("{rank=min");
        this.dotFile.add(this.makeNode(this.leftNodes.get(left.getTree().getRoot()) + "Left", this.leftNodesLabel.get(left.getTree().getRoot()), null, null));
        this.dotFile.add(this.makeNode(this.rightNodes.get(right.getTree().getRoot()) + "Right", this.rightNodesLabel.get(right.getTree().getRoot()), null, null));
        this.dotFile.add("}");
        this.addedWrapper = new HashSet<FragmentationTreeWrapper>();
        this.treeToWrapper = new HashMap<Fragment, FragmentationTreeWrapper>();
        LinkedList<FragmentationTreeWrapper> queue = new LinkedList<FragmentationTreeWrapper>();
        FragmentationTreeWrapper leftWrapperRoot = new FragmentationTreeWrapper(left.getTree().getRoot());
        this.treeToWrapper.put(left.getTree().getRoot(), leftWrapperRoot);
        queue.add(leftWrapperRoot);
        while (!queue.isEmpty()) {
            FragmentationTreeWrapper current = (FragmentationTreeWrapper)queue.poll();
            for (Fragment child : current.getFragmentationTree().getChildren()) {
                FragmentationTreeWrapper newWrapper = new FragmentationTreeWrapper(child);
                this.treeToWrapper.put(child, newWrapper);
                newWrapper.setParent(current);
                queue.add(newWrapper);
            }
        }
        queue = new LinkedList();
        FragmentationTreeWrapper rightWrapperRoot = new FragmentationTreeWrapper(right.getTree().getRoot());
        this.treeToWrapper.put(right.getTree().getRoot(), rightWrapperRoot);
        queue.add(rightWrapperRoot);
        while (!queue.isEmpty()) {
            FragmentationTreeWrapper current = (FragmentationTreeWrapper)queue.poll();
            for (Fragment child : current.getFragmentationTree().getChildren()) {
                FragmentationTreeWrapper newWrapper = new FragmentationTreeWrapper(child);
                this.treeToWrapper.put(child, newWrapper);
                newWrapper.setParent(current);
                queue.add(newWrapper);
            }
        }
    }

    public void writeGraphicalOutput(FTDataElement left, FTDataElement right, File dir) {
        for (int i = 0; i < 2; ++i) {
            for (Fragment fragTree : i == 0 ? this.getTraversal(left.getTree().getRoot()) : this.getTraversal(right.getTree().getRoot())) {
                FragmentationTreeWrapper treeWrapper = this.treeToWrapper.get(fragTree);
                if (this.addedWrapper.contains(treeWrapper) || treeWrapper.isRoot()) continue;
                treeWrapper.getParent().addChild(treeWrapper);
            }
            for (FragmentationTreeWrapper treeWrapper : i == 0 ? this.getTraversalWrapperReverse(this.treeToWrapper.get(left.getTree().getRoot())) : this.getTraversalWrapper(this.treeToWrapper.get(right.getTree().getRoot()))) {
                MolecularFormula formula = treeWrapper.getFragmentationTree().getFormula();
                this.dotFile.add(this.makeNode((i == 0 ? this.leftNodes : this.rightNodes).get(formula) + (i == 0 ? "Left" : "Right"), (i == 0 ? this.leftNodesLabel : this.rightNodesLabel).get(formula), treeWrapper.getShape(), treeWrapper.getColor()));
                if (treeWrapper.isRoot()) continue;
                this.addEdge(treeWrapper.getParent().getFragmentationTree().getFormula(), formula, treeWrapper.getColor(), i == 0, treeWrapper.getEdgeLength());
            }
        }
        this.dotFile.add("edge[dir=none]");
        for (Fragment[] fragmentationTrees : this.matchedList) {
            if (fragmentationTrees[0] == null || fragmentationTrees[1] == null) continue;
            this.dotFile.add(this.makeEdge("LeftLoss" + this.leftNodes.get(fragmentationTrees[0].getFormula()), "RightLoss" + this.rightNodes.get(fragmentationTrees[1].getFormula()), null, "\"dotted,bold\"", 4.0, null, false));
            this.dotFile.add("{rank=same; LeftLoss" + this.leftNodes.get(fragmentationTrees[0].getFormula()) + "; RightLoss" + this.rightNodes.get(fragmentationTrees[1].getFormula()) + "}");
        }
        this.dotFile.add("}");
        try {
            assert (dir.isDirectory());
            File[] files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String[] split = name.split("\\.");
                    return split.length == 2 && split[1].equals("dot") && GraphicalBacktrace.this.isIntNumber(split[0]);
                }
            });
            int lastIndex = 0;
            for (int i = 0; i < files.length; ++i) {
                int number = Integer.parseInt(files[i].getName().split("\\.")[0]);
                if (number <= lastIndex) continue;
                lastIndex = number;
            }
            File logFile = new File(dir + "/" + "log");
            BufferedWriter bwLog = null;
            if (!logFile.exists() && !logFile.exists()) {
                bwLog = new BufferedWriter(new FileWriter(logFile, true));
                bwLog.write("FileNumber Metabolite1 Metabolite2");
                bwLog.newLine();
            }
            if (bwLog == null) {
                bwLog = new BufferedWriter(new FileWriter(logFile, true));
            }
            bwLog.write(lastIndex + 1 + ": " + left.getName() + " " + right.getName());
            bwLog.newLine();
            bwLog.flush();
            bwLog.close();
            File file = new File(dir + "/" + (lastIndex + 1) + ".dot");
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            for (String s : this.dotFile) {
                bw.write(s);
                bw.newLine();
            }
            bw.flush();
            bw.close();
            String dotPath = new File("/usr/local/bin/dot").exists() ? "/usr/local/bin/dot" : (new File("/usr/bin/dot").exists() ? "/usr/bin/dot" : "dot");
            ProcessBuilder proc = new ProcessBuilder(dotPath, "-T", "svg", "-o", file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - 4) + ".svg", file.getAbsolutePath());
            proc.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public void deleteLeft(float score, Fragment node) {
        super.deleteLeft(score, (Object)node);
    }

    public void deleteRight(float score, Fragment node) {
        super.deleteRight(score, (Object)node);
    }

    public void match(float score, Fragment left, Fragment right) {
        super.match(score, (Object)left, (Object)right);
        this.matchedList.add(new Fragment[]{left, right});
        String colorString = this.color.nextColor();
        this.addMatched(left, colorString);
        this.addMatched(right, colorString);
    }

    public void matchVertices(float score, Fragment left, Fragment right) {
        super.matchVertices(score, (Object)left, (Object)right);
        this.matchedList.add(new Fragment[]{left, right});
        String colorString = this.color.nextColor();
        this.addMatched(left, colorString);
        this.addMatched(right, colorString);
    }

    private void addMatched(Fragment fragmentationTree, String color) {
        boolean backToRoot = true;
        Fragment current = fragmentationTree;
        FragmentationTreeWrapper currentWrapper = this.treeToWrapper.get(current);
        currentWrapper.setColor(color);
        while (backToRoot) {
            if (!this.addedWrapper.contains(currentWrapper) && !currentWrapper.isRoot()) {
                currentWrapper.getParent().addChild(currentWrapper);
                this.addedWrapper.add(currentWrapper);
                currentWrapper = currentWrapper.getParent();
                continue;
            }
            backToRoot = false;
        }
    }

    public void join(float score, Iterator<Fragment> left, Iterator<Fragment> right, int leftNumber, int rightNumber) {
        super.join(score, left, right, leftNumber, rightNumber);
        this.addJoined(left, right, this.color.nextColor());
    }

    private void addJoined(Iterator<Fragment> left, Iterator<Fragment> right, String color) {
        int leftLength = 0;
        Iterator<Fragment> fragmentationTreeIterator = left;
        Fragment last1 = null;
        while (fragmentationTreeIterator.hasNext()) {
            Fragment fT = fragmentationTreeIterator.next();
            ++leftLength;
            if (last1 != null) continue;
            last1 = fT;
        }
        int rightLength = 0;
        fragmentationTreeIterator = right;
        Fragment last2 = null;
        while (fragmentationTreeIterator.hasNext()) {
            Fragment fT = fragmentationTreeIterator.next();
            ++rightLength;
            if (last2 != null) continue;
            last2 = fT;
        }
        this.dotFile.add("{rank=same; " + this.leftNodes.get(last1.getFormula()) + "Left ; " + this.rightNodes.get(last2.getFormula()) + "Right}");
        int max = Math.max(leftLength, rightLength);
        for (int i = 0; i <= 1; ++i) {
            FragmentationTreeWrapper currentWrapper = this.treeToWrapper.get(i == 0 ? last1 : last2);
            boolean backToRoot = true;
            for (int j = 0; j < (i == 0 ? leftLength : rightLength); ++j) {
                currentWrapper.setColor(color);
                currentWrapper.setEdgeLength(1.0 * (double)max / (double)(i == 0 ? leftLength : rightLength) * 1.0);
                currentWrapper.setShape("octagon");
                if (backToRoot && !this.addedWrapper.contains(currentWrapper) && !currentWrapper.isRoot()) {
                    currentWrapper.getParent().addChild(currentWrapper);
                    this.addedWrapper.add(currentWrapper);
                    currentWrapper = currentWrapper.getParent();
                    continue;
                }
                backToRoot = false;
            }
        }
    }

    private String makeNode(String name, String label, String shape, String color) {
        return name + "[" + (label == null ? "" : "label=\"" + "" + label + "\", ") + (shape == null ? "" : "shape=" + shape + ", ") + "style=filled, " + (color == null ? "" : "color=\"" + color + "\", ") + "]";
    }

    private String makeEdge(String out, String in, String label, String style, double length, String group, boolean constraint) {
        return out + " -> " + in + " [" + (label == null ? "" : "label=\"" + "" + label + "\", ") + (style == null ? "" : "style=" + style + ", ") + (length == 0.0 ? "" : "len=" + length + ", ") + (group == null ? "" : "group=" + group + ", ") + (constraint ? "" : "constraint=false, ") + (length == 0.0 ? "" : "minlen=" + length + ", ") + "]";
    }

    private void addEdge(MolecularFormula parent, MolecularFormula child, String color, boolean left, double length) {
        FormulaEdge formulaEdge;
        if (!(left ? this.leftEdges : this.rightEdges).containsKey(formulaEdge = new FormulaEdge(parent, child))) {
            return;
        }
        String fragment = left ? this.leftNodes.get(formulaEdge.getIn()) : this.rightNodes.get(formulaEdge.getIn());
        this.dotFile.add(this.makeNode((left ? "LeftLoss" : "RightLoss") + fragment, (left ? this.leftEdges : this.rightEdges).get(formulaEdge), "box", color));
        if (left) {
            this.dotFile.add(this.makeEdge(this.leftNodes.get(formulaEdge.getOut()) + "Left", "LeftLoss" + fragment, null, null, Math.round(length * 100.0) / 100L, "group1", true));
            this.dotFile.add(this.makeEdge("LeftLoss" + fragment, this.leftNodes.get(formulaEdge.getIn()) + "Left", null, null, Math.round(length * 100.0) / 100L, "group1", true));
        } else {
            this.dotFile.add(this.makeEdge(this.rightNodes.get(formulaEdge.getOut()) + "Right", "RightLoss" + fragment, null, null, Math.round(length * 100.0) / 100L, "group2", true));
            this.dotFile.add(this.makeEdge("RightLoss" + fragment, this.rightNodes.get(formulaEdge.getIn()) + "Right", null, null, Math.round(length * 100.0) / 100L, "group2", true));
        }
    }

    private List<Fragment> getTraversal(Fragment fragmentationTree) {
        LinkedList<Fragment> ordering = new LinkedList<Fragment>();
        LinkedList<Fragment> queue = new LinkedList<Fragment>();
        queue.add(fragmentationTree);
        while (!queue.isEmpty()) {
            Fragment current = (Fragment)queue.poll();
            ordering.add(current);
            for (Fragment child : current.getChildren()) {
                queue.add(child);
            }
        }
        return ordering;
    }

    private List<FragmentationTreeWrapper> getTraversalWrapper(FragmentationTreeWrapper fragmentationTree) {
        LinkedList<FragmentationTreeWrapper> ordering = new LinkedList<FragmentationTreeWrapper>();
        LinkedList<FragmentationTreeWrapper> queue = new LinkedList<FragmentationTreeWrapper>();
        queue.add(fragmentationTree);
        while (!queue.isEmpty()) {
            FragmentationTreeWrapper current = (FragmentationTreeWrapper)queue.poll();
            ordering.add(current);
            for (FragmentationTreeWrapper child : current.getChildren()) {
                queue.add(child);
            }
        }
        return ordering;
    }

    private List<FragmentationTreeWrapper> getTraversalWrapperReverse(FragmentationTreeWrapper fragmentationTree) {
        LinkedList<FragmentationTreeWrapper> ordering = new LinkedList<FragmentationTreeWrapper>();
        LinkedList<FragmentationTreeWrapper> queue = new LinkedList<FragmentationTreeWrapper>();
        queue.add(fragmentationTree);
        while (!queue.isEmpty()) {
            FragmentationTreeWrapper current = (FragmentationTreeWrapper)queue.poll();
            ordering.add(current);
            while (!current.getChildren().isEmpty()) {
                queue.add(current.getChildren().removeLast());
            }
        }
        return ordering;
    }

    public boolean isIntNumber(String num) {
        try {
            Integer.parseInt(num);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private class FragmentationTreeWrapper {
        private String color;
        private String shape;
        private double edgeLength;
        private Fragment fragmentationTree;
        private FragmentationTreeWrapper parent;
        private LinkedList<FragmentationTreeWrapper> children;

        private FragmentationTreeWrapper(Fragment fragmentationTree) {
            this.fragmentationTree = fragmentationTree;
            this.children = new LinkedList();
            this.color = "gray";
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public String getShape() {
            return this.shape;
        }

        public void setShape(String shape) {
            this.shape = shape;
        }

        public double getEdgeLength() {
            return this.edgeLength;
        }

        public void setEdgeLength(double edgeLength) {
            this.edgeLength = edgeLength;
        }

        public LinkedList<FragmentationTreeWrapper> getChildren() {
            return this.children;
        }

        public void setChildren(LinkedList<FragmentationTreeWrapper> children) {
            this.children = children;
        }

        public void addChild(FragmentationTreeWrapper child) {
            this.children.add(child);
        }

        public FragmentationTreeWrapper getParent() {
            return this.parent;
        }

        public void setParent(FragmentationTreeWrapper parent) {
            this.parent = parent;
        }

        public boolean isRoot() {
            return this.fragmentationTree.isRoot();
        }

        public Fragment getFragmentationTree() {
            return this.fragmentationTree;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FragmentationTreeWrapper)) {
                return false;
            }
            FragmentationTreeWrapper that = (FragmentationTreeWrapper)o;
            return !(this.fragmentationTree != null ? !this.fragmentationTree.equals(that.fragmentationTree) : that.fragmentationTree != null);
        }

        public int hashCode() {
            return this.fragmentationTree != null ? this.fragmentationTree.hashCode() : 0;
        }
    }

    private class Color {
        private static final String firstColor = "ff0000";
        private final int stepsize = 0xB6DB6D;
        private final int maxValue = 0x1000000;
        private String color = "ff0000";

        private Color() {
        }

        public String nextColor() {
            String current = this.color;
            this.changeColor();
            return "#" + current;
        }

        private void changeColor() {
            this.color = Integer.toHexString((Integer.parseInt(this.color, 16) + 0xB6DB6D) % 0x1000000);
        }

        public void reset() {
            this.color = firstColor;
        }
    }

    private class FormulaEdge {
        private MolecularFormula formula1;
        private MolecularFormula formula2;

        FormulaEdge(MolecularFormula formula1, MolecularFormula formula2) {
            this.formula1 = formula1;
            this.formula2 = formula2;
        }

        MolecularFormula getOut() {
            return this.formula1;
        }

        MolecularFormula getIn() {
            return this.formula2;
        }

        public int hashCode() {
            return 17 * this.formula1.hashCode() + 37 * this.formula2.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof FormulaEdge)) {
                return false;
            }
            FormulaEdge formulaEdge = (FormulaEdge)object;
            return this.formula1.equals(formulaEdge.getOut()) && this.formula2.equals(formulaEdge.getIn());
        }
    }
}

