/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign.graphics;

import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.ms.Peak;
import de.unijena.bioinf.ChemistryBase.ms.ft.FTree;
import de.unijena.bioinf.ChemistryBase.ms.ft.Fragment;
import de.unijena.bioinf.ChemistryBase.ms.ft.FragmentAnnotation;
import de.unijena.bioinf.graphUtils.tree.PreOrderTraversal;
import de.unijena.bioinf.treealign.AlignmentTree;
import java.awt.Color;
import java.io.PrintStream;
import java.util.regex.Pattern;

public class GraphicalBacktrace2 {
    private final PrintStream outWriter;
    private FragmentAnnotation<Peak> leftAno;
    private FragmentAnnotation<Peak> rightAno;
    private final AlignmentTree<Fragment> alignment;
    private boolean printPrettyFormulas = true;
    private int cellPadding;
    private static Pattern famount = Pattern.compile("(\\d+)");

    public GraphicalBacktrace2(PrintStream outWriter, FTree left, FTree right, AlignmentTree<Fragment> alignment) {
        this.outWriter = outWriter;
        this.leftAno = left.getFragmentAnnotationOrThrow(Peak.class);
        this.rightAno = right.getFragmentAnnotationOrThrow(Peak.class);
        this.alignment = alignment;
        this.cellPadding = 5;
    }

    public void print() {
        this.outWriter.println("strict digraph {\nnode[shape=none];");
        if (this.alignment.getRoot() != null) {
            PreOrderTraversal.TreeIterator iterator = new PreOrderTraversal.TreeIterator(this.alignment.getCursor());
            while (iterator.hasNext()) {
                AlignmentTree.Node u = (AlignmentTree.Node)iterator.next();
                this.printNode((AlignmentTree.Node<Fragment>)u);
            }
        }
        this.outWriter.println("}");
    }

    public boolean isPrintPrettyFormulas() {
        return this.printPrettyFormulas;
    }

    public void setPrintPrettyFormulas(boolean printPrettyFormulas) {
        this.printPrettyFormulas = printPrettyFormulas;
    }

    private void printNode(AlignmentTree.Node<Fragment> u) {
        this.printNodeId(u);
        this.startTable(u);
        if (u.left != null) {
            this.printNode((Fragment)u.left, this.leftAno, u.isJoin());
        } else if (u.isJoin()) {
            this.printDeletion('*');
        } else {
            this.printDeletion('-');
        }
        if (u.right != null) {
            this.printNode((Fragment)u.right, this.rightAno, u.isJoin());
        } else if (u.isJoin()) {
            this.printDeletion('*');
        } else {
            this.printDeletion('-');
        }
        this.endTable(u.score);
        this.outWriter.print(">];\n");
        if (u.getParent() != null) {
            this.printEdge((AlignmentTree.Node<Fragment>)u.getParent(), u);
        }
    }

    public void setTrees(FTree left, FTree right) {
        this.leftAno = left.getFragmentAnnotationOrThrow(Peak.class);
        this.rightAno = right.getFragmentAnnotationOrThrow(Peak.class);
    }

    private void printNodeId(AlignmentTree.Node<Fragment> node) {
        this.outWriter.print("v");
        this.outWriter.print(node.getIndex());
    }

    private void printEdge(AlignmentTree.Node<Fragment> a, AlignmentTree.Node<Fragment> b) {
        boolean joinEdge = b.isJoin();
        this.printNodeId(a);
        this.outWriter.print(" -> ");
        this.printNodeId(b);
        this.outWriter.print(" [label=<");
        this.outWriter.print(b.left != null ? this.prettyFormula(((Fragment)b.left).getIncomingEdge().getFormula()) : (joinEdge ? "*" : "-"));
        this.outWriter.print(" / ");
        this.outWriter.print(b.right != null ? this.prettyFormula(((Fragment)b.right).getIncomingEdge().getFormula()) : (joinEdge ? "*" : "-"));
        this.outWriter.print(">");
        if (b.left != null && b.right != null && ((Fragment)b.left).getIncomingEdge().getFormula().equals(((Fragment)b.right).getIncomingEdge().getFormula())) {
            this.outWriter.print(", penwidth=3, color=\"#04B404\"");
        }
        this.outWriter.print("];\n");
    }

    private String colorScheme(AlignmentTree.Node<Fragment> a) {
        if (a.isJoinTerminalNode()) {
            return "#FFB600";
        }
        if (a.isJoin()) {
            return "#FFFF00";
        }
        if (a.left == null || a.right == null) {
            return "#F78181";
        }
        if (a.getParent() == null) {
            return "#E6E6E6";
        }
        if (((Fragment)a.left).getFormula().equals(((Fragment)a.right).getFormula()) && ((Fragment)a.left).getIncomingEdge().getFormula().equals(((Fragment)a.right).getIncomingEdge().getFormula())) {
            return "#04B404";
        }
        if (a.score > 0.0) {
            return "#81F781";
        }
        return "#E6E6E6";
    }

    private String joinColor(int join) {
        Color c = Color.getHSBColor(0.13f, 1.0f - Math.min(1.0f, (float)(join - 1) * 0.5f), 1.0f - Math.min(1.0f, (float)(join - 1) * 0.05f));
        return String.format("#%x", c.getRGB() & 0xFFFFFF);
    }

    private void printDeletion(char symbol) {
        this.outWriter.print("<td bgcolor='#DF0101'>");
        this.outWriter.append(symbol);
        this.outWriter.print("</td>");
    }

    private String prettyFormula(MolecularFormula f) {
        if (this.printPrettyFormulas) {
            String s = f.toString();
            return famount.matcher(s).replaceAll("<sub>$1</sub>");
        }
        return f.toString();
    }

    private void printNode(Fragment node, FragmentAnnotation<Peak> ano, boolean isJoin) {
        this.outWriter.print("<td");
        this.outWriter.append('>');
        this.outWriter.print(this.prettyFormula(node.getFormula()));
        this.outWriter.print("<br />");
        this.outWriter.print(String.format("%.5f Da<br />%.1f %%", ((Peak)ano.get(node)).getMass(), ((Peak)ano.get(node)).getIntensity() * 100.0));
        this.outWriter.print("</td>");
    }

    private void endTable(double score) {
        this.outWriter.print("</tr>");
        if (score != 0.0) {
            this.outWriter.print("<tr><td colspan='2'>");
            this.outWriter.print(score);
            this.outWriter.print("</td></tr>");
        }
        this.outWriter.print("</table>");
    }

    private void startTable(AlignmentTree.Node<Fragment> node) {
        this.outWriter.print(" [label=<<table style='rounded' cellpadding='" + this.cellPadding + "' bgcolor='" + this.colorScheme(node) + "'><tr>");
    }

    public void setCellPadding(int cellPadding) {
        this.cellPadding = cellPadding;
    }

    public int getCellPadding() {
        return this.cellPadding;
    }
}

