/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign.parallelograms;

import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.ms.ft.FTree;
import de.unijena.bioinf.ChemistryBase.ms.ft.Fragment;
import de.unijena.bioinf.ftalign.parallelograms.ParaNodes;
import java.util.ArrayList;
import java.util.BitSet;

public class ParaCount {
    private final ArrayList<ParaNodes> parallelogram;
    private final BitSet flagged;

    public ParaCount(FTree tree) {
        Fragment root = tree.getRoot();
        this.parallelogram = new ArrayList();
        this.flagged = new BitSet(tree.numberOfVertices());
        this.OuterTraversal(root, root);
    }

    public ArrayList<ParaNodes> getParallelogram() {
        return this.parallelogram;
    }

    private void OuterTraversal(Fragment u, Fragment root) {
        this.flagged.set(u.getVertexId(), true);
        this.InnerTraversal(u, root, root, root, false);
        for (int i = 0; i < u.getOutDegree(); ++i) {
            this.OuterTraversal(u.getChildren(i), root);
        }
        this.flagged.set(u.getVertexId(), false);
    }

    private void InnerTraversal(Fragment u, Fragment v, Fragment x, Fragment y, Boolean updateY) {
        if (u.getFormula().equals(v.getFormula())) {
            return;
        }
        if (this.flagged.get(v.getVertexId())) {
            x = v;
        } else {
            MolecularFormula vANDx;
            MolecularFormula uANDy;
            if (updateY.booleanValue()) {
                y = v;
            }
            if ((uANDy = u.getFormula().add(y.getFormula())).equals(vANDx = v.getFormula().add(x.getFormula()))) {
                ParaNodes nodes = new ParaNodes(x, y, u, v);
                this.parallelogram.add(nodes);
            }
            if (!vANDx.isSubtractable(uANDy) || !uANDy.isSubtractable(x.getFormula())) {
                return;
            }
        }
        for (int i = 0; i < v.getOutDegree(); ++i) {
            this.InnerTraversal(u, v.getChildren(i), x, y, this.flagged.get(v.getVertexId()));
        }
    }
}

