/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ftalign.parallelograms;

import de.unijena.bioinf.ChemistryBase.ms.ft.FTree;
import de.unijena.bioinf.ChemistryBase.ms.ft.Fragment;
import de.unijena.bioinf.babelms.GenericParser;
import de.unijena.bioinf.babelms.Parser;
import de.unijena.bioinf.babelms.dot.FTDotReader;
import de.unijena.bioinf.babelms.dot.FTDotWriter;
import de.unijena.bioinf.ftalign.parallelograms.ParaCount;
import de.unijena.bioinf.ftalign.parallelograms.ParaNodes;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class ParallelogramIterator
implements Iterator<FTree> {
    private int i;
    private int k;
    private int n;
    private ArrayList<ParaNodes> parallelograms;
    private FTree originalTree;
    private FTree modifiedtree;

    public ParallelogramIterator(FTree originalTree) {
        this.originalTree = originalTree;
        this.i = 0;
        this.parallelograms = new ParaCount(originalTree).getParallelogram();
        this.n = this.parallelograms.size();
        this.k = 1 << this.n;
        this.genNext();
    }

    private static boolean isRealAncestor(Fragment u, Fragment v) {
        while (!v.isRoot()) {
            if ((v = v.getParent()) != u) continue;
            return true;
        }
        return false;
    }

    public static void print(FTree tree) {
        try {
            new FTDotWriter().writeGraph((Writer)new OutputStreamWriter(System.out), tree, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FTree parseFile(File f) {
        try {
            return (FTree)new GenericParser((Parser)new FTDotReader()).parseFile(f);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        ParallelogramIterator.testAligning();
    }

    private static void testAligning() {
        FTree tree = ParallelogramIterator.parseFile(new File("/home/kaidu/Documents/temp/foo/challenge14.dot"));
    }

    private static void testCounting() {
        for (File f : new File("/home/kaidu/Documents/temp/foo").listFiles()) {
            FTree tree = ParallelogramIterator.parseFile(f);
            System.out.println(f);
        }
    }

    private void genNext() {
        while (this.i++ < this.n) {
            this.modifiedtree = this.generateModifiedTree(this.i - 1);
            if (this.modifiedtree == null) continue;
            return;
        }
        this.modifiedtree = null;
    }

    @Override
    public boolean hasNext() {
        return this.modifiedtree != null;
    }

    @Override
    public FTree next() {
        FTree t = this.modifiedtree;
        this.genNext();
        return t;
    }

    private FTree generateModifiedTree(int bitset) {
        FTree changedTree = new FTree(this.originalTree);
        for (int j = 0; j < this.n; ++j) {
            if ((bitset & 1 << j) == 0) continue;
            ParaNodes temp = this.parallelograms.get(j);
            Fragment x = changedTree.getFragmentAt(temp.getX().getVertexId());
            Fragment y = changedTree.getFragmentAt(temp.getY().getVertexId());
            Fragment u = changedTree.getFragmentAt(temp.getU().getVertexId());
            Fragment v = changedTree.getFragmentAt(temp.getV().getVertexId());
            if (changedTree.isConnected(x, y)) {
                return null;
            }
            if (!ParallelogramIterator.isRealAncestor(u, x)) {
                return null;
            }
            if (!ParallelogramIterator.isRealAncestor(v, y)) {
                return null;
            }
            if (ParallelogramIterator.isRealAncestor(u, y)) {
                return null;
            }
            changedTree.swapLoss(v, u);
        }
        return changedTree;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

