/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.counting;

import de.unijena.bioinf.counting.DPPathCounting;
import de.unijena.bioinf.counting.WeightedPathCounting;
import de.unijena.bioinf.treealign.Backtrace;
import de.unijena.bioinf.treealign.TreeAlignmentAlgorithm;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class AlignmentWrapper<T>
implements TreeAlignmentAlgorithm<T> {
    private final Object algorithm;

    public AlignmentWrapper(DPPathCounting<T> algorithm) {
        this.algorithm = algorithm;
    }

    public AlignmentWrapper(WeightedPathCounting<T> algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public float compute() {
        if (this.algorithm instanceof DPPathCounting) {
            long value = ((DPPathCounting)this.algorithm).compute();
            if ((float)value > Float.MAX_VALUE) {
                throw new RuntimeException("Return value exceeds float number space");
            }
            return value;
        }
        if (this.algorithm instanceof WeightedPathCounting) {
            double result = ((WeightedPathCounting)this.algorithm).compute();
            return (float)result;
        }
        throw new IllegalStateException();
    }

    @Override
    public void backtrace(Backtrace<T> tracer) {
        throw new NotImplementedException();
    }
}

