/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.counting;

import de.unijena.bioinf.graphUtils.tree.PostOrderTraversal;
import de.unijena.bioinf.treealign.Tree;
import java.util.ArrayList;
import java.util.List;

public class CompleteTreeDecorator<T>
extends PostOrderTraversal.Call<T, Tree<T>> {
    private final ArrayList<Tree<T>> list;
    public int maxDegree;
    private int index = 0;

    public CompleteTreeDecorator(ArrayList<Tree<T>> list) {
        this.list = list;
    }

    public Tree<T> call(T vertex, List<Tree<T>> values, boolean isRoot) {
        assert (isRoot == (this.getCursor().getDepth() == 0));
        int i = this.index++;
        int num = isRoot ? -1 : this.getCursor().getCurrentSiblingIndex();
        Tree<T> node = new Tree<T>(vertex, i, num, this.getCursor().getDepth(), values);
        this.maxDegree = Math.max(this.maxDegree, this.getCursor().getAdapter().getDegreeOf(vertex));
        this.list.add(node);
        for (Tree<T> tree : values) {
            tree.setParent(node);
        }
        return node;
    }
}

