/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.counting;

import de.unijena.bioinf.graphUtils.tree.PostOrderTraversal;
import de.unijena.bioinf.graphUtils.tree.TreeAdapter;
import de.unijena.bioinf.graphUtils.tree.TreeCursor;
import de.unijena.bioinf.treealign.Tree;
import de.unijena.bioinf.treealign.TreeDecorator;
import de.unijena.bioinf.treealign.scoring.SimpleEqualityScoring;
import java.util.ArrayList;

public class DPPathCounting<T> {
    protected final long[][] D;
    private final ArrayList<Tree<T>> leftVertices;
    private final ArrayList<Tree<T>> rightVertices;
    private final ArrayList<Tree<T>> leftLeafs;
    private final ArrayList<Tree<T>> rightLeafs;
    private final TreeAdapter<T> adapter;
    private final Tree<T> left;
    private final Tree<T> right;
    private final SimpleEqualityScoring<T> scoring;

    public DPPathCounting(SimpleEqualityScoring<T> scoring, T left, T right, TreeAdapter<T> adapter) {
        this.adapter = adapter;
        int leftSize = TreeCursor.getCursor(left, adapter).numberOfVertices();
        int rightSize = TreeCursor.getCursor(right, adapter).numberOfVertices();
        this.leftVertices = new ArrayList(leftSize);
        this.rightVertices = new ArrayList(rightSize);
        this.leftLeafs = new ArrayList(leftSize);
        this.rightLeafs = new ArrayList(rightSize);
        TreeDecorator<T> leftDeco = new TreeDecorator<T>(this.leftVertices, this.leftLeafs);
        TreeDecorator<T> rightDeco = new TreeDecorator<T>(this.rightVertices, this.rightLeafs);
        this.left = (Tree)new PostOrderTraversal(left, adapter).call(leftDeco);
        this.right = (Tree)new PostOrderTraversal(right, adapter).call(rightDeco);
        this.D = new long[this.leftVertices.size()][this.rightVertices.size()];
        this.scoring = scoring;
    }

    protected long recurrence(long counter, int a, int b) {
        return counter + 1L + (a < 0 || b < 0 ? 0L : this.D[a][b]);
    }

    public long compute() {
        long sum = 0L;
        for (int i = 0; i < this.leftVertices.size(); ++i) {
            Tree<T> u = this.leftVertices.get(i);
            for (int j = 0; j < this.rightVertices.size(); ++j) {
                Tree<T> v = this.rightVertices.get(j);
                long counter = 1L;
                for (Tree<T> a : u.children()) {
                    for (Tree<T> b : v.children()) {
                        if (!this.scoring.isMatching(a.label, b.label)) continue;
                        counter = this.recurrence(counter, a.index, b.index);
                    }
                }
                this.D[u.index][v.index] = --counter;
                sum += counter;
            }
        }
        return sum;
    }
}

