/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.counting;

import de.unijena.bioinf.counting.CompleteTreeDecorator;
import de.unijena.bioinf.counting.Weighting;
import de.unijena.bioinf.graphUtils.tree.PostOrderTraversal;
import de.unijena.bioinf.graphUtils.tree.TreeAdapter;
import de.unijena.bioinf.treealign.Tree;
import de.unijena.bioinf.treealign.scoring.SimpleEqualityScoring;
import java.util.ArrayList;

public class WeightedPathCounting<T> {
    protected final long[][] S;
    protected final long[][] E;
    private final ArrayList<Tree<T>> leftVertices;
    private final ArrayList<Tree<T>> rightVertices;
    private final Weighting<T> weights;
    private final TreeAdapter<T> adapter;
    private final Tree<T> left;
    private final Tree<T> right;
    private final SimpleEqualityScoring<T> scoring;

    public WeightedPathCounting(SimpleEqualityScoring<T> scoring, Weighting<T> weighting, T left, T right, TreeAdapter<T> adapter) {
        this.adapter = adapter;
        this.leftVertices = new ArrayList();
        this.rightVertices = new ArrayList();
        CompleteTreeDecorator<T> leftDeco = new CompleteTreeDecorator<T>(this.leftVertices);
        CompleteTreeDecorator<T> rightDeco = new CompleteTreeDecorator<T>(this.rightVertices);
        this.left = (Tree)new PostOrderTraversal(left, adapter).call(leftDeco);
        this.right = (Tree)new PostOrderTraversal(right, adapter).call(rightDeco);
        this.S = new long[this.leftVertices.size()][this.rightVertices.size()];
        this.E = new long[this.leftVertices.size()][this.rightVertices.size()];
        this.weights = weighting;
        this.scoring = scoring;
    }

    public double compute() {
        this.computeE();
        this.computeS();
        double score = 0.0;
        for (int i = 0; i < this.leftVertices.size(); ++i) {
            Tree<T> u = this.leftVertices.get(i);
            for (int j = 0; j < this.rightVertices.size(); ++j) {
                Tree<T> v = this.rightVertices.get(j);
                for (Tree<T> a : u.children()) {
                    for (Tree<T> b : v.children()) {
                        if (this.E[a.index][b.index] <= 0L) continue;
                        score += (double)(this.S[a.index][b.index] + this.E[a.index][b.index] + 1L) * this.weights.weight(a.label, b.label);
                    }
                }
            }
        }
        return score;
    }

    public void computeE() {
        this.E[0][0] = 0L;
        for (int i = this.leftVertices.size() - 2; i >= 0; --i) {
            Tree<T> u = this.leftVertices.get(i);
            for (int j = this.rightVertices.size() - 2; j >= 0; --j) {
                Tree<T> v = this.rightVertices.get(j);
                if (!this.scoring.isMatching(u.label, v.label)) continue;
                this.E[u.index][v.index] = this.E[u.getParentIndex()][v.getParentIndex()] + 1L;
            }
        }
    }

    public void computeS() {
        for (int i = 0; i < this.leftVertices.size(); ++i) {
            Tree<T> u = this.leftVertices.get(i);
            for (int j = 0; j < this.rightVertices.size(); ++j) {
                Tree<T> v = this.rightVertices.get(j);
                long counter = 0L;
                for (Tree<T> a : u.children()) {
                    for (Tree<T> b : v.children()) {
                        if (!this.scoring.isMatching(a.label, b.label)) continue;
                        counter += 1L + (a.index < 0 || b.index < 0 ? 0L : this.S[a.index][b.index]);
                    }
                }
                this.S[u.index][v.index] = counter;
            }
        }
    }
}

