/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign;

import de.unijena.bioinf.graphUtils.tree.PostOrderTraversal;
import de.unijena.bioinf.graphUtils.tree.PreOrderTraversal;
import de.unijena.bioinf.graphUtils.tree.TreeAdapter;
import de.unijena.bioinf.graphUtils.tree.TreeCursor;
import de.unijena.bioinf.graphUtils.tree.TreeType;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class AlignmentTree<T> {
    private final TreeAdapter<T> adapter;
    private Node<T> root;
    private ArrayList<Node<T>> deletionNodes;
    private ArrayList<Node<T>> matchNodes;
    private boolean dirty = false;
    private int joincounter = 0;
    private TObjectDoubleHashMap<T> GAP_COSTS_L;
    private TObjectDoubleHashMap<T> GAP_COSTS_R;

    AlignmentTree(TreeAdapter<T> adapter) {
        this.adapter = adapter;
        this.deletionNodes = new ArrayList();
        this.matchNodes = new ArrayList();
        this.GAP_COSTS_L = new TObjectDoubleHashMap();
        this.GAP_COSTS_R = new TObjectDoubleHashMap();
    }

    public Node<T> getRoot() {
        return this.root;
    }

    public TreeCursor<Node<T>> getCursor() {
        return TreeCursor.getCursor(this.root);
    }

    public void assignAll() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        HashMap leftMap = new HashMap();
        HashMap rightMap = new HashMap();
        for (Node<T> node : this.matchNodes) {
            leftMap.put(node.left, node);
            rightMap.put(node.right, node);
        }
        leftMap.put(this.root.left, this.root);
        rightMap.put(this.root.right, this.root);
        HashMap nodesLeft = this.decorateTree(this.root.left);
        HashMap nodesRight = this.decorateTree(this.root.right);
        block1: for (Node<T> node : this.matchNodes) {
            Node parentRight;
            TNode nL = nodesLeft.get(node.left);
            TNode nR = nodesRight.get(node.right);
            TNode pLeft = nL == null ? null : nL.parent;
            TNode pRight = nR == null ? null : nR.parent;
            Node parentLeft = pLeft == null ? null : (Node)leftMap.get(pLeft.node);
            Node node2 = parentRight = pRight == null ? null : (Node)rightMap.get(pRight.node);
            if (parentLeft == null || parentRight == null) {
                HashSet<Object> pathLeft = new HashSet<Object>();
                HashSet<Object> pathRight = new HashSet<Object>();
                TNode u = nodesLeft.get(node.left);
                TNode v = nodesRight.get(node.right);
                while (leftMap.get(u.parent.node) == null) {
                    pathLeft.add(u.parent.node);
                    u = u.parent;
                }
                while (rightMap.get(v.parent.node) == null) {
                    pathRight.add(v.parent.node);
                    v = v.parent;
                }
                Node<T> currentNode = node;
                for (int i = this.deletionNodes.size() - 1; i >= 0; --i) {
                    Node<T> deleteNode = this.deletionNodes.get(i);
                    if (deleteNode.left != null && pathLeft.contains(deleteNode.left)) {
                        ((Node)deleteNode).children.add(currentNode);
                        assert (((Node)currentNode).parent == null);
                        ((Node)currentNode).parent = (Node)deleteNode;
                        currentNode = deleteNode;
                        pathLeft.remove(deleteNode.left);
                        leftMap.put(currentNode.left, currentNode);
                    } else if (deleteNode.right != null && pathRight.contains(deleteNode.right)) {
                        ((Node)deleteNode).children.add(currentNode);
                        assert (((Node)currentNode).parent == null);
                        ((Node)currentNode).parent = (Node)deleteNode;
                        currentNode = deleteNode;
                        pathRight.remove(deleteNode.right);
                        rightMap.put(currentNode.right, currentNode);
                    }
                    if (pathLeft.size() + pathRight.size() != 0) continue;
                    if (((Node)deleteNode).parent != null) {
                        System.err.println("!");
                    }
                    assert (((Node)deleteNode).parent == null);
                    Node candidateLeft = (Node)leftMap.get(u.parent.node);
                    Node candidateRight = (Node)rightMap.get(v.parent.node);
                    if (candidateLeft == null || candidateLeft.isAncestorOf(candidateRight)) {
                        ((Node)deleteNode).parent = candidateRight;
                        candidateRight.children.add(deleteNode);
                        continue block1;
                    }
                    if (candidateRight == null || candidateRight.isAncestorOf(candidateLeft)) {
                        ((Node)deleteNode).parent = candidateLeft;
                        candidateLeft.children.add(deleteNode);
                        continue block1;
                    }
                    assert (false);
                    continue block1;
                }
                continue;
            }
            if (parentLeft == parentRight) {
                assert (((Node)node).parent == null);
                ((Node)node).parent = parentRight;
                parentRight.children.add(node);
                continue;
            }
            if (parentRight.isAncestorOf(parentLeft)) {
                assert (((Node)node).parent == null);
                ((Node)node).parent = parentLeft;
                parentLeft.children.add(node);
                continue;
            }
            if (parentLeft.isAncestorOf(parentRight)) {
                assert (((Node)node).parent == null);
                ((Node)node).parent = parentRight;
                parentRight.children.add(node);
                assert (parentLeft.isAncestorOf(parentRight));
                continue;
            }
            assert (false);
        }
        PreOrderTraversal.TreeIterator iterator = new PreOrderTraversal.TreeIterator(this.getCursor());
        int k = 0;
        while (iterator.hasNext()) {
            Node u = (Node)iterator.next();
            u.index = ++k;
        }
    }

    private HashMap<T, TNode<T>> decorateTree(T root) {
        final HashMap list = new HashMap();
        new PostOrderTraversal(root, this.adapter).call(new PostOrderTraversal.Call<T, TNode<T>>(){

            public TNode<T> call(T vertex, List<TNode<T>> values, boolean isRoot) {
                TNode node = new TNode(vertex);
                for (TNode v : values) {
                    v.parent = node;
                }
                node.children = new ArrayList(values);
                list.put(vertex, node);
                return node;
            }
        });
        return list;
    }

    private void addParentNode(Node<T> node, Node<T> parent) {
        assert (node != parent);
        if (((Node)node).parent == null) {
            ((Node)node).parent = (Node)parent;
            ((Node)parent).children.add(node);
        } else if (((Node)node).parent != parent) {
            Node oldParent = ((Node)node).parent;
            ((Node)node).parent = (Node)parent;
            oldParent.children.remove(node);
            ((Node)parent).children.add(node);
            ((Node)parent).parent = oldParent;
            oldParent.children.add(parent);
        }
    }

    public void setRoot(T a, T b, double score) {
        this.root = new Node(a, b, score);
        this.dirty = true;
    }

    public void addMatch(T a, T b, double score) {
        this.dirty = true;
        Node w = new Node(a, b, score);
        this.matchNodes.add(w);
    }

    public void addDeletionLeft(T a, double score) {
        this.deletionNodes.add(new Node(a, null, score));
    }

    public void addDeletionRight(T b, double score) {
        this.deletionNodes.add(new Node(null, b, score));
    }

    public void addJoin(Iterator<T> left, Iterator<T> right, int leftSize, int rightSize, double score) {
        this.dirty = true;
        T terminalLeft = left.next();
        T terminalRight = right.next();
        this.matchNodes.add(new Node(terminalLeft, terminalRight, score, leftSize, rightSize));
    }

    public void addInnerJoinLeft(T node) {
        Node vertex = new Node(node, null, 0.0);
        vertex.inJoin = true;
        this.deletionNodes.add(vertex);
    }

    public void addInnerJoinRight(T node) {
        Node vertex = new Node(null, node, 0.0);
        vertex.inJoin = true;
        this.deletionNodes.add(vertex);
    }

    public static final class Node<T>
    implements TreeType<Node<T>> {
        public final T left;
        public final T right;
        private final List<Node<T>> children;
        public final int pathLengthOfLeftJoin;
        public final int pathLengthOfRightJoin;
        public boolean inJoin;
        public final double score;
        private Node<T> parent;
        private int index;

        private Node(T left, T right, double score, int joinLeft, int joinRight) {
            this.left = left;
            this.right = right;
            this.children = new ArrayList<Node<T>>();
            this.score = score;
            this.pathLengthOfLeftJoin = joinLeft;
            this.pathLengthOfRightJoin = joinRight;
            this.inJoin = false;
        }

        public boolean isAncestorOf(Node<T> other) {
            while (other != this && other.parent != null) {
                other = other.parent;
            }
            return other == this;
        }

        public Node<T> getParent() {
            return this.parent;
        }

        public int getIndex() {
            return this.index;
        }

        private Node(T left, T right, double score) {
            this(left, right, score, 0, 0);
        }

        public boolean isJoin() {
            return this.inJoin;
        }

        public boolean isJoinTerminalNode() {
            return this.pathLengthOfLeftJoin + this.pathLengthOfRightJoin > 0;
        }

        public int degree() {
            return this.children.size();
        }

        public List<Node<T>> children() {
            return this.children;
        }

        public String toString() {
            String l = this.left == null ? "-" : this.left.toString();
            String r = this.right == null ? "-" : this.right.toString();
            return "< " + l + "  ||  " + r + ">";
        }
    }

    private static class TNode<T> {
        private T node;
        private TNode<T> parent;
        private ArrayList<TNode<T>> children;

        private TNode(T node) {
            this.node = node;
            this.parent = null;
        }
    }
}

