/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign;

import de.unijena.bioinf.graphUtils.tree.TreeAdapter;
import de.unijena.bioinf.treealign.AlignmentTree;
import de.unijena.bioinf.treealign.Backtrace;
import java.util.ArrayList;
import java.util.Iterator;

public class AlignmentTreeBacktrace<T>
implements Backtrace<T> {
    private final AlignmentTree<T> tree;

    public AlignmentTreeBacktrace(TreeAdapter<T> adapter) {
        this.tree = new AlignmentTree<T>(adapter);
    }

    public AlignmentTree<T> getAlignmentTree() {
        this.tree.assignAll();
        return this.tree;
    }

    @Override
    public void deleteLeft(float score, T node) {
        if (this.tree.getRoot() != null) {
            this.tree.addDeletionLeft(node, score);
        }
    }

    @Override
    public void deleteRight(float score, T node) {
        if (this.tree.getRoot() != null) {
            this.tree.addDeletionRight(node, score);
        }
    }

    @Override
    public void match(float score, T left, T right) {
        if (this.tree.getRoot() == null) {
            this.tree.setRoot(left, right, score);
        } else {
            this.tree.addMatch(left, right, score);
        }
    }

    @Override
    public void innerJoinLeft(T node) {
        this.tree.addInnerJoinLeft(node);
    }

    @Override
    public void innerJoinRight(T node) {
        this.tree.addInnerJoinRight(node);
    }

    @Override
    public void join(float score, Iterator<T> left, Iterator<T> right, int leftNumber, int rightNumber) {
        ArrayList<T> leftS = new ArrayList<T>();
        while (left.hasNext()) {
            leftS.add(left.next());
        }
        ArrayList<T> rightS = new ArrayList<T>();
        while (right.hasNext()) {
            rightS.add(right.next());
        }
        System.out.println("JOIN");
        System.out.println(leftS);
        System.out.println(rightS);
        System.out.println("--> " + score);
        System.out.flush();
        System.err.flush();
        this.tree.addJoin(leftS.iterator(), rightS.iterator(), leftNumber, rightNumber, score);
    }

    @Override
    public void matchVertices(float score, T left, T right) {
        if (this.tree.getRoot() == null) {
            this.tree.setRoot(left, right, score);
        } else {
            this.tree.addMatch(left, right, score);
        }
    }
}

