/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Set<S>
implements Iterable<S> {
    private int bits;
    private List<S> basicSet;

    public static int of(List<?> list) {
        return (1 << list.size()) - 1;
    }

    public static void generateSubsetsUntil(int[][] subsets, int bits) {
        for (int i = 0; i <= bits; ++i) {
            Set.generateSubsets(subsets, i);
        }
    }

    public static void generateSubsets(int[][] superset, int set) {
        int[] subsets = new int[1 << Integer.bitCount(set)];
        superset[set] = subsets;
        int k = 0;
        for (int i = 1; i <= set; ++i) {
            if ((i & set) != i) continue;
            subsets[++k] = i;
        }
    }

    public Set(Set<S> set) {
        this(set.basicSet, set.bits);
    }

    public Set(List<S> basicSet, int bits) {
        if (bits < 0) {
            throw new IllegalArgumentException("Illegal bitvector " + bits);
        }
        this.bits = bits;
        this.basicSet = basicSet;
    }

    public Set(List<S> basicSet) {
        this(basicSet, (1 << basicSet.size()) - 1);
    }

    private void checkCompatibility(Set<S> s) {
        if (s.basicSet != this.basicSet) {
            throw new IllegalArgumentException("Incompatible sets: " + this + " ( " + this.basicSet + " )  and " + s + " ( " + s.basicSet + " )");
        }
    }

    public int index() {
        return this.bits;
    }

    public Set<S> without(S elem) {
        int index = this.asList().indexOf(elem);
        if (index < 0) {
            throw new NoSuchElementException();
        }
        return this.without(1 << index);
    }

    public Set<S> without(int key) {
        return new Set<S>(this.basicSet, this.bits & ~key);
    }

    public Set<S> with(S elem) {
        int index = this.asList().indexOf(elem);
        if (index < 0) {
            throw new NoSuchElementException();
        }
        return this.with(1 << index);
    }

    public Set<S> with(int key) {
        return new Set<S>(this.basicSet, this.bits | key);
    }

    public Set<S> intersection(Set<S> s) {
        this.checkCompatibility(s);
        return new Set<S>(this.basicSet, this.bits & s.bits);
    }

    public Set<S> union(Set<S> s) {
        this.checkCompatibility(s);
        return new Set<S>(this.basicSet, this.bits | s.bits);
    }

    public Set<S> complement() {
        return new Set<S>(this.basicSet, ~this.bits);
    }

    public Set<S> difference(Set<S> s) {
        this.checkCompatibility(s);
        return new Set<S>(this.basicSet, this.bits & ~s.bits);
    }

    public List<S> asList() {
        if (this.bits == 0) {
            return Collections.emptyList();
        }
        ArrayList<S> list = new ArrayList<S>(this.basicSet.size());
        int i = Integer.numberOfTrailingZeros(this.bits);
        for (int b = 1 << i; b <= this.bits; b <<= 1) {
            if ((b & this.bits) != b) continue;
            list.add(this.basicSet.get(i));
            if (++i <= 32) continue;
            break;
        }
        return list;
    }

    public static <S> List<S> subList(List<S> list, int bits) {
        if (bits == 0) {
            return Collections.emptyList();
        }
        ArrayList<S> ary = new ArrayList<S>(Integer.bitCount(bits));
        int i = 0;
        for (int b = 1; b <= bits; b <<= 1) {
            if ((b & bits) != b) continue;
            ary.add(list.get(i));
            if (++i <= 32) continue;
            break;
        }
        return ary;
    }

    @Override
    public Iterator<S> iterator() {
        return new SetIterator(this);
    }

    public boolean equals(Object o) {
        if (o instanceof Set) {
            return this.equals((Set)o);
        }
        return false;
    }

    public boolean equals(Set s) {
        return this.basicSet == s.basicSet && this.bits == s.bits;
    }

    public int hashCode() {
        return this.bits;
    }

    public String toString() {
        return this.asList().toString();
    }

    public static class SetIterator<S>
    implements Iterator<S> {
        private final int bits;
        private final List<S> basicSet;
        private int index;
        private int value;

        public SetIterator(Set<S> set) {
            this.bits = ((Set)set).bits;
            this.basicSet = ((Set)set).basicSet;
            this.index = Integer.numberOfTrailingZeros(this.bits);
            this.value = 1 << this.index;
        }

        @Override
        public boolean hasNext() {
            return (this.value & this.bits) == this.value;
        }

        @Override
        public S next() {
            S elem = this.basicSet.get(this.index);
            do {
                ++this.index;
                this.value <<= 1;
            } while (this.value <= this.bits && (this.value & this.bits) != this.value);
            return elem;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

