/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign;

import de.unijena.bioinf.treealign.Backtrace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class StackedBacktrace<T>
implements Backtrace<T> {
    private final List<Backtrace<T>> stack = new ArrayList<Backtrace<T>>();

    public StackedBacktrace() {
    }

    public StackedBacktrace(Backtrace<T> ... tracers) {
        this();
        this.pushAll(tracers);
    }

    public <S extends Backtrace<T>> S get(Class<S> klass) {
        for (Backtrace<T> trace : this.stack) {
            if (!klass.isInstance(trace)) continue;
            return (S)trace;
        }
        return null;
    }

    public void pushAll(Backtrace<T> ... tracers) {
        this.stack.addAll(Arrays.asList(tracers));
    }

    public void push(Backtrace<T> trace) {
        this.stack.add(trace);
    }

    public void pop() {
        this.stack.remove(this.stack.size() - 1);
    }

    @Override
    public void join(float score, Iterator<T> left, Iterator<T> right, int leftNumber, int rightNumber) {
        if (this.stack.size() == 1) {
            this.stack.get(0).join(score, left, right, leftNumber, rightNumber);
        } else {
            LinkedList<T> leftList = new LinkedList<T>();
            while (left.hasNext()) {
                leftList.add(left.next());
            }
            LinkedList<T> rightList = new LinkedList<T>();
            while (right.hasNext()) {
                rightList.add(right.next());
            }
            for (Backtrace backtrace : this.stack) {
                backtrace.join(score, leftList.iterator(), rightList.iterator(), leftNumber, rightNumber);
            }
        }
    }

    @Override
    public void deleteLeft(float score, T node) {
        for (Backtrace<T> tracer : this.stack) {
            tracer.deleteLeft(score, node);
        }
    }

    @Override
    public void deleteRight(float score, T node) {
        for (Backtrace<T> tracer : this.stack) {
            tracer.deleteRight(score, node);
        }
    }

    @Override
    public void match(float score, T left, T right) {
        for (Backtrace<T> tracer : this.stack) {
            tracer.match(score, left, right);
        }
    }

    @Override
    public void innerJoinLeft(T node) {
        for (Backtrace<T> tracer : this.stack) {
            tracer.innerJoinLeft(node);
        }
    }

    @Override
    public void innerJoinRight(T node) {
        for (Backtrace<T> tracer : this.stack) {
            tracer.innerJoinRight(node);
        }
    }

    @Override
    public void matchVertices(float score, T left, T right) {
        for (Backtrace<T> tracer : this.stack) {
            tracer.matchVertices(score, left, right);
        }
    }
}

