/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign;

import de.unijena.bioinf.graphUtils.tree.TreeType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Tree<S>
implements TreeType<Tree<S>> {
    public final S label;
    public final int index;
    public final int key;
    private final ArrayList<Tree<S>> children;
    private final int depth;
    private Tree<S> parent;

    public Tree(S label, int index, int childNum, int depth, List<Tree<S>> children) {
        this.index = index;
        this.key = childNum < 0 ? 0 : 1 << childNum;
        this.label = label;
        this.children = new ArrayList<Tree<S>>(children);
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public Tree<S> getParent() {
        return this.parent;
    }

    public void setParent(Tree<S> parent) {
        this.parent = parent;
    }

    public int getParentIndex() {
        return this.parent.index;
    }

    public int degree() {
        return this.children.size();
    }

    public List<Tree<S>> children() {
        return this.children;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Iterator<S> eachAncestors(int num) {
        return new AncestorIterator(this, num);
    }

    public String toString() {
        return this.label.toString();
    }

    private static class AncestorIterator<S>
    implements Iterator<S> {
        private Tree<S> node;
        private int depth;
        private boolean init;

        private AncestorIterator(Tree<S> node, int depth) {
            this.node = node;
            this.depth = depth;
            this.init = false;
            if (((Tree)node).depth < depth) {
                throw new IndexOutOfBoundsException("Node has not enough ancestors to iterate");
            }
        }

        @Override
        public boolean hasNext() {
            return this.depth >= 0;
        }

        @Override
        public S next() {
            Tree nextNode;
            if (this.depth-- < 0) {
                throw new NoSuchElementException();
            }
            if (!this.init) {
                nextNode = this.node;
                this.init = true;
            } else {
                this.node = nextNode = ((Tree)this.node).parent;
            }
            return nextNode.label;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

