/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign;

import de.unijena.bioinf.graphUtils.tree.TreeAdapter;
import de.unijena.bioinf.treealign.Backtrace;
import de.unijena.bioinf.treealign.dp.DPTreeAlign;
import de.unijena.bioinf.treealign.multijoin.DPMultiJoin;
import de.unijena.bioinf.treealign.scoring.Scoring;
import de.unijena.bioinf.treealign.sparse.DPSparseTreeAlign;

public interface TreeAlignmentAlgorithm<T> {
    public float compute();

    public void backtrace(Backtrace<T> var1);

    public static class NonSparseFactory<T>
    extends Factory<T> {
        public NonSparseFactory(TreeAdapter<T> adapter, Scoring<T> scoring, boolean useJoins) {
            super(adapter, scoring, useJoins ? 1 : 0, false);
        }

        @Override
        public TreeAlignmentAlgorithm<T> create(T left, T right) {
            return new DPTreeAlign<T>(this.scoring, this.numberOfJoins > 0, left, right, this.adapter);
        }
    }

    public static class Factory<T> {
        protected final int numberOfJoins;
        protected final boolean many2manyJoins;
        protected final TreeAdapter<T> adapter;
        protected final Scoring<T> scoring;

        public Factory(TreeAdapter<T> adapter, Scoring<T> scoring, int numberOfJoins, boolean many2manyJoins) {
            this.numberOfJoins = numberOfJoins;
            this.many2manyJoins = many2manyJoins;
            this.adapter = adapter;
            this.scoring = scoring;
        }

        public int getNumberOfJoins() {
            return this.numberOfJoins;
        }

        public boolean isMany2manyJoins() {
            return this.many2manyJoins;
        }

        public TreeAdapter<T> getAdapter() {
            return this.adapter;
        }

        public Scoring<T> getScoring() {
            return this.scoring;
        }

        public TreeAlignmentAlgorithm<T> create(T left, T right) {
            if (this.numberOfJoins == 0) {
                return new DPSparseTreeAlign<T>(this.scoring, false, left, right, this.adapter);
            }
            if (this.numberOfJoins == 1) {
                if (this.many2manyJoins) {
                    return new DPMultiJoin<T>(this.scoring, 1, left, right, this.adapter);
                }
                return new DPSparseTreeAlign<T>(this.scoring, true, left, right, this.adapter);
            }
            return new DPMultiJoin<T>(this.scoring, this.numberOfJoins, left, right, this.adapter);
        }
    }
}

