/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign;

import de.unijena.bioinf.graphUtils.tree.PostOrderTraversal;
import de.unijena.bioinf.treealign.Tree;
import java.util.ArrayList;
import java.util.List;

public final class TreeDecorator<T>
extends PostOrderTraversal.Call<T, Tree<T>> {
    private final ArrayList<Tree<T>> list;
    private final ArrayList<Tree<T>> leafs;
    public int maxDegree;
    private int index = 0;

    public TreeDecorator(ArrayList<Tree<T>> list, ArrayList<Tree<T>> leafs) {
        this.leafs = leafs;
        this.list = list;
    }

    public Tree<T> call(T vertex, List<Tree<T>> values, boolean isRoot) {
        int n;
        assert (isRoot == (this.getCursor().getDepth() == 0));
        if (values.isEmpty()) {
            n = -1;
        } else {
            int n2 = this.index;
            n = n2;
            this.index = n2 + 1;
        }
        int i = n;
        int num = isRoot ? -1 : this.getCursor().getCurrentSiblingIndex();
        Tree<T> node = new Tree<T>(vertex, i, num, this.getCursor().getDepth(), values);
        this.maxDegree = Math.max(this.maxDegree, this.getCursor().getAdapter().getDegreeOf(vertex));
        if (node.degree() > 0) {
            this.list.add(node);
        } else {
            this.leafs.add(node);
        }
        for (Tree<T> tree : values) {
            tree.setParent(node);
        }
        return node;
    }
}

