/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign.dp;

import de.unijena.bioinf.graphUtils.tree.PostOrderTraversal;
import de.unijena.bioinf.graphUtils.tree.TreeAdapter;
import de.unijena.bioinf.graphUtils.tree.TreeCursor;
import de.unijena.bioinf.treealign.Backtrace;
import de.unijena.bioinf.treealign.Set;
import de.unijena.bioinf.treealign.TraceItem;
import de.unijena.bioinf.treealign.Tree;
import de.unijena.bioinf.treealign.TreeAlignmentAlgorithm;
import de.unijena.bioinf.treealign.TreeDecorator;
import de.unijena.bioinf.treealign.dp.Table;
import de.unijena.bioinf.treealign.dp.TreeMap;
import de.unijena.bioinf.treealign.scoring.Scoring;
import de.unijena.bioinf.util.Iterators;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DPTreeAlign<T>
implements TreeAlignmentAlgorithm<T> {
    private final Scoring<T> scoring;
    private final Tree<T> left;
    private final Tree<T> right;
    private final TreeMap<T> tables;
    private final ArrayList<Tree<T>> leftVertices;
    private final ArrayList<Tree<T>> rightVertices;
    private final ArrayList<Tree<T>> leftLeafs;
    private final ArrayList<Tree<T>> rightLeafs;
    private final int maxDegree;
    private final TreeAdapter<T> adapter;
    private final ArrayDeque<TraceItem<T>> queue;
    private final int[][] supersets;
    private final boolean useJoins;
    private Tree<T> optLeft;
    private Tree<T> optRight;
    private float optScore;
    private Backtrace<T> tracer;
    private boolean scoreRoot;

    public DPTreeAlign(Scoring<T> scoring, boolean useJoins, T left, T right, TreeAdapter<T> adapter) {
        this.adapter = adapter;
        this.scoring = scoring;
        int leftSize = TreeCursor.getCursor(left, adapter).numberOfVertices();
        int rightSize = TreeCursor.getCursor(right, adapter).numberOfVertices();
        this.leftVertices = new ArrayList(leftSize);
        this.rightVertices = new ArrayList(rightSize);
        this.leftLeafs = new ArrayList(leftSize);
        this.rightLeafs = new ArrayList(rightSize);
        TreeDecorator<T> leftDeco = new TreeDecorator<T>(this.leftVertices, this.leftLeafs);
        this.left = (Tree)new PostOrderTraversal(left, adapter).call(leftDeco);
        TreeDecorator<T> rightDeco = new TreeDecorator<T>(this.rightVertices, this.rightLeafs);
        this.right = (Tree)new PostOrderTraversal(right, adapter).call(rightDeco);
        this.tables = new TreeMap(this.leftVertices.size(), this.rightVertices.size());
        this.queue = new ArrayDeque();
        this.maxDegree = Math.max(leftDeco.maxDegree, rightDeco.maxDegree);
        this.optScore = -1.0f;
        this.supersets = new int[1 << this.maxDegree][];
        Set.generateSubsetsUntil(this.supersets, (1 << this.maxDegree) - 1);
        this.scoreRoot = false;
        this.useJoins = useJoins;
    }

    protected float scoreSubtreeRoots() {
        if (this.scoreRoot) {
            return this.optScore;
        }
        assert (this.left.isRoot());
        assert (this.right.isRoot());
        Iterator iter = PostOrderTraversal.create(this.left).iterator();
        float opt = 0.0f;
        while (iter.hasNext()) {
            Tree a = (Tree)iter.next();
            for (Tree b : PostOrderTraversal.create(this.right)) {
                Table<T> table = this.tables.get(a.index, b.index);
                float newScore = table.getScore() + this.scoring.scoreVertices(a.label, b.label);
                if (!(newScore > opt)) continue;
                this.optLeft = a;
                this.optRight = b;
                opt = newScore;
            }
        }
        this.optScore = opt;
        this.scoreRoot = true;
        return this.optScore;
    }

    @Override
    public float compute() {
        this.optScore = 0.0f;
        this.optLeft = this.left;
        this.optRight = this.right;
        for (int i = 0; i < this.leftVertices.size(); ++i) {
            Tree<T> u = this.leftVertices.get(i);
            int fullSetLeft = 1 << u.degree();
            for (int j = 0; j < this.rightVertices.size(); ++j) {
                Tree<T> v = this.rightVertices.get(j);
                int fullSetRight = 1 << v.degree();
                this.tables.set(i, j, new Table<T>(u.children(), v.children(), this.useJoins));
                Table<T> D = this.tables.get(i, j);
                for (int x = 0; x < u.degree(); ++x) {
                    Tree<T> a = u.children().get(x);
                    for (int y = 0; y < v.degree(); ++y) {
                        Tree<T> b = v.children().get(y);
                        float subtreeScore = this.tables.get(a.index, b.index).getScore();
                        D.set(a.key, b.key, this.scoring.match(a.label, b.label) + subtreeScore);
                        if (this.useJoins && !u.isRoot()) {
                            D.setPrejoinLeft(a.key, b.key, this.scoring.joinLeft(u.label, a.label, b.label) + subtreeScore);
                        }
                        if (!this.useJoins || v.isRoot()) continue;
                        D.setPrejoinRight(a.key, b.key, this.scoring.joinRight(v.label, b.label, a.label) + subtreeScore);
                    }
                }
                for (int A = 1; A < fullSetLeft; ++A) {
                    List<Tree<T>> As = Set.subList(u.children(), A);
                    for (int B = 1; B < fullSetRight; ++B) {
                        List<Tree<T>> Bs = Set.subList(v.children(), B);
                        if (this.useJoins) {
                            if (!u.isRoot()) {
                                D.setPrejoinLeft(A, B, this.preJoinLeft(u, v, D, A, B, As, Bs));
                            }
                            if (!v.isRoot()) {
                                D.setPrejoinRight(A, B, this.preJoinRight(u, v, D, A, B, As, Bs));
                            }
                        }
                        float score = 0.0f;
                        score = Math.max(score, this.match(u, v, D, A, B, As, Bs));
                        score = Math.max(score, this.deleteLeft(u, v, D, A, B, As, Bs));
                        score = Math.max(score, this.deleteRight(u, v, D, A, B, As, Bs));
                        if (this.useJoins) {
                            score = Math.max(score, this.joinLeft(u, v, D, A, B, As, Bs));
                            score = Math.max(score, this.joinRight(u, v, D, A, B, As, Bs));
                        }
                        D.set(A, B, score);
                    }
                }
                float vertexScore = this.vertexScore(D, u, v);
                if (!(vertexScore > this.optScore)) continue;
                this.optLeft = u;
                this.optRight = v;
                this.optScore = vertexScore;
            }
        }
        if (this.scoring.isScoringVertices()) {
            return this.scoreSubtreeRoots();
        }
        return this.optScore;
    }

    private float vertexScore(Table<T> table, Tree<T> u, Tree<T> v) {
        float matchScore = table.getScore();
        return matchScore;
    }

    @Override
    public void backtrace(Backtrace<T> tracer) {
        if (this.optScore <= 0.0f) {
            return;
        }
        this.tracer = tracer;
        this.queue.clear();
        if (this.scoreRoot) {
            tracer.matchVertices(this.optScore - this.tables.get(this.optLeft.index, this.optRight.index).getScore(), this.optLeft.label, this.optRight.label);
        }
        this.queue.offer(new TraceItem<T>(this.optLeft, this.optRight));
        while (!this.queue.isEmpty()) {
            boolean found;
            TraceItem<T> item = this.queue.poll();
            List As = Set.subList(item.u.children(), item.A);
            List Bs = Set.subList(item.v.children(), item.B);
            Table<T> D = this.tables.get(item.u.index, item.v.index);
            float opt = D.get(item.A, item.B);
            if (opt == 0.0f || (found = this.traceMatch(item.u, item.v, opt, D, item.A, item.B, As, Bs) || this.traceDeleteLeft(item.u, item.v, opt, D, item.A, item.B, As, Bs) || this.traceDeleteRight(item.u, item.v, opt, D, item.A, item.B, As, Bs) || this.useJoins && this.tracejoinLeft(item.u, item.v, opt, D, item.A, item.B, As, Bs) || this.useJoins && this.tracejoinRight(item.u, item.v, opt, D, item.A, item.B, As, Bs))) continue;
            throw new RuntimeException("No Backtrace is found!");
        }
    }

    private boolean traceMatch(Tree<T> u, Tree<T> v, float opt, Table<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        for (Tree<T> a : As) {
            int A_ = A & ~a.key;
            for (Tree<T> b : Bs) {
                int B_ = B & ~b.key;
                float score = this.tables.get(a.index, b.index).getScore() + D.get(A_, B_) + this.scoring.match(a.label, b.label);
                if (!(score >= opt)) continue;
                assert (score == opt);
                assert (score == this.match(u, v, D, A, B, As, Bs));
                this.tracer.match(this.scoring.match(a.label, b.label), a.label, b.label);
                if (a.degree() > 0 && b.degree() > 0) {
                    this.queue.offer(new TraceItem<T>(a, b));
                } else assert (this.tables.get(a.index, b.index).getScore() == 0.0f);
                this.queue.offer(new TraceItem<T>(u, v, A_, B_));
                return true;
            }
        }
        return false;
    }

    private boolean traceDeleteLeft(Tree<T> u, Tree<T> v, float opt, Table<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        int[] B_subsets = this.getSubsets(B);
        for (int i = 0; i < B_subsets.length; ++i) {
            int B_ = B_subsets[i];
            int BB = B & ~B_;
            for (Tree<T> a : As) {
                float score;
                int A_ = A & ~a.key;
                if (a.degree() == 0 || !((score = this.tables.get(a.index, v.index).get(Set.of(a.children()), B_) + D.get(A_, BB) + this.scoring.deleteLeft(a.label)) >= opt)) continue;
                assert (score == opt);
                assert (score == this.deleteLeft(u, v, D, A, B, As, Bs));
                this.tracer.deleteLeft(this.scoring.deleteLeft(a.label), a.label);
                if (a.degree() > 0) {
                    this.queue.offer(new TraceItem<T>(a, v, Set.of(a.children()), B_));
                }
                this.queue.offer(new TraceItem<T>(u, v, A_, BB));
                return true;
            }
        }
        return false;
    }

    private boolean traceDeleteRight(Tree<T> u, Tree<T> v, float opt, Table<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        int[] A_subsets = this.getSubsets(A);
        for (int i = 0; i < A_subsets.length; ++i) {
            int A_ = A_subsets[i];
            int AA = A & ~A_;
            for (Tree<T> b : Bs) {
                float score;
                int B_ = B & ~b.key;
                if (b.degree() == 0 || !((score = this.tables.get(u.index, b.index).get(A_, Set.of(b.children())) + D.get(AA, B_) + this.scoring.deleteRight(b.label)) >= opt)) continue;
                assert (score == opt);
                assert (score == this.deleteRight(u, v, D, A, B, As, Bs));
                this.tracer.deleteRight(this.scoring.deleteRight(b.label), b.label);
                if (b.degree() > 0) {
                    this.queue.offer(new TraceItem<T>(u, b, A_, Set.of(b.children())));
                }
                this.queue.offer(new TraceItem<T>(u, v, AA, B_));
                return true;
            }
        }
        return false;
    }

    private boolean tracejoinLeft(Tree<T> u, Tree<T> v, float opt, Table<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        int[] B_subsets = this.getSubsets(B);
        block0: for (Tree<T> a : As) {
            if (a.degree() == 0) continue;
            Table<T> T = this.tables.get(a.index, v.index);
            int A_ = A & ~a.key;
            for (int k = 1; k < B_subsets.length; ++k) {
                float searchedScore;
                Tree<T> y;
                Tree x;
                int B_ = B_subsets[k];
                int BB = B & ~B_;
                float score = T.getPrejoinLeft(Set.of(a.children()), B_) + D.get(A_, BB);
                if (!(score >= opt)) continue;
                assert (score == opt);
                assert (score == this.joinLeft(u, v, D, A, B, As, Bs));
                int leftSet = Set.of(a.children());
                ArrayList<Tree<T>> leftList = new ArrayList<Tree<T>>(a.children());
                List<Tree<T>> rightList = Set.subList(v.children(), B_);
                block2: for (int rightSet = B_; leftSet > 0 && rightSet > 0 && !((searchedScore = T.getPrejoinLeft(leftSet, rightSet)) <= 0.0f); leftSet &= ~x.key, rightSet &= ~y.key) {
                    for (int i = 0; i < leftList.size(); ++i) {
                        x = (Tree)leftList.get(i);
                        int newLeftSet = leftSet & ~x.key;
                        for (int j = 0; j < rightList.size(); ++j) {
                            y = rightList.get(j);
                            int newRightSet = rightSet & ~y.key;
                            float s = T.getPrejoinLeft(newLeftSet, newRightSet) + this.scoring.joinLeft(a.label, x.label, y.label) + this.tables.get(x.index, y.index).getScore();
                            if (!(s >= searchedScore)) continue;
                            assert (s == searchedScore);
                            this.tracer.innerJoinLeft(a.label);
                            this.tracer.join(this.scoring.joinLeft(a.label, x.label, y.label), x.eachAncestors(1), Iterators.singleton(y.label), 2, 1);
                            if (x.degree() > 0 && y.degree() > 0) {
                                this.queue.offer(new TraceItem<T>(x, y));
                            } else assert (this.tables.get(x.index, y.index).getScore() == 0.0f);
                            leftList.remove(i);
                            rightList.remove(j);
                            continue block2;
                        }
                    }
                    assert (false);
                    continue block0;
                }
                this.queue.offer(new TraceItem<T>(u, v, A_, BB));
                return true;
            }
        }
        return false;
    }

    private boolean tracejoinRight(Tree<T> u, Tree<T> v, float opt, Table<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        int[] A_subsets = this.getSubsets(A);
        block0: for (Tree<T> b : Bs) {
            if (b.degree() == 0) continue;
            Table<T> T = this.tables.get(u.index, b.index);
            int B_ = B & ~b.key;
            for (int k = 1; k < A_subsets.length; ++k) {
                float searchedScore;
                Tree y;
                Tree<T> x;
                int A_ = A_subsets[k];
                int AA = A & ~A_;
                float score = T.getPrejoinRight(A_, Set.of(b.children())) + D.get(AA, B_);
                if (!(score >= opt)) continue;
                assert (score == opt);
                assert (score == this.joinRight(u, v, D, A, B, As, Bs));
                int rightSet = Set.of(b.children());
                ArrayList<Tree<T>> rightList = new ArrayList<Tree<T>>(b.children());
                List<Tree<T>> leftList = Set.subList(u.children(), A_);
                block2: for (int leftSet = A_; leftSet > 0 && rightSet > 0 && !((searchedScore = T.getPrejoinRight(leftSet, rightSet)) <= 0.0f); leftSet &= ~x.key, rightSet &= ~y.key) {
                    for (int i = 0; i < leftList.size(); ++i) {
                        x = leftList.get(i);
                        int newLeftSet = leftSet & ~x.key;
                        for (int j = 0; j < rightList.size(); ++j) {
                            y = (Tree)rightList.get(j);
                            int newRightSet = rightSet & ~y.key;
                            this.tracer.innerJoinRight(b.label);
                            float joinScore = this.scoring.joinRight(b.label, y.label, x.label);
                            float s = T.getPrejoinRight(newLeftSet, newRightSet) + joinScore + this.tables.get(x.index, y.index).getScore();
                            if (!(s >= searchedScore)) continue;
                            assert (s == searchedScore);
                            this.tracer.join(joinScore, Iterators.singleton(x.label), y.eachAncestors(1), 1, 2);
                            if (x.degree() > 0 && y.degree() > 0) {
                                this.queue.offer(new TraceItem<T>(x, y));
                            }
                            leftList.remove(i);
                            rightList.remove(j);
                            continue block2;
                        }
                    }
                    assert (false);
                    continue block0;
                }
                this.queue.offer(new TraceItem<T>(u, v, AA, B_));
                return true;
            }
        }
        return false;
    }

    private float match(Tree<T> u, Tree<T> v, Table<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        float score = 0.0f;
        for (Tree<T> a : As) {
            int A_ = A & ~a.key;
            for (Tree<T> b : Bs) {
                score = Math.max(score, D.get(A_, B & ~b.key) + D.get(a.key, b.key));
            }
        }
        return score;
    }

    private float deleteLeft(Tree<T> u, Tree<T> v, Table<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        float score = 0.0f;
        int[] B_subsets = this.getSubsets(B);
        for (int i = 0; i < B_subsets.length; ++i) {
            int B_ = B_subsets[i];
            int BB = B & ~B_;
            for (Tree<T> a : As) {
                if (a.degree() == 0) continue;
                score = Math.max(score, this.tables.get(a.index, v.index).get(Set.of(a.children()), B_) + D.get(A & ~a.key, BB) + this.scoring.deleteLeft(a.label));
            }
        }
        return score;
    }

    private float deleteRight(Tree<T> u, Tree<T> v, Table<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        float score = 0.0f;
        int[] A_subsets = this.getSubsets(A);
        for (int i = 0; i < A_subsets.length; ++i) {
            int A_ = A_subsets[i];
            int AA = A & ~A_;
            for (Tree<T> b : Bs) {
                if (b.degree() == 0) continue;
                score = Math.max(score, this.tables.get(u.index, b.index).get(A_, Set.of(b.children())) + D.get(AA, B & ~b.key) + this.scoring.deleteRight(b.label));
            }
        }
        return score;
    }

    private float preJoinLeft(Tree<T> u, Tree<T> v, Table<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        float score = 0.0f;
        for (Tree<T> a : As) {
            int A_ = A & ~a.key;
            for (Tree<T> b : Bs) {
                assert (!u.isRoot()) : "u is not a root node";
                score = Math.max(score, D.getPrejoinLeft(A_, B & ~b.key) + D.getPrejoinLeft(a.key, b.key));
            }
        }
        return score;
    }

    private float preJoinRight(Tree<T> u, Tree<T> v, Table<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        float score = 0.0f;
        for (Tree<T> a : As) {
            int A_ = A & ~a.key;
            for (Tree<T> b : Bs) {
                assert (!v.isRoot()) : "v is not a root node";
                score = Math.max(score, D.getPrejoinRight(A_, B & ~b.key) + D.getPrejoinRight(a.key, b.key));
            }
        }
        return score;
    }

    private float joinLeft(Tree<T> u, Tree<T> v, Table<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        float score = 0.0f;
        int[] B_subsets = this.getSubsets(B);
        for (Tree<T> a : As) {
            if (a.degree() == 0) continue;
            Table<T> T = this.tables.get(a.index, v.index);
            int setofAChilds = Set.of(a.children());
            int withouta = A & ~a.key;
            for (int i = 1; i < B_subsets.length; ++i) {
                int B_ = B_subsets[i];
                score = Math.max(score, T.getPrejoinLeft(setofAChilds, B_) + D.get(withouta, B & ~B_));
            }
        }
        return score;
    }

    private float joinRight(Tree<T> u, Tree<T> v, Table<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        float score = 0.0f;
        int[] A_subsets = this.getSubsets(A);
        for (Tree<T> b : Bs) {
            if (b.degree() == 0) continue;
            int withoutb = B & ~b.key;
            int setofBChilds = Set.of(b.children());
            Table<T> T = this.tables.get(u.index, b.index);
            for (int i = 1; i < A_subsets.length; ++i) {
                int A_ = A_subsets[i];
                score = Math.max(score, T.getPrejoinRight(A_, setofBChilds) + D.get(A & ~A_, withoutb));
            }
        }
        return score;
    }

    private int[] getSubsets(int A) {
        return this.supersets[A];
    }
}

