/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign.dp;

import de.unijena.bioinf.treealign.Set;
import de.unijena.bioinf.treealign.Tree;
import java.util.List;

class Table<T> {
    private final float[] data;
    private final float[] joinDataLeft;
    private final float[] joinDataRight;
    private final int colSize;
    private final List<Tree<T>> basicSetA;
    private final List<Tree<T>> basicSetB;

    Table(List<Tree<T>> basicSetA, List<Tree<T>> basicSetB, boolean useJoins) {
        this.basicSetA = basicSetA;
        this.basicSetB = basicSetB;
        this.colSize = 1 << basicSetA.size();
        this.data = new float[(1 << basicSetA.size()) * (1 << basicSetB.size())];
        if (useJoins) {
            this.joinDataLeft = new float[this.data.length];
            this.joinDataRight = new float[this.data.length];
        } else {
            this.joinDataLeft = null;
            this.joinDataRight = null;
        }
    }

    int cols() {
        return this.colSize;
    }

    int rows() {
        return 1 << this.basicSetB.size();
    }

    void setPrejoinLeft(Set<Tree<T>> a, Set<Tree<T>> b, float value) {
        this.setPrejoinLeft(a.index(), b.index(), value);
    }

    void setPrejoinLeft(int a, int b, float value) {
        this.joinDataLeft[a + b * this.colSize] = value;
    }

    float getPrejoinLeft(Set<Tree<T>> a, Set<Tree<T>> b) {
        return this.getPrejoinLeft(a.index(), b.index());
    }

    float getPrejoinLeft(int a, int b) {
        return this.joinDataLeft[a + b * this.colSize];
    }

    void setPrejoinRight(Set<Tree<T>> a, Set<Tree<T>> b, float value) {
        this.setPrejoinRight(a.index(), b.index(), value);
    }

    void setPrejoinRight(int a, int b, float value) {
        this.joinDataRight[a + b * this.colSize] = value;
    }

    float getPrejoinRight(Set<Tree<T>> a, Set<Tree<T>> b) {
        return this.getPrejoinRight(a.index(), b.index());
    }

    float getPrejoinRight(int a, int b) {
        return this.joinDataRight[a + b * this.colSize];
    }

    float getScore() {
        return this.data[this.data.length - 1];
    }

    float get(Set<Tree<T>> a, Set<Tree<T>> b) {
        return this.get(a.index(), b.index());
    }

    float get(int a, int b) {
        try {
            return this.data[a + b * this.colSize];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw new IndexOutOfBoundsException(a + "/" + b + "  " + this.basicSetA + ", " + this.basicSetB);
        }
    }

    void set(Set<Tree<T>> a, Set<Tree<T>> b, float score) {
        this.set(a.index(), b.index(), score);
    }

    void set(int a, int b, float score) {
        this.data[a + b * this.colSize] = score;
    }
}

