/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign.dp;

import de.unijena.bioinf.treealign.dp.Table;
import java.util.Collections;

class TreeMap<T> {
    private final Table<T>[] tables;
    private final Table<T> emptyTable;
    private final int colSize;
    private float score;

    TreeMap(int leftSize, int rightSize) {
        this.tables = new Table[leftSize * rightSize];
        this.colSize = leftSize;
        this.score = Float.POSITIVE_INFINITY;
        this.emptyTable = new Table(Collections.emptyList(), Collections.emptyList(), true);
    }

    float getScore() {
        return this.score;
    }

    void setScore(float score) {
        this.score = score;
    }

    Table<T> get(int left, int right) {
        if (left < 0 || right < 0) {
            return this.emptyTable;
        }
        return this.tables[left + right * this.colSize];
    }

    void set(int left, int right, Table<T> table) {
        this.tables[left + right * this.colSize] = table;
    }
}

