/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign.map;

import de.unijena.bioinf.treealign.map.IntFloatIterator;
import de.unijena.bioinf.treealign.map.IntFloatMap;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class IntFloatArrayMap
implements IntFloatMap {
    private static final float DEFAULT_VALUE = 0.0f;
    private final int maxSize;
    private int size;
    private float[] values;
    private int[] keys;

    public IntFloatArrayMap(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize have to be greater than 0, but " + maxSize + " is given");
        }
        this.maxSize = maxSize;
        this.size = 0;
        this.values = null;
        this.keys = null;
    }

    private void allocate() {
        if (this.values == null) {
            this.values = new float[this.maxSize];
            this.keys = new int[Math.min(this.maxSize, 32)];
            Arrays.fill(this.values, Float.NaN);
        }
    }

    private void addKey(int key) {
        if (this.size() >= this.keys.length) {
            this.keys = Arrays.copyOf(this.keys, Math.min(this.maxSize, this.keys.length * 2));
        }
        this.keys[this.size++] = key;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return this.values == null ? 0 : this.values.length;
    }

    @Override
    public int collisions() {
        return 0;
    }

    @Override
    public int collisionKeys() {
        return 0;
    }

    @Override
    public int reallocations() {
        return 0;
    }

    @Override
    public boolean isHash() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public float get(int A) {
        if (this.values == null) {
            return 0.0f;
        }
        float value = this.values[A];
        return Float.isNaN(value) ? 0.0f : value;
    }

    @Override
    public void put(int A, float value) {
        if (A == 0) {
            throw new IllegalArgumentException("0 can't be a key of this map");
        }
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException("NaN can't be a value of this map");
        }
        this.allocate();
        if (!Float.isNaN(this.values[A])) {
            this.addKey(A);
        }
        this.values[A] = value;
    }

    @Override
    public void putIfGreater(int A, float value) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException("NaN can't be a value of this map");
        }
        if (A == 0) {
            throw new IllegalArgumentException("0 can't be a key of this map");
        }
        if (value < 0.0f) {
            return;
        }
        this.allocate();
        float val = this.values[A];
        if (Float.isNaN(val)) {
            this.addKey(A);
            this.values[A] = value;
        } else if (val < value) {
            this.values[A] = value;
        }
    }

    @Override
    public IntFloatIterator entries() {
        return this.values == null ? IntFloatIterator.Empty : new KeyValueIterator();
    }

    private class KeyValueIterator
    implements IntFloatIterator {
        private int index = -1;

        private KeyValueIterator() {
        }

        @Override
        public float getValue() {
            if (this.index < 0 || this.index >= IntFloatArrayMap.this.keys.length) {
                throw new NoSuchElementException();
            }
            return IntFloatArrayMap.this.values[IntFloatArrayMap.this.keys[this.index]];
        }

        @Override
        public void next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
        }

        @Override
        public int getKey() {
            if (this.index < 0 || this.index >= IntFloatArrayMap.this.keys.length) {
                throw new NoSuchElementException();
            }
            return IntFloatArrayMap.this.keys[this.index];
        }

        @Override
        public boolean hasNext() {
            return this.index < IntFloatArrayMap.this.size - 1;
        }
    }
}

