/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign.map;

import de.unijena.bioinf.treealign.map.IntFloatIterator;
import de.unijena.bioinf.treealign.map.IntFloatMap;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class IntFloatHashMap
implements IntFloatMap {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private int[] keys;
    private float[] values;
    private int capacity;
    private int size;
    private int threshold;
    private byte resizes;

    public IntFloatHashMap(int size) {
        int pot;
        if (size < 0 || size > 0x40000000) {
            throw new IllegalArgumentException("size " + size + " is out of bound <0, 2^30>");
        }
        for (pot = 1; pot < size; pot <<= 1) {
        }
        this.capacity = pot;
        this.size = 0;
        this.threshold = (int)((float)this.capacity * 0.75f);
        this.resizes = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return this.values == null ? 0 : this.values.length;
    }

    public float averageOpsPerAccess() {
        if (this.size() < 10) {
            return 0.0f;
        }
        IntFloatIterator iter = this.entries();
        int ops = 0;
        while (iter.hasNext()) {
            iter.next();
            int A = iter.getKey();
            boolean t = false;
            ++ops;
            int index = IntFloatHashMap.indexFor(IntFloatHashMap.hash(A, 0), this.keys.length);
            int k = this.keys[index];
            for (int tries = 1; k != 0 && k != A && tries < this.keys.length; ++tries) {
                index = IntFloatHashMap.indexFor(IntFloatHashMap.hash(A, tries), this.keys.length);
                k = this.keys[index];
                ++ops;
            }
        }
        return (float)ops / (float)this.size();
    }

    private int collisionInspection(boolean countMultiple) {
        int cs = 0;
        int cKeys = 0;
        if (this.capacity() == 0) {
            return 0;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == 0) continue;
            int key = this.keys[i];
            int t = 0;
            while (IntFloatHashMap.indexFor(IntFloatHashMap.hash(key, t), this.keys.length) != i) {
                ++t;
            }
            if (t > 0) {
                ++cKeys;
            }
            cs += t;
        }
        return countMultiple ? cs : cKeys;
    }

    @Override
    public int collisionKeys() {
        return this.collisionInspection(false);
    }

    @Override
    public int reallocations() {
        return this.resizes;
    }

    @Override
    public boolean isHash() {
        return true;
    }

    @Override
    public int collisions() {
        return this.collisionInspection(true);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public float get(int A) {
        if (this.values != null) {
            if (A == 0) {
                throw new IllegalArgumentException("0 is never a key of this map");
            }
            int index = IntFloatHashMap.indexFor(IntFloatHashMap.hash(A, 0), this.keys.length);
            int k = this.keys[index];
            for (int tries = 1; k != 0 && k != A && tries < this.keys.length; ++tries) {
                index = IntFloatHashMap.indexFor(IntFloatHashMap.hash(A, tries), this.keys.length);
                k = this.keys[index];
            }
            if (k == A) {
                return this.values[index];
            }
        }
        return 0.0f;
    }

    @Override
    public void put(int key, float value) {
        if (key <= 0) {
            throw new IllegalArgumentException("Non positive keys like " + key + " may not be entered into this map");
        }
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException("NaN may not be entered into this map");
        }
        this.allocate();
        int index = IntFloatHashMap.indexFor(IntFloatHashMap.hash(key, 0), this.keys.length);
        int k = this.keys[index];
        for (int tries = 1; k != 0 && k != key && tries < this.keys.length; ++tries) {
            index = IntFloatHashMap.indexFor(IntFloatHashMap.hash(key, tries), this.keys.length);
            k = this.keys[index];
        }
        if (k != 0 && k != key) {
            throw new RuntimeException("Map is full");
        }
        this.values[index] = value;
        if (k == 0) {
            this.keys[index] = key;
            ++this.size;
            if (this.size >= this.threshold) {
                this.resize(2 * this.keys.length);
            }
        }
    }

    @Override
    public void putIfGreater(int key, float value) {
        if (key == 0) {
            throw new IllegalArgumentException("0 may not be entered into this map");
        }
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException("NaN may not be entered into this map");
        }
        if (value < 0.0f) {
            return;
        }
        this.allocate();
        int index = IntFloatHashMap.indexFor(IntFloatHashMap.hash(key, 0), this.keys.length);
        int k = this.keys[index];
        for (int tries = 1; k != 0 && k != key && tries < this.keys.length; ++tries) {
            index = IntFloatHashMap.indexFor(IntFloatHashMap.hash(key, tries), this.keys.length);
            k = this.keys[index];
        }
        if (k != 0 && k != key) {
            throw new RuntimeException("Map is full");
        }
        float oldValue = this.values[index];
        if (k == 0) {
            this.keys[index] = key;
            this.values[index] = value;
            ++this.size;
            if (this.size >= this.threshold) {
                this.resize(2 * this.keys.length);
            }
        } else if (oldValue < value) {
            this.values[index] = value;
        }
    }

    private void resize(int newCapacity) {
        this.resizes = (byte)(this.resizes + 1);
        int[] oldKeys = this.keys;
        float[] oldValues = this.values;
        int oldCapacity = oldKeys.length;
        if (oldCapacity == Integer.MIN_VALUE) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        this.keys = new int[newCapacity];
        this.values = new float[newCapacity];
        Arrays.fill(this.values, Float.NaN);
        this.size = 0;
        this.threshold = (int)((float)newCapacity * 0.75f);
        for (int i = 0; i < oldKeys.length; ++i) {
            if (oldKeys[i] == 0) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }

    @Override
    public IntFloatIterator entries() {
        return this.values == null ? IntFloatIterator.Empty : new KeyValueIterator();
    }

    private static void checkSize(int size) {
        if (size > 0x40000000) {
            throw new IllegalArgumentException("size " + size + " is out of bound <0, 2^30>");
        }
    }

    private static int hash(int key, int tries) {
        return (int)((double)key + 0.5 * (double)tries + 0.5 * (double)tries * (double)tries);
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    private void allocate() {
        if (this.values == null) {
            this.values = new float[this.capacity];
            this.keys = new int[this.capacity];
        }
    }

    public class KeyValueIterator
    implements IntFloatIterator {
        private int index = -1;
        private int prevIndex = -1;

        public KeyValueIterator() {
            this.findNext();
        }

        @Override
        public void next() {
            this.prevIndex = this.index;
            this.findNext();
        }

        private void findNext() {
            if (this.index >= IntFloatHashMap.this.keys.length) {
                throw new NoSuchElementException();
            }
            do {
                ++this.index;
            } while (this.index < IntFloatHashMap.this.keys.length && IntFloatHashMap.this.keys[this.index] == 0);
        }

        @Override
        public int getKey() {
            if (this.prevIndex < 0 || this.prevIndex >= IntFloatHashMap.this.keys.length) {
                throw new NoSuchElementException();
            }
            return IntFloatHashMap.this.keys[this.prevIndex];
        }

        @Override
        public float getValue() {
            if (this.prevIndex < 0 || this.prevIndex >= IntFloatHashMap.this.keys.length) {
                throw new NoSuchElementException();
            }
            return IntFloatHashMap.this.values[this.prevIndex];
        }

        @Override
        public boolean hasNext() {
            return this.index < IntFloatHashMap.this.keys.length;
        }
    }
}

