/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign.map;

import de.unijena.bioinf.treealign.map.IntPairFloatIterator;
import de.unijena.bioinf.treealign.map.IntPairFloatMap;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class IntPairFloatArrayMap
implements IntPairFloatMap {
    private final int leftSize;
    private final int rightSize;
    private int size;
    private float[] values;

    public IntPairFloatArrayMap(int leftSize, int rightSize) {
        if (leftSize <= 0 || rightSize <= 0) {
            throw new IllegalArgumentException("leftSize and rightSize have to be greater than 0, but " + leftSize + " and " + rightSize + " given");
        }
        this.leftSize = leftSize;
        this.rightSize = rightSize;
        this.size = 0;
        this.values = null;
    }

    private void allocate() {
        if (this.values == null) {
            long size = (long)this.leftSize * (long)this.rightSize;
            if (size > Integer.MAX_VALUE) {
                throw new OutOfMemoryError();
            }
            this.values = new float[(int)size];
            Arrays.fill(this.values, Float.NaN);
        }
    }

    private void checkRange(int A, int B) {
        if (A >= this.leftSize) {
            throw new IndexOutOfBoundsException("left index " + A + " is out of bound " + this.leftSize);
        }
        if (B >= this.rightSize) {
            throw new IndexOutOfBoundsException("right index " + B + " is out of bound " + this.rightSize);
        }
        assert (this.values == null || A + B * this.leftSize < this.values.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return this.values == null ? 0 : this.values.length;
    }

    @Override
    public int collisions() {
        return 0;
    }

    @Override
    public int collisionKeys() {
        return 0;
    }

    @Override
    public int reallocations() {
        return 0;
    }

    @Override
    public boolean isHash() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public float get(int A, int B) {
        this.checkRange(A, B);
        if (this.values == null) {
            return 0.0f;
        }
        float value = this.values[A + B * this.leftSize];
        return Float.isNaN(value) ? 0.0f : value;
    }

    @Override
    public void put(int A, int B, float value) {
        this.checkRange(A, B);
        this.allocate();
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException("NaN values cannot be stored in this map");
        }
        int index = A + B * this.leftSize;
        if (Float.isNaN(this.values[index])) {
            ++this.size;
        }
        this.values[index] = value;
    }

    @Override
    public IntPairFloatMap.ReturnType putIfGreater(int A, int B, float value) {
        this.checkRange(A, B);
        if (value < 0.0f) {
            return IntPairFloatMap.ReturnType.LOWER;
        }
        this.allocate();
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException("NaN values cannot be stored in this map");
        }
        int index = A + B * this.leftSize;
        float val = this.values[index];
        if (Float.isNaN(val)) {
            ++this.size;
            this.values[index] = value;
            return IntPairFloatMap.ReturnType.NOT_EXIST;
        }
        if (val < value) {
            this.values[index] = value;
            return IntPairFloatMap.ReturnType.GREATER;
        }
        return IntPairFloatMap.ReturnType.LOWER;
    }

    @Override
    public IntPairFloatIterator entries() {
        if (this.values == null || this.values.length == 0) {
            return IntPairFloatIterator.Empty;
        }
        return new KeyValueIterator();
    }

    private class KeyValueIterator
    implements IntPairFloatIterator {
        private int index = -1;
        private int prevIndex = -1;
        private int A = 0;
        private int B = 0;

        private KeyValueIterator() {
            this.findNext();
        }

        protected void findNext() {
            do {
                ++this.index;
            } while (this.index < IntPairFloatArrayMap.this.values.length && Float.isNaN(IntPairFloatArrayMap.this.values[this.index]));
        }

        protected int getA() {
            return this.prevIndex % IntPairFloatArrayMap.this.leftSize;
        }

        protected int getB() {
            return this.prevIndex / IntPairFloatArrayMap.this.leftSize;
        }

        @Override
        public float getValue() {
            return IntPairFloatArrayMap.this.values[this.prevIndex];
        }

        @Override
        public boolean hasNext() {
            return this.index < IntPairFloatArrayMap.this.values.length;
        }

        @Override
        public int getLeft() {
            return this.A;
        }

        @Override
        public int getRight() {
            return this.B;
        }

        @Override
        public void next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prevIndex = this.index;
            this.A = this.getA();
            this.B = this.getB();
            this.findNext();
        }
    }
}

