/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign.map;

import de.unijena.bioinf.treealign.map.IntPairFloatIterator;
import de.unijena.bioinf.treealign.map.IntPairFloatMap;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class IntPairFloatHashMap
implements IntPairFloatMap {
    private static final long serialVersionUID = 1142899365261456647L;
    static final int DEFAULT_INITIAL_CAPACITY = 8;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MINIMUM_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private int[] As;
    private int[] Bs;
    private float[] values;
    private final int capacity;
    private byte resizes;
    private int size;
    private int threshold;
    final float loadFactor;

    public IntPairFloatHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (initialCapacity < 4) {
            initialCapacity = 4;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        this.resizes = 0;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.capacity = capacity;
    }

    public IntPairFloatHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntPairFloatHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 6;
        this.capacity = 8;
    }

    static int hash(int A, int B, int tries) {
        int h = A * (B << 1);
        h ^= h >> 7;
        return (int)((double)h + 0.5 * (double)tries + 0.5 * (double)tries * (double)tries);
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return this.values == null ? 0 : this.values.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public float get(int A, int B) {
        if (this.values == null) {
            return 0.0f;
        }
        if (A == 0 && B == 0) {
            return 0.0f;
        }
        int index = IntPairFloatHashMap.indexFor(IntPairFloatHashMap.hash(A, B, 0), this.values.length);
        int l = this.As[index];
        int r = this.Bs[index];
        for (int tries = 1; !(l == 0 && r == 0 || A == l && B == r || tries >= this.values.length); ++tries) {
            index = IntPairFloatHashMap.indexFor(IntPairFloatHashMap.hash(A, B, tries), this.values.length);
            l = this.As[index];
            r = this.Bs[index];
        }
        if (l == A && r == B) {
            return this.values[index];
        }
        return 0.0f;
    }

    @Override
    public void put(int A, int B, float value) {
        this.allocate();
        if (A == 0 && B == 0) {
            throw new IllegalArgumentException("0 is never a key of this map");
        }
        int index = IntPairFloatHashMap.indexFor(IntPairFloatHashMap.hash(A, B, 0), this.values.length);
        int l = this.As[index];
        int r = this.Bs[index];
        for (int tries = 1; !(l == 0 && r == 0 || A == l && B == r || tries >= this.values.length); ++tries) {
            index = IntPairFloatHashMap.indexFor(IntPairFloatHashMap.hash(A, B, tries), this.values.length);
            l = this.As[index];
            r = this.Bs[index];
        }
        if (l == A && r == B) {
            this.values[index] = value;
        } else if (l == 0 && r == 0) {
            this.values[index] = value;
            this.As[index] = A;
            this.Bs[index] = B;
            ++this.size;
            if (this.size >= this.threshold) {
                this.resize(2 * this.values.length);
            }
        } else {
            throw new RuntimeException("Map is full");
        }
    }

    @Override
    public IntPairFloatMap.ReturnType putIfGreater(int A, int B, float value) {
        if (value < 0.0f) {
            return IntPairFloatMap.ReturnType.LOWER;
        }
        this.allocate();
        if (A == 0 && B == 0) {
            throw new IllegalArgumentException("0 is never a key of this map");
        }
        int index = IntPairFloatHashMap.indexFor(IntPairFloatHashMap.hash(A, B, 0), this.values.length);
        int l = this.As[index];
        int r = this.Bs[index];
        for (int tries = 1; !(l == 0 && r == 0 || A == l && B == r || tries >= this.values.length); ++tries) {
            index = IntPairFloatHashMap.indexFor(IntPairFloatHashMap.hash(A, B, tries), this.values.length);
            l = this.As[index];
            r = this.Bs[index];
        }
        if (l == A && r == B) {
            if (value > this.values[index]) {
                this.values[index] = value;
                return IntPairFloatMap.ReturnType.GREATER;
            }
            return IntPairFloatMap.ReturnType.LOWER;
        }
        if (l == 0 && r == 0) {
            this.values[index] = value;
            this.As[index] = A;
            this.Bs[index] = B;
            ++this.size;
            if (this.size >= this.threshold) {
                this.resize(2 * this.values.length);
            }
            return IntPairFloatMap.ReturnType.NOT_EXIST;
        }
        throw new RuntimeException("Map is full");
    }

    public float averageOpsPerAccess() {
        if (this.size() < 10) {
            return 0.0f;
        }
        IntPairFloatIterator iter = this.entries();
        int ops = 0;
        while (iter.hasNext()) {
            iter.next();
            int A = iter.getLeft();
            int B = iter.getRight();
            boolean t = false;
            ++ops;
            int index = IntPairFloatHashMap.indexFor(IntPairFloatHashMap.hash(A, B, 0), this.values.length);
            int l = this.As[index];
            int r = this.Bs[index];
            for (int tries = 1; !(l == 0 && r == 0 || A == l && B == r || tries >= this.values.length); ++tries) {
                index = IntPairFloatHashMap.indexFor(IntPairFloatHashMap.hash(A, B, tries), this.values.length);
                l = this.As[index];
                r = this.Bs[index];
                ++ops;
            }
        }
        return (float)ops / (float)this.size();
    }

    private void allocate() {
        if (this.values == null) {
            try {
                this.As = new int[this.capacity];
                this.Bs = new int[this.capacity];
                this.values = new float[this.capacity];
                Arrays.fill(this.values, Float.NaN);
            }
            catch (OutOfMemoryError err) {
                System.err.println(this.capacity);
                throw new RuntimeException(err);
            }
        }
    }

    void resize(int newCapacity) {
        this.resizes = (byte)(this.resizes + 1);
        int[] oldAs = this.As;
        int[] oldBs = this.Bs;
        float[] oldValues = this.values;
        int oldCapacity = oldAs.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        this.As = new int[newCapacity];
        this.Bs = new int[newCapacity];
        this.values = new float[newCapacity];
        Arrays.fill(this.values, Float.NaN);
        this.size = 0;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        for (int i = 0; i < oldAs.length; ++i) {
            if (oldAs[i] == 0) continue;
            this.put(oldAs[i], oldBs[i], oldValues[i]);
        }
    }

    private int collisionInspection(boolean countMultiple) {
        if (this.capacity() == 0) {
            return 0;
        }
        int cs = 0;
        int cKeys = 0;
        if (this.capacity() == 0) {
            return 0;
        }
        for (int i = 0; i < this.As.length; ++i) {
            if (this.As[i] == 0 && this.Bs[i] == 0) continue;
            int A = this.As[i];
            int B = this.Bs[i];
            int t = 0;
            while (IntPairFloatHashMap.indexFor(IntPairFloatHashMap.hash(A, B, t), this.As.length) != i) {
                ++t;
            }
            if (t > 0) {
                ++cKeys;
            }
            cs += t;
        }
        return countMultiple ? cs : cKeys;
    }

    @Override
    public int collisionKeys() {
        return this.collisionInspection(false);
    }

    @Override
    public int reallocations() {
        return this.resizes;
    }

    @Override
    public boolean isHash() {
        return true;
    }

    @Override
    public int collisions() {
        return this.collisionInspection(true);
    }

    @Override
    public IntPairFloatIterator entries() {
        if (this.values == null) {
            return IntPairFloatIterator.Empty;
        }
        return new KeyIterator();
    }

    public class KeyIterator
    implements IntPairFloatIterator {
        private int index = 0;
        private int A = 0;
        private int B = 0;
        private float value = Float.NaN;
        private boolean initialized = false;

        public KeyIterator() {
            this.findNext();
        }

        private void findNext() {
            while (this.index < IntPairFloatHashMap.this.values.length && IntPairFloatHashMap.this.As[this.index] == 0 && IntPairFloatHashMap.this.Bs[this.index] == 0) {
                ++this.index;
            }
        }

        @Override
        public void next() {
            if (this.index >= IntPairFloatHashMap.this.As.length) {
                throw new NoSuchElementException();
            }
            this.A = IntPairFloatHashMap.this.As[this.index];
            this.B = IntPairFloatHashMap.this.Bs[this.index];
            this.value = IntPairFloatHashMap.this.values[this.index];
            this.initialized = true;
            ++this.index;
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.index < IntPairFloatHashMap.this.As.length;
        }

        @Override
        public int getLeft() {
            if (!this.initialized) {
                throw new NoSuchElementException();
            }
            return this.A;
        }

        @Override
        public int getRight() {
            if (!this.initialized) {
                throw new NoSuchElementException();
            }
            return this.B;
        }

        @Override
        public float getValue() {
            if (!this.initialized) {
                throw new NoSuchElementException();
            }
            return this.value;
        }
    }
}

