/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign.multijoin;

import de.unijena.bioinf.graphUtils.tree.PostOrderTraversal;
import de.unijena.bioinf.graphUtils.tree.TreeAdapter;
import de.unijena.bioinf.graphUtils.tree.TreeCursor;
import de.unijena.bioinf.treealign.Backtrace;
import de.unijena.bioinf.treealign.Set;
import de.unijena.bioinf.treealign.Tree;
import de.unijena.bioinf.treealign.TreeAlignmentAlgorithm;
import de.unijena.bioinf.treealign.TreeDecorator;
import de.unijena.bioinf.treealign.map.IntFloatIterator;
import de.unijena.bioinf.treealign.map.IntPairFloatIterator;
import de.unijena.bioinf.treealign.map.IntPairFloatMap;
import de.unijena.bioinf.treealign.multijoin.HashTable;
import de.unijena.bioinf.treealign.multijoin.MultiJoinTraceItem;
import de.unijena.bioinf.treealign.multijoin.TreeHashMap;
import de.unijena.bioinf.treealign.scoring.Scoring;
import de.unijena.bioinf.treealign.sparse.QueueItem;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DPMultiJoin<T>
implements TreeAlignmentAlgorithm<T> {
    private final Scoring<T> scoring;
    private final TreeAdapter<T> adapter;
    private final Tree<T> left;
    private final Tree<T> right;
    private final ArrayList<Tree<T>> leftVertices;
    private final ArrayList<Tree<T>> rightVertices;
    private final ArrayList<Tree<T>> leftLeafs;
    private final ArrayList<Tree<T>> rightLeafs;
    private final int maxDegree;
    private final ArrayDeque<MultiJoinTraceItem<T>> traceQueue;
    private final ArrayDeque<QueueItem>[] queues;
    private final short numberOfJoins;
    private final TreeHashMap tables;
    private float optScore;
    private Tree<T> optLeft;
    private Tree<T> optRight;
    private Backtrace<T> tracer;
    private boolean scoreRoot;

    public DPMultiJoin(Scoring<T> scoring, int numberOfJoins, T left, T right, TreeAdapter<T> adapter) {
        if (numberOfJoins < 0 || numberOfJoins > Short.MAX_VALUE) {
            throw new IllegalArgumentException("illegal value for numberOfJoins: " + numberOfJoins);
        }
        this.numberOfJoins = (short)numberOfJoins;
        this.adapter = adapter;
        this.scoring = scoring;
        int leftSize = TreeCursor.getCursor(left, adapter).numberOfVertices();
        int rightSize = TreeCursor.getCursor(right, adapter).numberOfVertices();
        this.leftVertices = new ArrayList(leftSize);
        this.rightVertices = new ArrayList(rightSize);
        this.leftLeafs = new ArrayList(leftSize);
        this.rightLeafs = new ArrayList(rightSize);
        TreeDecorator<T> leftDeco = new TreeDecorator<T>(this.leftVertices, this.leftLeafs);
        this.left = (Tree)new PostOrderTraversal(left, adapter).call(leftDeco);
        TreeDecorator<T> rightDeco = new TreeDecorator<T>(this.rightVertices, this.rightLeafs);
        this.right = (Tree)new PostOrderTraversal(right, adapter).call(rightDeco);
        this.maxDegree = Math.max(leftDeco.maxDegree, rightDeco.maxDegree);
        this.queues = new ArrayDeque[leftDeco.maxDegree + rightDeco.maxDegree];
        for (int i = 0; i < this.queues.length; ++i) {
            this.queues[i] = new ArrayDeque();
        }
        this.optScore = -1.0f;
        this.optLeft = null;
        this.optRight = null;
        this.traceQueue = new ArrayDeque();
        this.tables = new TreeHashMap(this.numberOfJoins, leftSize, rightSize);
        this.tracer = null;
        this.scoreRoot = false;
    }

    protected float scoreSubtreeRoots() {
        if (this.scoreRoot) {
            return this.optScore;
        }
        assert (this.left.isRoot());
        assert (this.right.isRoot());
        Iterator iter = PostOrderTraversal.create(this.left).iterator();
        float opt = 0.0f;
        while (iter.hasNext()) {
            Tree a = (Tree)iter.next();
            for (Tree b : PostOrderTraversal.create(this.right)) {
                HashTable table = this.tables.get(a.index, b.index);
                float newScore = table.getScore() + this.scoring.scoreVertices(a.label, b.label);
                if (!(newScore > opt)) continue;
                this.optLeft = a;
                this.optRight = b;
                opt = newScore;
            }
        }
        this.optScore = opt;
        this.scoreRoot = true;
        return this.optScore;
    }

    private void clearQueues() {
        for (ArrayDeque<QueueItem> queue : this.queues) {
            queue.clear();
        }
    }

    @Override
    public float compute() {
        float opt = 0.0f;
        for (int i = 0; i < this.leftVertices.size(); ++i) {
            Tree<T> u = this.leftVertices.get(i);
            short L = (short)Math.min(u.getDepth(), this.numberOfJoins);
            assert (u.getDepth() != 0 ? !u.isRoot() : u.isRoot()) : "" + u.getDepth() + " but u is root(" + u.isRoot() + ")";
            for (int j = 0; j < this.rightVertices.size(); ++j) {
                Tree<T> v = this.rightVertices.get(j);
                assert (v.getDepth() != 0 ? !v.isRoot() : v.isRoot()) : "" + v.getDepth() + " but v is root(" + v.isRoot() + ")";
                short R = (short)Math.min(v.getDepth(), this.numberOfJoins);
                HashTable<T> D = new HashTable<T>(u.children(), v.children(), L, R);
                this.tables.set(u.index, v.index, D);
                for (short l = 0; l <= L; l = (short)(l + 1)) {
                    for (short r = 0; r <= R; r = (short)(r + 1)) {
                        if (l == 0 && r == 0) continue;
                        this.clearQueues();
                        this.pushPairwisePreJoins(u, v, l, r, D);
                        for (int q = 0; q < this.queues.length; ++q) {
                            ArrayDeque<QueueItem> queue = this.queues[q];
                            while (!queue.isEmpty()) {
                                QueueItem item = queue.poll();
                                List<Tree<T>> As = Set.subList(u.children(), Set.of(u.children()) & ~item.A);
                                List<Tree<T>> Bs = Set.subList(v.children(), Set.of(v.children()) & ~item.B);
                                this.pushPreJoin(u, v, l, r, D, item.A, item.B, As, Bs, D.getJoin(l, r, item.A, item.B));
                            }
                        }
                    }
                }
                this.clearQueues();
                this.pushPairwiseMatches(u, v, D);
                this.pushDeleteLeft(u, v, D, 0, 0, u.children(), v.children(), 0.0f);
                this.pushDeleteRight(u, v, D, 0, 0, u.children(), v.children(), 0.0f);
                if (this.numberOfJoins > 0) {
                    this.pushJoin(u, v, D, 0, 0, u.children(), v.children(), 0.0f);
                }
                for (int q = 0; q < this.queues.length; ++q) {
                    ArrayDeque<QueueItem> queue = this.queues[q];
                    while (!queue.isEmpty()) {
                        QueueItem item = queue.poll();
                        List<Tree<T>> As = Set.subList(u.children(), (1 << u.degree()) - 1 & ~item.A);
                        List<Tree<T>> Bs = Set.subList(v.children(), (1 << v.degree()) - 1 & ~item.B);
                        float value = D.get(item.A, item.B);
                        assert (value > 0.0f);
                        this.pushDeleteLeft(u, v, D, item.A, item.B, As, Bs, value);
                        this.pushDeleteRight(u, v, D, item.A, item.B, As, Bs, value);
                        if (q <= 0) continue;
                        this.pushMatch(u, v, D, item.A, item.B, As, Bs, value);
                        if (this.numberOfJoins <= 0) continue;
                        this.pushJoin(u, v, D, item.A, item.B, As, Bs, value);
                    }
                }
                float newScore = this.vertexScore(D, u, v);
                if (!(newScore > opt)) continue;
                opt = newScore;
                this.optLeft = u;
                this.optRight = v;
            }
        }
        this.optScore = opt;
        if (this.scoring.isScoringVertices()) {
            return this.scoreSubtreeRoots();
        }
        return this.optScore;
    }

    private float vertexScore(HashTable<T> D, Tree<T> u, Tree<T> v) {
        return D.getScore();
    }

    private void pushPreJoin(Tree<T> u, Tree<T> v, short l, short r, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs, float value) {
        IntFloatIterator iter;
        HashTable S;
        int cardA;
        int A_;
        assert (l + r != 0);
        int asize = Integer.bitCount(A);
        int bsize = Integer.bitCount(B);
        for (Tree<T> a : As) {
            A_ = A | a.key;
            cardA = asize + 1;
            for (Tree<T> b : Bs) {
                float score = D.getJoin(l, r, a.key, b.key) + value;
                if (!(score > value)) continue;
                int B_ = B | b.key;
                int cardB = bsize + 1;
                switch (D.putJoinIfGreater(l, r, A_, B_, score)) {
                    case NOT_EXIST: {
                        this.queues[cardA + cardB - 1].offer(new QueueItem(A_, B_));
                    }
                    case GREATER: {
                        if (l > 0) {
                            D.putMaxJoinLeftIfGreater(l, r, B_, score);
                        }
                        if (r <= 0) break;
                        D.putMaxJoinRightIfGreater(l, r, A_, score);
                    }
                }
            }
        }
        if (l + 1 <= this.numberOfJoins) {
            for (Tree<T> a : As) {
                A_ = A | a.key;
                cardA = asize + 1;
                S = this.tables.get(a.index, v.index);
                iter = S.eachInMaxJoinLeft((short)(l + 1), r);
                while (iter.hasNext()) {
                    iter.next();
                    if ((iter.getKey() & B) != 0) continue;
                    int B_ = B | iter.getKey();
                    int cardB = Integer.bitCount(B_);
                    float score = value + iter.getValue();
                    switch (D.putJoinIfGreater(l, r, A_, B_, score)) {
                        case NOT_EXIST: {
                            this.queues[cardA + cardB - 1].offer(new QueueItem(A_, B_));
                        }
                        case GREATER: {
                            if (l > 0) {
                                D.putMaxJoinLeftIfGreater(l, r, B_, score);
                            }
                            if (r <= 0) break;
                            D.putMaxJoinRightIfGreater(l, r, A_, score);
                        }
                    }
                }
            }
        }
        if (r + 1 <= this.numberOfJoins) {
            for (Tree<T> b : Bs) {
                int B_ = B | b.key;
                int cardB = bsize + 1;
                S = this.tables.get(u.index, b.index);
                iter = S.eachInMaxJoinRight(l, (short)(r + 1));
                while (iter.hasNext()) {
                    iter.next();
                    if ((iter.getKey() & A) != 0) continue;
                    int A_2 = A | iter.getKey();
                    int cardA2 = Integer.bitCount(A_2);
                    float score = value + iter.getValue();
                    switch (D.putJoinIfGreater(l, r, A_2, B_, score)) {
                        case NOT_EXIST: {
                            this.queues[cardA2 + cardB - 1].offer(new QueueItem(A_2, B_));
                        }
                        case GREATER: {
                            if (l > 0) {
                                D.putMaxJoinLeftIfGreater(l, r, B_, score);
                            }
                            if (r <= 0) break;
                            D.putMaxJoinRightIfGreater(l, r, A_2, score);
                        }
                    }
                }
            }
        }
    }

    private void pushPairwisePreJoins(Tree<T> u, Tree<T> v, short l, short r, HashTable<T> D) {
        IntFloatIterator iter;
        HashTable S;
        assert (!(u.isRoot() && v.isRoot() || l > this.numberOfJoins || r > this.numberOfJoins));
        for (Tree<T> a : u.children()) {
            for (Tree<T> b : v.children()) {
                float score = this.scoring.join(a.eachAncestors(l), b.eachAncestors(r), l, r) + this.tables.get(a.index, b.index).getScore();
                if (!(score > 0.0f)) continue;
                D.setJoin(l, r, a.key, b.key, score);
                if (l > 0) {
                    D.putMaxJoinLeftIfGreater(l, r, b.key, score);
                }
                if (r > 0) {
                    D.putMaxJoinRightIfGreater(l, r, a.key, score);
                }
                this.queues[1].offer(new QueueItem(a.key, b.key));
            }
        }
        if (l + 1 <= this.numberOfJoins) {
            for (Tree<T> a : u.children()) {
                S = this.tables.get(a.index, v.index);
                iter = S.eachInMaxJoinLeft((short)(l + 1), r);
                while (iter.hasNext()) {
                    iter.next();
                    switch (D.putJoinIfGreater(l, r, a.key, iter.getKey(), iter.getValue())) {
                        case NOT_EXIST: {
                            this.queues[Integer.bitCount(iter.getKey())].offer(new QueueItem(a.key, iter.getKey()));
                        }
                        case GREATER: {
                            if (l > 0) {
                                D.putMaxJoinLeftIfGreater(l, r, iter.getKey(), iter.getValue());
                            }
                            if (r <= 0) break;
                            D.putMaxJoinRightIfGreater(l, r, a.key, iter.getValue());
                        }
                    }
                }
            }
        }
        if (r + 1 <= this.numberOfJoins) {
            for (Tree<T> b : v.children()) {
                S = this.tables.get(u.index, b.index);
                iter = S.eachInMaxJoinRight(l, (short)(r + 1));
                while (iter.hasNext()) {
                    iter.next();
                    switch (D.putJoinIfGreater(l, r, iter.getKey(), b.key, iter.getValue())) {
                        case NOT_EXIST: {
                            this.queues[Integer.bitCount(iter.getKey())].offer(new QueueItem(iter.getKey(), b.key));
                        }
                        case GREATER: {
                            if (r > 0) {
                                D.putMaxJoinRightIfGreater(l, r, iter.getKey(), iter.getValue());
                            }
                            if (l <= 0) break;
                            D.putMaxJoinLeftIfGreater(l, r, b.key, iter.getValue());
                        }
                    }
                }
            }
        }
    }

    private void pushPairwiseMatches(Tree<T> u, Tree<T> v, HashTable<T> D) {
        for (int i = 0; i < u.degree(); ++i) {
            Tree<T> a = u.children().get(i);
            for (int j = 0; j < v.degree(); ++j) {
                Tree<T> b = v.children().get(j);
                float score = this.scoring.match(a.label, b.label) + this.tables.get(a.index, b.index).getScore();
                if (!(score > 0.0f)) continue;
                D.set(a.key, b.key, score);
                D.putMaxLeftIfGreater(b.key, score);
                D.putMaxRightIfGreater(a.key, score);
                D.setScoreIfGreater(score);
                assert (D.get(a.key, b.key) > 0.0f);
                this.queues[1].offer(new QueueItem(a.key, b.key));
            }
        }
    }

    private void update(Tree<T> u, Tree<T> v, HashTable<T> D, int A, int B, float score) {
        assert (score > 0.0f);
        int cardA = Integer.bitCount(A);
        int cardB = Integer.bitCount(B);
        IntPairFloatMap.ReturnType inserted = D.putIfGreater(A, B, score);
        if (inserted != IntPairFloatMap.ReturnType.LOWER) {
            if (inserted == IntPairFloatMap.ReturnType.NOT_EXIST) {
                this.queues[cardA + cardB - 1].offer(new QueueItem(A, B));
                assert (D.get(A, B) > 0.0f);
            }
            D.putMaxLeftIfGreater(B, score);
            D.putMaxRightIfGreater(A, score);
            D.setScoreIfGreater(score);
        }
    }

    private void pushMatch(Tree<T> u, Tree<T> v, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs, float value) {
        for (Tree<T> a : As) {
            for (Tree<T> b : Bs) {
                float score = D.get(a.key, b.key) + value;
                if (!(score > value)) continue;
                this.update(u, v, D, A | a.key, B | b.key, score);
            }
        }
    }

    private void pushDeleteLeft(Tree<T> u, Tree<T> v, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs, float value) {
        for (Tree<T> a : As) {
            float gapScore = value + this.scoring.deleteLeft(a.label);
            HashTable T = this.tables.get(a.index, v.index);
            IntFloatIterator iter = T.eachInMaxLeft();
            while (iter.hasNext()) {
                float newValue;
                iter.next();
                int B_ = iter.getKey();
                if ((B & B_) != 0 || !((newValue = gapScore + iter.getValue()) > value)) continue;
                this.update(u, v, D, A | a.key, B | B_, newValue);
            }
        }
    }

    private void pushDeleteRight(Tree<T> u, Tree<T> v, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs, float value) {
        for (Tree<T> b : Bs) {
            float gapScore = value + this.scoring.deleteRight(b.label);
            HashTable T = this.tables.get(u.index, b.index);
            IntFloatIterator iter = T.eachInMaxRight();
            while (iter.hasNext()) {
                float newValue;
                iter.next();
                int A_ = iter.getKey();
                if ((A & A_) != 0 || !((newValue = gapScore + iter.getValue()) > value)) continue;
                this.update(u, v, D, A | A_, B | b.key, newValue);
            }
        }
    }

    private void pushJoin(Tree<T> u, Tree<T> v, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs, float value) {
        float score;
        IntFloatIterator iter;
        HashTable T;
        for (Tree<T> a : As) {
            T = this.tables.get(a.index, v.index);
            iter = T.eachInMaxJoinLeft((short)1, (short)0);
            while (iter.hasNext()) {
                iter.next();
                int B_ = iter.getKey();
                if ((B_ & B) != 0 || !((score = value + iter.getValue()) > value)) continue;
                this.update(u, v, D, A | a.key, B | B_, score);
            }
        }
        for (Tree<T> b : Bs) {
            T = this.tables.get(u.index, b.index);
            iter = T.eachInMaxJoinRight((short)0, (short)1);
            while (iter.hasNext()) {
                iter.next();
                int A_ = iter.getKey();
                if ((A_ & A) != 0 || !((score = value + iter.getValue()) > value)) continue;
                this.update(u, v, D, A | A_, B | b.key, score);
            }
        }
    }

    @Override
    public void backtrace(Backtrace<T> tracer) {
        float score;
        if (this.optScore <= 0.0f) {
            return;
        }
        this.traceQueue.clear();
        this.tracer = tracer;
        if (this.scoreRoot) {
            tracer.matchVertices(this.optScore - this.tables.get(this.optLeft.index, this.optRight.index).getScore(), this.optLeft.label, this.optRight.label);
            score = this.tables.get(this.optLeft.index, this.optRight.index).getScore();
        } else {
            score = this.optScore;
        }
        if (score <= 0.0f) {
            return;
        }
        this.addTraceItemFor(this.optLeft, this.optRight, score);
        while (!this.traceQueue.isEmpty()) {
            MultiJoinTraceItem<T> item = this.traceQueue.poll();
            List<Tree<T>> As = Set.subList(item.u.children(), item.A);
            List<Tree<T>> Bs = Set.subList(item.v.children(), item.B);
            HashTable D = this.tables.get(item.u.index, item.v.index);
            float opt = item.l == 0 && item.r == 0 ? D.get(item.A, item.B) : D.getJoin(item.l, item.r, item.A, item.B);
            if (opt == 0.0f) continue;
            boolean found = item.l == 0 && item.r == 0 ? this.traceMatch(item.u, item.v, opt, D, item.A, item.B, As, Bs) || this.traceDeleteLeft(item.u, item.v, opt, D, item.A, item.B, As, Bs) || this.traceDeleteRight(item.u, item.v, opt, D, item.A, item.B, As, Bs) || this.traceMultiJoin(item.u, item.v, opt, D, item.A, item.B, As, Bs, item.l, item.r) : this.traceMultiJoin(item.u, item.v, opt, D, item.A, item.B, As, Bs, item.l, item.r);
            assert (found);
        }
    }

    private boolean addTraceItemFor(Tree<T> u, Tree<T> v, float opt) {
        return this.addTraceItemFor(u, v, Set.of(u.children()), Set.of(v.children()), opt);
    }

    private boolean addTraceItemFor(Tree<T> u, Tree<T> v, int A, int B, float opt) {
        HashTable D = this.tables.get(u.index, v.index);
        IntPairFloatIterator iter = D.each();
        while (iter.hasNext()) {
            iter.next();
            if (!(iter.getValue() >= opt) || (iter.getLeft() & A) != iter.getLeft() || (iter.getRight() & B) != iter.getRight()) continue;
            assert (iter.getValue() == opt);
            this.traceQueue.offerFirst(new MultiJoinTraceItem<T>(u, v, iter.getLeft(), iter.getRight()));
            return true;
        }
        assert (false);
        return false;
    }

    private boolean addTraceItemFor(Tree<T> u, Tree<T> v, short l, short r, int A, int B, float opt) {
        HashTable D = this.tables.get(u.index, v.index);
        IntPairFloatIterator iter = D.eachInJoin(l, r);
        while (iter.hasNext()) {
            iter.next();
            if (!(iter.getValue() >= opt) || (iter.getLeft() & A) != iter.getLeft() || (iter.getRight() & B) != iter.getRight()) continue;
            assert (iter.getValue() == opt);
            this.traceQueue.offerFirst(new MultiJoinTraceItem<T>(u, v, iter.getLeft(), iter.getRight(), l, r));
            return true;
        }
        assert (false);
        return false;
    }

    private boolean traceMultiJoin(Tree<T> u, Tree<T> v, float opt, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs, short l, short r) {
        IntFloatIterator iter;
        HashTable S;
        float restScore;
        float score;
        float optScore = opt;
        if (l > 0 || r > 0) {
            block0: for (Tree<T> a : As) {
                for (Tree<T> b : Bs) {
                    if ((b.key & B) != b.key || !((score = D.getJoin(l, r, a.key, b.key)) + (restScore = D.getJoin(l, r, A & ~a.key, B & ~b.key)) >= optScore) || a.degree() > 0 && l < this.numberOfJoins && this.tables.get(a.index, v.index).getMaxJoinLeft((short)(l + 1), r, b.key) == score || b.degree() > 0 && r < this.numberOfJoins && this.tables.get(u.index, b.index).getMaxJoinRight(l, (short)(r + 1), a.key) == score) continue;
                    float subtreeScore = this.tables.get(a.index, b.index).getScore();
                    assert ((double)Math.abs((optScore -= score) - restScore) < 1.0E-6);
                    this.tracer.join(score - subtreeScore, a.eachAncestors(l), b.eachAncestors(r), l, r);
                    if (subtreeScore > 0.0f) {
                        this.addTraceItemFor(a, b, subtreeScore);
                    }
                    if (restScore == 0.0f) {
                        return true;
                    }
                    A &= ~a.key;
                    B &= ~b.key;
                    continue block0;
                }
            }
        }
        if (l + 1 <= this.numberOfJoins) {
            block2: for (Tree<T> a : As) {
                if ((a.key & A) != a.key) continue;
                S = this.tables.get(a.index, v.index);
                iter = S.eachInMaxJoinLeft((short)(l + 1), r);
                while (iter.hasNext()) {
                    iter.next();
                    if ((iter.getKey() & B) != iter.getKey()) continue;
                    score = iter.getValue();
                    float f = l == 0 && r == 0 ? D.get(A & ~a.key, B & ~iter.getKey()) : D.getJoin(l, r, A & ~a.key, B & ~iter.getKey());
                    restScore = f;
                    if (!(score + restScore >= optScore)) continue;
                    assert ((optScore -= score) == restScore);
                    this.tracer.innerJoinLeft(a.label);
                    this.addTraceItemFor(a, v, (short)(l + 1), r, Set.of(a.children()), iter.getKey(), score);
                    if (restScore == 0.0f) {
                        return true;
                    }
                    A &= ~a.key;
                    B &= ~iter.getKey();
                    continue block2;
                }
            }
        }
        if (r + 1 <= this.numberOfJoins) {
            block4: for (Tree<T> b : Bs) {
                if ((b.key & B) != b.key) continue;
                S = this.tables.get(u.index, b.index);
                iter = S.eachInMaxJoinRight(l, (short)(r + 1));
                while (iter.hasNext()) {
                    iter.next();
                    if ((iter.getKey() & A) != iter.getKey()) continue;
                    score = iter.getValue();
                    float f = l == 0 && r == 0 ? D.get(A & ~iter.getKey(), B & ~b.key) : D.getJoin(l, r, A & ~iter.getKey(), B & ~b.key);
                    restScore = f;
                    if (!(score + restScore >= optScore)) continue;
                    assert ((optScore -= score) == restScore);
                    this.tracer.innerJoinRight(b.label);
                    this.addTraceItemFor(u, b, l, (short)(r + 1), iter.getKey(), Set.of(b.children()), score);
                    A &= ~iter.getKey();
                    B &= ~b.key;
                    if (optScore != 0.0f) continue block4;
                    return true;
                }
            }
        }
        if (l == 0 && r == 0 && optScore < opt) {
            return this.addTraceItemFor(u, v, A, B, optScore);
        }
        return optScore == 0.0f;
    }

    private boolean traceMatch(Tree<T> u, Tree<T> v, float opt, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        for (Tree<T> a : As) {
            int A_ = A & ~a.key;
            for (Tree<T> b : Bs) {
                int B_ = B & ~b.key;
                float pre = D.get(A_, B_);
                float matchScore = this.scoring.match(a.label, b.label);
                float subtreeScore = this.tables.get(a.index, b.index).getScore();
                float score = subtreeScore + pre + matchScore;
                if (!(score >= opt)) continue;
                assert ((double)Math.abs(score - opt) < 1.0E-6) : score + " from match is greater than opt: " + opt;
                this.tracer.match(matchScore, a.label, b.label);
                if (pre > 0.0f) {
                    this.traceQueue.offerFirst(new MultiJoinTraceItem<T>(u, v, A_, B_));
                }
                if (a.degree() > 0 && b.degree() > 0 && subtreeScore > 0.0f) {
                    this.addTraceItemFor(a, b, subtreeScore);
                }
                return true;
            }
        }
        return false;
    }

    private boolean traceDeleteLeft(Tree<T> u, Tree<T> v, float opt, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        for (Tree<T> a : As) {
            int A_ = A & ~a.key;
            IntFloatIterator iter = this.tables.get(a.index, v.index).eachInMaxLeft();
            while (iter.hasNext()) {
                iter.next();
                int B_ = iter.getKey();
                if ((B & B_) != B_) continue;
                int BB = B & ~B_;
                float deleteScore = this.scoring.deleteLeft(a.label);
                float pre = D.get(A_, BB);
                float score = iter.getValue() + deleteScore + pre;
                if (!(score >= opt)) continue;
                assert (iter.getValue() > 0.0f);
                assert (score == opt);
                this.tracer.deleteLeft(deleteScore, a.label);
                if (a.degree() > 0) {
                    this.addTraceItemFor(a, v, Set.of(a.children()), B_, iter.getValue());
                }
                if (pre > 0.0f) {
                    this.addTraceItemFor(u, v, A_, BB, pre);
                }
                return true;
            }
        }
        return false;
    }

    private boolean traceDeleteRight(Tree<T> u, Tree<T> v, float opt, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        for (Tree<T> b : Bs) {
            int B_ = B & ~b.key;
            IntFloatIterator iter = this.tables.get(u.index, b.index).eachInMaxRight();
            while (iter.hasNext()) {
                iter.next();
                int A_ = iter.getKey();
                if ((A & A_) != A_) continue;
                int AA = A & ~A_;
                float deleteScore = this.scoring.deleteRight(b.label);
                float pre = D.get(AA, B_);
                float score = iter.getValue() + deleteScore + pre;
                if (!(score >= opt)) continue;
                assert (iter.getValue() > 0.0f);
                assert (score == opt);
                this.tracer.deleteRight(deleteScore, b.label);
                if (b.degree() > 0) {
                    this.addTraceItemFor(u, b, A_, Set.of(b.children()), iter.getValue());
                }
                if (pre > 0.0f) {
                    this.addTraceItemFor(u, v, AA, B_, pre);
                }
                return true;
            }
        }
        return false;
    }
}

